/*
 * Decompiled with CFR 0.152.
 */
package io.github.larscom.websocket;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.github.larscom.websocket.Action;
import io.github.larscom.websocket.Channel;
import io.github.larscom.websocket.ChannelName;
import io.github.larscom.websocket.Either;
import io.github.larscom.websocket.Error;
import io.github.larscom.websocket.MessageIn;
import io.github.larscom.websocket.MessageOut;
import io.github.larscom.websocket.Subscription;
import io.github.larscom.websocket.WebSocket;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class WebSocketListener {
    private boolean running = false;
    private WebSocket webSocket;
    private final PublishSubject<Either<MessageIn, Error>> messagePublisher = PublishSubject.create();

    public WebSocketListener() throws InterruptedException {
        this.startBlocking();
    }

    public Flowable<Either<MessageIn, Error>> stream() {
        return this.messagePublisher.toFlowable(BackpressureStrategy.BUFFER);
    }

    public void subscribe(List<Channel> channels) throws JsonProcessingException {
        if (this.running) {
            MessageOut message = MessageOut.builder().action(Action.SUBSCRIBE).channels(channels).build();
            this.webSocket.send(message);
        }
    }

    public void unsubscribe(List<Channel> channels) throws JsonProcessingException {
        if (this.running) {
            MessageOut message = MessageOut.builder().action(Action.UNSUBSCRIBE).channels(channels).build();
            this.webSocket.send(message);
        }
    }

    public void close() {
        this.running = false;
        this.webSocket.terminate();
    }

    private void startBlocking() throws InterruptedException {
        this.running = true;
        CountDownLatch startLatch = new CountDownLatch(1);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new Jdk8Module());
        HashMap activeSubscriptions = new HashMap();
        Thread.startVirtualThread(() -> {
            while (this.running) {
                try {
                    this.webSocket = new WebSocket(objectMapper);
                    if (this.webSocket.connectBlocking()) {
                        startLatch.countDown();
                        if (!activeSubscriptions.isEmpty()) {
                            MessageOut message = MessageOut.builder().action(Action.SUBSCRIBE).channels(WebSocketListener.mapToChannels(activeSubscriptions)).build();
                            this.webSocket.send(message);
                        }
                        this.webSocket.stream().subscribe(either -> {
                            Object patt0$temp;
                            if (either.isLeft() && (patt0$temp = either.getLeft()) instanceof Subscription) {
                                Subscription subscription = (Subscription)patt0$temp;
                                activeSubscriptions.clear();
                                activeSubscriptions.putAll(subscription.getActiveSubscriptions());
                            }
                            this.messagePublisher.onNext(either);
                        });
                        this.webSocket.blockUntilClosed();
                        continue;
                    }
                    Thread.sleep(2000L);
                }
                catch (JsonProcessingException | InterruptedException | URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        startLatch.await();
    }

    private static List<Channel> mapToChannels(HashMap<ChannelName, List<String>> subscriptions) {
        return subscriptions.entrySet().stream().map(entry -> Channel.builder().name((ChannelName)((Object)((Object)entry.getKey()))).markets((Iterable)entry.getValue()).build()).toList();
    }
}

