
package io.github.mainstringargs.domain.alpaca.websocket.account;

import java.io.Serializable;
import io.github.mainstringargs.domain.alpaca.account.Account;


/**
 * See <a href="https://docs.alpaca.markets/api-documentation/api-v2/streaming/">https://docs.alpaca.markets/api-documentation/api-v2/streaming/</a>
 * <p>
 * 
 * 
 */
public class AccountUpdate
    extends Account
    implements Serializable
{

    private final static long serialVersionUID = 3861623373775392322L;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AccountUpdate.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString!= null) {
            int contentStart = superString.indexOf('[');
            int contentEnd = superString.lastIndexOf(']');
            if ((contentStart >= 0)&&(contentEnd >contentStart)) {
                sb.append(superString, (contentStart + 1), contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length()>baseLength) {
            sb.append(',');
        }
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+ super.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof AccountUpdate) == false) {
            return false;
        }
        AccountUpdate rhs = ((AccountUpdate) other);
        return super.equals(rhs);
    }

}
