/*
 * Decompiled with CFR 0.152.
 */
package dev.masterflomaster1.jwa;

import dev.masterflomaster1.jwa.request.action.AbstractAction;
import lombok.Generated;

public final class WikiApiRequest {
    private String url = "https://en.wikipedia.org/w/api.php";
    private AbstractAction action;
    private String assertUser;
    private String requestId;
    private boolean servedBy;
    private boolean curTimestamp;
    private boolean responseLangInfo;
    private String useLang;
    private String variant;

    private WikiApiRequest() {
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public AbstractAction getAction() {
        return this.action;
    }

    @Generated
    public String getAssertUser() {
        return this.assertUser;
    }

    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public boolean isServedBy() {
        return this.servedBy;
    }

    @Generated
    public boolean isCurTimestamp() {
        return this.curTimestamp;
    }

    @Generated
    public boolean isResponseLangInfo() {
        return this.responseLangInfo;
    }

    @Generated
    public String getUseLang() {
        return this.useLang;
    }

    @Generated
    public String getVariant() {
        return this.variant;
    }

    @Generated
    public String toString() {
        return "WikiApiRequest(url=" + this.getUrl() + ", action=" + this.getAction() + ", assertUser=" + this.getAssertUser() + ", requestId=" + this.getRequestId() + ", servedBy=" + this.isServedBy() + ", curTimestamp=" + this.isCurTimestamp() + ", responseLangInfo=" + this.isResponseLangInfo() + ", useLang=" + this.getUseLang() + ", variant=" + this.getVariant() + ")";
    }

    public static class Builder {
        private final WikiApiRequest wikiApiRequest = new WikiApiRequest();

        public Builder action(AbstractAction action) {
            this.wikiApiRequest.action = action;
            this.wikiApiRequest.url = this.wikiApiRequest.url + action.getApiUrl().build();
            return this;
        }

        public Builder assertUser(String assertUser) {
            this.wikiApiRequest.assertUser = assertUser;
            this.wikiApiRequest.url = this.wikiApiRequest.url + "&assertuser=" + assertUser;
            return this;
        }

        public Builder requestId(String requestId) {
            this.wikiApiRequest.requestId = requestId;
            this.wikiApiRequest.url = this.wikiApiRequest.url + "&requestid=" + requestId;
            return this;
        }

        public Builder servedBy() {
            this.wikiApiRequest.servedBy = true;
            this.wikiApiRequest.url = this.wikiApiRequest.url + "&servedby=1";
            return this;
        }

        public Builder curTimestamp() {
            this.wikiApiRequest.curTimestamp = true;
            this.wikiApiRequest.url = this.wikiApiRequest.url + "&curtimestamp=1";
            return this;
        }

        public Builder responseLangInfo() {
            this.wikiApiRequest.responseLangInfo = true;
            this.wikiApiRequest.url = this.wikiApiRequest.url + "&responselanginfo=1";
            return this;
        }

        public Builder useLang(String useLang) {
            this.wikiApiRequest.useLang = useLang;
            this.wikiApiRequest.url = this.wikiApiRequest.url + "&uselang=" + useLang;
            return this;
        }

        public Builder variant(String variant) {
            this.wikiApiRequest.variant = variant;
            this.wikiApiRequest.url = this.wikiApiRequest.url + "&variant=" + variant;
            return this;
        }

        public WikiApiRequest build() {
            if (this.wikiApiRequest.action == null) {
                throw new IllegalArgumentException("You must specify one action to generate a request");
            }
            this.wikiApiRequest.url = this.wikiApiRequest.url + "&format=json";
            this.wikiApiRequest.url = this.wikiApiRequest.url + "&formatversion=2";
            return this.wikiApiRequest;
        }
    }
}

