/*
 * Decompiled with CFR 0.152.
 */
package dev.masterflomaster1.jwa.request.action;

import dev.masterflomaster1.jwa.internal.EnumValueProvider;
import dev.masterflomaster1.jwa.request.AbstractBuilder;
import dev.masterflomaster1.jwa.request.action.AbstractAction;
import dev.masterflomaster1.jwa.request.action.IPost;
import lombok.Generated;
import okhttp3.FormBody;

public final class DeleteAction
extends AbstractAction
implements IPost {
    private String title;
    private int pageId;
    private String reason;
    private boolean deleteTalk;
    private Watchlist watchlist;
    private String watchlistExpiry;
    private String oldImage;
    private String token;

    private DeleteAction() {
        this.apiUrl.setAction("delete");
    }

    @Override
    public FormBody getPostBody() {
        return new FormBody.Builder().add("token", this.token).build();
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public int getPageId() {
        return this.pageId;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public boolean isDeleteTalk() {
        return this.deleteTalk;
    }

    @Generated
    public Watchlist getWatchlist() {
        return this.watchlist;
    }

    @Generated
    public String getWatchlistExpiry() {
        return this.watchlistExpiry;
    }

    @Generated
    public String getOldImage() {
        return this.oldImage;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public String toString() {
        return "DeleteAction(title=" + this.getTitle() + ", pageId=" + this.getPageId() + ", reason=" + this.getReason() + ", deleteTalk=" + this.isDeleteTalk() + ", watchlist=" + this.getWatchlist() + ", watchlistExpiry=" + this.getWatchlistExpiry() + ", oldImage=" + this.getOldImage() + ", token=" + this.getToken() + ")";
    }

    public static enum Watchlist implements EnumValueProvider
    {
        NO_CHANGE("nochange"),
        PREFERENCES("preferences"),
        UNWATCH("unwatch"),
        WATCH("watch");

        private final String value;

        private Watchlist(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Builder
    extends AbstractBuilder {
        private final DeleteAction deleteAction = new DeleteAction();

        public Builder title(String title) {
            this.deleteAction.title = title;
            this.deleteAction.apiUrl.putQuery("title", title);
            return this;
        }

        public Builder pageId(int pageId) {
            this.deleteAction.pageId = pageId;
            this.deleteAction.apiUrl.putQuery("pageid", pageId);
            return this;
        }

        public Builder reason(String reason) {
            this.deleteAction.reason = reason;
            this.deleteAction.apiUrl.putQuery("reason", reason);
            return this;
        }

        public Builder deleteTalk() {
            this.deleteAction.deleteTalk = true;
            this.deleteAction.apiUrl.putQuery("deletetalk", "1");
            return this;
        }

        public Builder watchlist(Watchlist watchlist) {
            this.deleteAction.watchlist = watchlist;
            this.deleteAction.apiUrl.putQuery("watchlist", watchlist.getValue());
            return this;
        }

        public Builder watchlistExpiry(String watchlistExpiry) {
            this.deleteAction.watchlistExpiry = watchlistExpiry;
            this.deleteAction.apiUrl.putQuery("watchlistexpiry", watchlistExpiry);
            return this;
        }

        public Builder oldImage(String oldImage) {
            this.deleteAction.oldImage = oldImage;
            this.deleteAction.apiUrl.putQuery("oldimage", oldImage);
            return this;
        }

        public Builder token(String token) {
            this.deleteAction.token = token;
            this.deleteAction.apiUrl.putQuery("token", token);
            return this;
        }

        public DeleteAction build() {
            if (this.deleteAction.token == null) {
                throw new IllegalArgumentException("Parameter 'token' is required");
            }
            return this.deleteAction;
        }
    }
}

