/*
 * Decompiled with CFR 0.152.
 */
package dev.masterflomaster1.jwa.request.action;

import dev.masterflomaster1.jwa.common.Namespace;
import dev.masterflomaster1.jwa.internal.EnumValueProvider;
import dev.masterflomaster1.jwa.request.AbstractBuilder;
import dev.masterflomaster1.jwa.request.action.AbstractAction;
import java.util.EnumSet;
import lombok.Generated;

public final class OpenSearchAction
extends AbstractAction {
    private String search;
    private EnumSet<Namespace> namespace;
    private int limit;
    private Profile profile;
    private Redirects redirects;
    private Format format;
    private boolean warningsAsError;

    private OpenSearchAction() {
        this.apiUrl.setAction("opensearch");
    }

    @Generated
    public String getSearch() {
        return this.search;
    }

    @Generated
    public EnumSet<Namespace> getNamespace() {
        return this.namespace;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public Profile getProfile() {
        return this.profile;
    }

    @Generated
    public Redirects getRedirects() {
        return this.redirects;
    }

    @Generated
    public Format getFormat() {
        return this.format;
    }

    @Generated
    public boolean isWarningsAsError() {
        return this.warningsAsError;
    }

    @Generated
    public String toString() {
        return "OpenSearchAction(search=" + this.getSearch() + ", namespace=" + this.getNamespace() + ", limit=" + this.getLimit() + ", profile=" + this.getProfile() + ", redirects=" + this.getRedirects() + ", format=" + this.getFormat() + ", warningsAsError=" + this.isWarningsAsError() + ")";
    }

    public static enum Profile implements EnumValueProvider
    {
        CLASSIC("classic"),
        ENGINE_AUTO_SELECT("engine_autoselect"),
        FAST_FUZZY("fast-fuzzy"),
        FUZZY("fuzzy"),
        NORMAL("normal"),
        STRICT("strict");

        private final String value;

        private Profile(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum Redirects implements EnumValueProvider
    {
        RESOLVE("resolve"),
        RETURN("return");

        private final String value;

        private Redirects(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum Format implements EnumValueProvider
    {
        JSON("json"),
        JSON_FM("jsonfm"),
        XML("xml"),
        XML_FM("xml");

        private final String value;

        private Format(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Builder
    extends AbstractBuilder {
        private final OpenSearchAction openSearchAction = new OpenSearchAction();

        public Builder search(String search) {
            this.openSearchAction.search = search;
            this.openSearchAction.apiUrl.putQuery("search", search);
            return this;
        }

        public Builder namespace(EnumSet<Namespace> namespace) {
            this.openSearchAction.namespace = namespace;
            this.openSearchAction.apiUrl.putQuery("namespace", this.merge(namespace));
            return this;
        }

        public Builder limit(int limit) {
            this.openSearchAction.limit = limit;
            this.openSearchAction.apiUrl.putQuery("limit", limit);
            return this;
        }

        public Builder profile(Profile profile) {
            this.openSearchAction.profile = profile;
            this.openSearchAction.apiUrl.putQuery("profile", profile.getValue());
            return this;
        }

        public Builder redirects(Redirects redirects) {
            this.openSearchAction.redirects = redirects;
            this.openSearchAction.apiUrl.putQuery("redirects", redirects.getValue());
            return this;
        }

        public Builder format(Format format) {
            this.openSearchAction.format = format;
            this.openSearchAction.apiUrl.putQuery("format", format.getValue());
            return this;
        }

        public Builder warningsAsError() {
            this.openSearchAction.warningsAsError = true;
            this.openSearchAction.apiUrl.putQuery("warningsaserror", "1");
            return this;
        }

        public OpenSearchAction build() {
            if (this.openSearchAction.search == null) {
                throw new IllegalArgumentException("Parameter 'search' is required");
            }
            return this.openSearchAction;
        }
    }
}

