/*
 * Decompiled with CFR 0.152.
 */
package dev.masterflomaster1.jwa.util;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class WikiApiUrl {
    private String action;
    private final HashMap<String, String> map = new HashMap();
    private final HashMap<String, String> propMap = new HashMap();
    private final HashMap<String, String> listMap = new HashMap();
    private final HashMap<String, String> metaMap = new HashMap();

    public void putQuery(String k, Object v) {
        this.map.put(k, v.toString());
    }

    public void putProp(String k, String v) {
        this.propMap.put(k, v);
    }

    public void putList(String k, String v) {
        this.listMap.put(k, v);
    }

    public void putMeta(String k, String v) {
        this.metaMap.put(k, v);
    }

    public void appendQuery(String k, String v) {
        v = URLEncoder.encode(v, StandardCharsets.UTF_8);
        if (this.map.containsKey(k)) {
            this.map.put(k, this.map.get(k) + "|" + v);
        } else {
            this.map.put(k, v);
        }
    }

    public String build() {
        StringBuilder urlBuilder = new StringBuilder();
        if (this.action != null) {
            urlBuilder.append("?action=").append(this.action);
        }
        if (!this.propMap.isEmpty()) {
            urlBuilder.append("&prop=").append(String.join((CharSequence)"%7C", this.propMap.keySet())).append(String.join((CharSequence)"", this.propMap.values()));
        }
        if (!this.listMap.isEmpty()) {
            urlBuilder.append("&list=").append(String.join((CharSequence)"%7C", this.listMap.keySet())).append(String.join((CharSequence)"", this.listMap.values()));
        }
        if (!this.metaMap.isEmpty()) {
            urlBuilder.append("&meta=").append(String.join((CharSequence)"%7C", this.metaMap.keySet())).append(String.join((CharSequence)"", this.metaMap.values()));
        }
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            urlBuilder.append("&").append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8).replace("+", "%20"));
        }
        return urlBuilder.toString();
    }

    @Generated
    public void setAction(String action) {
        this.action = action;
    }
}

