/*
 * Decompiled with CFR 0.152.
 */
package io.github.msyysoft.java.database;

import io.github.msyysoft.java.database.SqlTemplateUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.CollectionUtils;

public abstract class AbstractDao {
    private NamedParameterJdbcTemplate a;
    private JdbcTemplate b;

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        if (this.a == null) {
            this.a = new NamedParameterJdbcTemplate(this.getDataSource());
        }
        return this.a;
    }

    public JdbcTemplate getJdbcTemplate() {
        if (this.b == null) {
            this.b = new JdbcTemplate(this.getDataSource());
        }
        return this.b;
    }

    public abstract DataSource getDataSource();

    public List<Map<String, Object>> queryForListByTemplate(String string) {
        return this.queryForListByTemplate(string, new HashMap<String, Object>());
    }

    public List<Map<String, Object>> queryForListByTemplate(String string, Map<String, Object> map) {
        string = SqlTemplateUtil.getInstance().getSqlString(string, map);
        return this.getNamedParameterJdbcTemplate().queryForList(string, map);
    }

    public List<Map<String, Object>> pagingForListByTemplate(String string, int n, int n2) {
        return this.pagingForListByTemplate(string, n, n2, new HashMap<String, Object>());
    }

    public List<Map<String, Object>> pagingForListByTemplate(String string, int n, int n2, Map<String, Object> map) {
        string = SqlTemplateUtil.getInstance().getPageSqlString(string, n, n2, map);
        return this.getNamedParameterJdbcTemplate().queryForList(string, map);
    }

    public int recordNumberForListByTemplate(String string) {
        return this.recordNumberForListByTemplate(string, new HashMap<String, Object>());
    }

    public int recordNumberForListByTemplate(String object, Map<String, Object> map) {
        object = SqlTemplateUtil.getInstance().getRecordNumberSqlString((String)object, map);
        object = this.getNamedParameterJdbcTemplate().queryForList((String)object, map);
        if (CollectionUtils.isEmpty((Collection)object)) {
            return 0;
        }
        return Integer.parseInt(((Map)object.get(0)).get("num").toString());
    }

    public int updateByTemplate(String string, Map<String, Object> map) {
        string = SqlTemplateUtil.getInstance().getSqlString(string, map);
        return this.getNamedParameterJdbcTemplate().update(string, (SqlParameterSource)new MapSqlParameterSource(map));
    }

    public int[] batchUpdateByTemplate(String string, Map<String, Object> map, Map<String, Object>[] mapArray) {
        string = SqlTemplateUtil.getInstance().getSqlString(string, map);
        return this.getNamedParameterJdbcTemplate().batchUpdate(string, (Map[])mapArray);
    }

    public int[] batchUpdateByTemplate(String string, Map<String, Object> sqlParameterSourceArray, List<Map<String, ?>> object) {
        string = SqlTemplateUtil.getInstance().getSqlString(string, (Map<String, Object>)sqlParameterSourceArray);
        sqlParameterSourceArray = new SqlParameterSource[object.size()];
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Map map = (Map)object.next();
            sqlParameterSourceArray[n] = new MapSqlParameterSource(map);
            ++n;
        }
        return this.getNamedParameterJdbcTemplate().batchUpdate(string, sqlParameterSourceArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTableExists(String object) throws SQLException {
        boolean bl;
        Connection connection = null;
        try {
            connection = this.getJdbcTemplate().getDataSource().getConnection();
            object = connection.getMetaData().getTables(null, null, (String)object, new String[]{"TABLE"});
            bl = object.next();
            if (connection == null) return bl;
        }
        catch (SQLException sQLException) {
            try {
                object = sQLException;
                throw sQLException;
            }
            catch (Throwable throwable) {
                if (connection == null) throw throwable;
                try {
                    connection.close();
                    throw throwable;
                }
                catch (SQLException sQLException2) {
                    SQLException sQLException4 = sQLException2;
                    throw sQLException2;
                }
            }
        }
        try {
            connection.close();
            return bl;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            throw sQLException;
        }
    }

    public void runDDL(String string) {
        this.getJdbcTemplate().execute(string);
    }

    public <T> List<T> qryObjList(String string, Map<String, Object> map, Class<T> clazz) {
        string = SqlTemplateUtil.getInstance().getSqlString(string, map);
        return this.getNamedParameterJdbcTemplate().query(string, map, (RowMapper)new BeanPropertyRowMapper(clazz));
    }

    public <T> List<T> pagingObjList(String string, int n, int n2, Map<String, Object> map, Class<T> clazz) {
        string = SqlTemplateUtil.getInstance().getPageSqlString(string, n, n2, map);
        return this.getNamedParameterJdbcTemplate().query(string, map, (RowMapper)new BeanPropertyRowMapper(clazz));
    }

    public <T> T qryObj(String string, Map<String, Object> map, Class<T> clazz) {
        string = SqlTemplateUtil.getInstance().getSqlString(string, map);
        return (T)this.getNamedParameterJdbcTemplate().queryForObject(string, map, (RowMapper)new BeanPropertyRowMapper(clazz));
    }
}

