/*
 * Decompiled with CFR 0.152.
 */
package io.github.msyysoft.java.database;

import io.github.msyysoft.java.database.AbstractDao;
import io.github.msyysoft.java.database.SingleTablePersistUtils;
import io.github.msyysoft.java.database.TableBean;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public abstract class SingleTableDao
extends AbstractDao {
    public <T extends TableBean> int addNewRecord(T t) {
        int n = SingleTablePersistUtils.addNewRecord(this, t);
        this.clearBeanConditions(t);
        return n;
    }

    public <T extends TableBean> int addNewRecordBySqlConditions(T t) {
        if (this.recordNumberBySqlConditions(t) == 0) {
            return this.addNewRecord(t);
        }
        return 0;
    }

    public <T extends TableBean> int addNewRecordBatch(List<T> list) {
        int[] nArray = SingleTablePersistUtils.addNewRecordBatch(this, list);
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(this::clearBeanConditions);
        }
        if (nArray != null) {
            int n = 0;
            for (int n2 : nArray) {
                n += n2;
            }
            return n;
        }
        return 0;
    }

    public <T extends TableBean> int addNewRecordBatchBySqlConditions(List<T> list) {
        if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(list = list.stream().filter(tableBean -> this.recordNumberBySqlConditions(tableBean) == 0).collect(Collectors.toList()))) {
            return this.addNewRecordBatch(list);
        }
        return 0;
    }

    public <T extends TableBean> int updateRecordAllByPrimaryKey(T t) {
        int n = SingleTablePersistUtils.updateRecordAllByPrimaryKey(this, t);
        this.clearBeanConditions(t);
        return n;
    }

    public <T extends TableBean> int updateRecordColumnsBySqlConditions(T t) {
        int n = SingleTablePersistUtils.updateRecordColumnsBySqlConditions(this, t);
        this.clearBeanConditions(t);
        return n;
    }

    public <T extends TableBean> int deleteRecordBySqlConditions(T t) {
        int n = SingleTablePersistUtils.deleteRecordBySqlConditions(this, t);
        this.clearBeanConditions(t);
        return n;
    }

    public <T extends TableBean> int clearTable(T t) {
        int n = SingleTablePersistUtils.clearTable(this, t);
        this.clearBeanConditions(t);
        return n;
    }

    public <T extends TableBean> T getRecordByPKMap(T t, Map<String, Object> map) {
        map = SingleTablePersistUtils.getRecordByPKMap(this, t, map);
        this.clearBeanConditions(t);
        return (T)map;
    }

    public <T extends TableBean> List<T> getRecordListBySqlConditions(T t) {
        List<T> list = SingleTablePersistUtils.getRecordListBySqlConditions(this, t);
        this.clearBeanConditions(t);
        return list;
    }

    public <T extends TableBean> int recordNumberBySqlConditions(T t) {
        int n = SingleTablePersistUtils.recordNumberBySqlConditions(this, t);
        this.clearBeanConditions(t);
        return n;
    }

    public <T extends TableBean> void clearBeanConditions(T t) {
        if (t != null) {
            t.clearAllConditions();
        }
    }
}

