/*
 * Decompiled with CFR 0.152.
 */
package io.github.msyysoft.java.database;

import io.github.msyysoft.java.database.AbstractDao;
import io.github.msyysoft.java.database.SqlConditionValue;
import io.github.msyysoft.java.database.TableBean;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.CollectionUtils;

public class SingleTablePersistUtils {
    private static Logger a = LoggerFactory.getLogger(SingleTablePersistUtils.class);
    public static final String EMPTY = "";

    public static <T extends TableBean> int addNewRecord(AbstractDao abstractDao, T t) {
        String string;
        t.putInBeanMap();
        Object object = t;
        for (String charSequence : object.getColumnNameArr()) {
            if (object.beanMap.get(charSequence) != null) continue;
            object.beanMap.remove(charSequence);
        }
        Map<String, Object> map = t.beanMap;
        object = t.getSingleTableName();
        if (map != null && !map.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("insert into ").append((String)object).append(" (");
            StringBuilder stringBuilder = new StringBuilder(map.size() << 4);
            StringBuilder stringBuilder2 = new StringBuilder(map.size() << 4);
            object = map.keySet().toArray(new String[0]);
            int n = ((T)object).length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                    stringBuilder2.append(", ");
                }
                stringBuilder.append((String)((Object)object[i]));
                stringBuilder2.append(":").append((String)((Object)object[i]));
            }
            stringBuffer.append((CharSequence)stringBuilder).append(") values (").append((CharSequence)stringBuilder2).append(")");
            string = stringBuffer.toString();
        } else {
            string = EMPTY;
        }
        object = string;
        a.debug("single-table inset sql >>> " + object);
        return abstractDao.getNamedParameterJdbcTemplate().update(object, t.beanMap);
    }

    public static <T extends TableBean> int[] addNewRecordBatch(AbstractDao abstractDao, List<T> list) {
        if (!CollectionUtils.isEmpty(list)) {
            SqlParameterSource[] sqlParameterSourceArray = new SqlParameterSource[list.size()];
            int n = 0;
            for (TableBean tableBean : list) {
                tableBean.putInBeanMap();
                sqlParameterSourceArray[n] = new MapSqlParameterSource(tableBean.beanMap);
                ++n;
            }
            String string = ((TableBean)list.get(0)).getSqlInsertBatch();
            a.debug("single-table inset batch sql >>> " + (String)string);
            return abstractDao.getNamedParameterJdbcTemplate().batchUpdate(string, sqlParameterSourceArray);
        }
        return null;
    }

    public static <T extends TableBean> int updateRecordAllByPrimaryKey(AbstractDao abstractDao, T t) {
        t.putInBeanMap();
        String string = t.getSqlUpdateAll();
        a.debug("single-table update all sql >>> " + string);
        if (t.hasPrimaryKey()) {
            return abstractDao.getNamedParameterJdbcTemplate().update(string, t.beanMap);
        }
        return 0;
    }

    public static <T extends TableBean> int updateRecordColumnsBySqlConditions(AbstractDao abstractDao, T t) {
        String string;
        t.putInBeanMap();
        T t2 = t;
        Map<String, Object> map = t.sqlConditionsMap;
        Object object = t.sqlUpdateColumnsMap;
        String[] stringArray = t.getSingleTableName();
        if (object != null && !object.isEmpty() && map != null && !map.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray2 = object.keySet().toArray(new String[0]);
            stringBuffer.append("update ").append((String)stringArray).append(" set ");
            t2.sqlUpdateColumnAliasMap.clear();
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray2[i];
                stringBuffer.append(string2).append(" = :").append(string2);
                if (i >= n - 1) continue;
                stringBuffer.append(", ");
            }
            t2.sqlUpdateColumnAliasMap.putAll((Map<String, Object>)object);
            stringBuffer.append(" where ");
            stringArray = map.keySet().toArray(new String[0]);
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(" and ");
                }
                if (map.get(object = stringArray[n]) == null) {
                    stringBuffer.append((String)object).append(" is null ");
                } else {
                    stringBuffer.append((String)object).append(" = :alias_").append((String)object).append(" ");
                }
                t2.sqlUpdateColumnAliasMap.put("alias_" + (String)object, map.get(object));
            }
            string = stringBuffer.toString();
        } else {
            string = EMPTY;
        }
        stringArray = string;
        a.debug("single-table update column sql >>> " + (String)stringArray);
        return abstractDao.getNamedParameterJdbcTemplate().update((String)stringArray, t.sqlUpdateColumnAliasMap);
    }

    public static <T extends TableBean> int deleteRecordBySqlConditions(AbstractDao abstractDao, T t) {
        String string;
        t.putInBeanMap();
        Map<String, Object> map = t.sqlConditionsMap;
        String[] stringArray = t.getSingleTableName();
        if (map != null && !map.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("delete from ").append((String)stringArray).append(" where ");
            stringArray = map.keySet().toArray(new String[0]);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                Object object;
                if (i > 0) {
                    stringBuffer.append(" and ");
                }
                if ((object = map.get(string2 = stringArray[i])) == null) {
                    stringBuffer.append(string2).append(" is null ");
                    continue;
                }
                if (object instanceof SqlConditionValue) {
                    object = (SqlConditionValue)object;
                    stringBuffer.append(string2).append(" " + ((SqlConditionValue)object).getOperation() + " ");
                    if (((SqlConditionValue)object).getOperation().contains("in")) {
                        stringBuffer.append(" (:").append(string2).append(") ");
                    } else {
                        stringBuffer.append(" :").append(string2).append(" ");
                    }
                    map.put(string2, ((SqlConditionValue)object).getValue());
                    continue;
                }
                stringBuffer.append(string2).append(" = :").append(string2).append(" ");
            }
            string = stringBuffer.toString();
        } else {
            string = EMPTY;
        }
        stringArray = string;
        a.debug("single-table delete sql >>> " + (String)stringArray);
        return abstractDao.getNamedParameterJdbcTemplate().update((String)stringArray, t.sqlConditionsMap);
    }

    public static <T extends TableBean> int clearTable(AbstractDao abstractDao, T object) {
        object = object.getSingleTableName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("delete from ").append((String)object);
        object = stringBuffer.toString();
        a.debug("single-table clear table sql >>> " + object);
        return abstractDao.getNamedParameterJdbcTemplate().update(object, new HashMap());
    }

    public static <T extends TableBean> T getRecordByPKMap(AbstractDao abstractDao, T t, Map<String, Object> map) {
        String string = SingleTablePersistUtils.a(t.getSqlSelectAll(), map, t.sortConditionsMap, null, null);
        a.debug("single-table select by pk sql >>> " + string);
        return (T)((TableBean)abstractDao.getNamedParameterJdbcTemplate().queryForObject(string, map, (RowMapper)new BeanPropertyRowMapper(t.getClass())));
    }

    public static <T extends TableBean> List<T> getRecordListBySqlConditions(AbstractDao abstractDao, T t) {
        t.putInBeanMap();
        String string = SingleTablePersistUtils.a(t.getSqlSelectAll(), t.sqlConditionsMap, t.sortConditionsMap, t.pageConditionNumber, t.pageConditionSize);
        a.debug("single-table select sql >>> " + string);
        return abstractDao.getNamedParameterJdbcTemplate().query(string, t.sqlConditionsMap, (RowMapper)new BeanPropertyRowMapper(t.getClass()));
    }

    public static <T extends TableBean> int recordNumberBySqlConditions(AbstractDao object, T t) {
        t.putInBeanMap();
        Map<String, Object> map = t.sqlConditionsMap;
        CharSequence charSequence = t.getSqlSelectAll();
        charSequence = new StringBuffer(((String)charSequence).replace("*", "count(1) as num"));
        if (map != null && !map.isEmpty()) {
            ((StringBuffer)charSequence).append(" where ");
            String[] stringArray = map.keySet().toArray(new String[0]);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string;
                Object object2;
                if (i > 0) {
                    ((StringBuffer)charSequence).append(" and ");
                }
                if ((object2 = map.get(string = stringArray[i])) == null) {
                    ((StringBuffer)charSequence).append(string).append(" is null ");
                    continue;
                }
                if (object2 instanceof SqlConditionValue) {
                    object2 = (SqlConditionValue)object2;
                    ((StringBuffer)charSequence).append(string).append(" " + ((SqlConditionValue)object2).getOperation() + " ");
                    if (((SqlConditionValue)object2).getOperation().contains("in")) {
                        ((StringBuffer)charSequence).append(" (:").append(string).append(") ");
                    } else {
                        ((StringBuffer)charSequence).append(" :").append(string).append(" ");
                    }
                    map.put(string, ((SqlConditionValue)object2).getValue());
                    continue;
                }
                ((StringBuffer)charSequence).append(string).append(" = :").append(string).append(" ");
            }
        }
        charSequence = ((StringBuffer)charSequence).toString();
        a.debug("single-table count sql >>> " + (String)charSequence);
        object = ((AbstractDao)object).getNamedParameterJdbcTemplate().queryForList((String)charSequence, t.sqlConditionsMap);
        if (CollectionUtils.isEmpty((Collection)object)) {
            return 0;
        }
        return Integer.parseInt(((Map)object.get(0)).get("num").toString());
    }

    /*
     * WARNING - void declaration
     */
    private static String a(String charSequence, Map<String, Object> map, Map<String, String> map2, Integer n, Integer n2) {
        charSequence = new StringBuffer((String)charSequence);
        if (map != null && !map.isEmpty()) {
            void entry;
            ((StringBuffer)charSequence).append(" where ");
            String[] stringArray = map.keySet().toArray(new String[0]);
            boolean i = false;
            int n3 = stringArray.length;
            while (entry < n3) {
                String string;
                Object object;
                if (entry > 0) {
                    ((StringBuffer)charSequence).append(" and ");
                }
                if ((object = map.get(string = stringArray[entry])) == null) {
                    ((StringBuffer)charSequence).append(string).append(" is null ");
                } else if (object instanceof SqlConditionValue) {
                    object = (SqlConditionValue)object;
                    ((StringBuffer)charSequence).append(string).append(" " + ((SqlConditionValue)object).getOperation() + " ");
                    if (((SqlConditionValue)object).getOperation().contains("in")) {
                        ((StringBuffer)charSequence).append(" (:").append(string).append(") ");
                    } else {
                        ((StringBuffer)charSequence).append(" :").append(string).append(" ");
                    }
                    map.put(string, ((SqlConditionValue)object).getValue());
                } else {
                    ((StringBuffer)charSequence).append(string).append(" = :").append(string).append(" ");
                }
                ++entry;
            }
        }
        if (map2 != null && !map2.isEmpty()) {
            ((StringBuffer)charSequence).append(" order by ");
            for (Map.Entry entry : map2.entrySet()) {
                ((StringBuffer)charSequence).append(" " + (String)entry.getKey() + " " + (String)entry.getValue());
            }
        }
        if (n != null && n2 != null) {
            int n4 = (n - 1) * n2;
            n4 = Math.max(n4, 0);
            n2 = n2 > 0 ? n2 : 15;
            ((StringBuffer)charSequence).append(" limit ").append(n2).append(" offset ").append(n4);
        }
        return ((StringBuffer)charSequence).toString();
    }
}

