/*
 * Decompiled with CFR 0.152.
 */
package io.github.msyysoft.java.utiltools;

import io.github.msyysoft.java.utiltools.StringUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;

public class DateUtil {
    public static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss";

    public static Calendar getNewCalendar(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        return calendar;
    }

    public static java.sql.Date utilDate2SqlDate(Date date) {
        if (date != null) {
            return new java.sql.Date(date.getTime());
        }
        return null;
    }

    public static Timestamp utilDate2SqlTimestamp(Date date) {
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        return null;
    }

    public static Date sqlDate2UtilDate(java.sql.Date date) {
        if (date != null) {
            return new Date(date.getTime());
        }
        return null;
    }

    public static Date sqlTimestamp2UtilDate(Timestamp timestamp) {
        if (timestamp != null) {
            return new Date(timestamp.getTime());
        }
        return null;
    }

    public static Date getNowDate(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return new Date();
        }
        try {
            return DateUtils.parseDate((String)DateFormatUtils.format((long)Calendar.getInstance().getTimeInMillis(), (String)string), (String[])new String[]{string});
        }
        catch (Exception exception) {
            return new Date();
        }
    }

    public static java.sql.Date getNowSqlDate() {
        return DateUtil.utilDate2SqlDate(DateUtil.getNowDate(DATE_FORMAT));
    }

    public static Timestamp getNowSqlTimestamp() {
        return DateUtil.utilDate2SqlTimestamp(DateUtil.getNowDate(null));
    }

    public static String getWeekdayChineseStrByDate(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("E").format(date);
    }

    public static boolean equalsTimestamp(Timestamp timestamp, Timestamp timestamp2) {
        SimpleDateFormat simpleDateFormat;
        if (timestamp == null && timestamp2 == null) {
            return true;
        }
        return timestamp != null && timestamp2 != null && (simpleDateFormat = new SimpleDateFormat(DATETIME_FORMAT)).format(timestamp).equals(simpleDateFormat.format(timestamp2));
    }

    public static String getFormatTime(Date date, String string) {
        if (date == null || string == null) {
            throw new NullPointerException("template must not null");
        }
        return new SimpleDateFormat(string, Locale.getDefault()).format(date);
    }

    public static String getFormatTime(Calendar calendar, String string) {
        if (calendar == null || string == null) {
            throw new NullPointerException("template must not null");
        }
        return new SimpleDateFormat(string, Locale.getDefault()).format(calendar.getTime());
    }

    public static String getFormatTime(String string) {
        return DateUtil.getFormatTime(Calendar.getInstance(), string);
    }

    public static String getFormatTime(String string, String string2) {
        Calendar calendar = DateUtil.getCalendar(string);
        if (calendar != null) {
            return DateUtil.getFormatTime(calendar, string2);
        }
        return string;
    }

    public static Calendar getCalendar(String string) {
        if (string != null && (string = StringUtil.getNumberSTR(string)).length() >= 12) {
            try {
                int n = Integer.parseInt(string.substring(0, 4));
                int n2 = Integer.parseInt(string.substring(4, 6)) - 1;
                int n3 = Integer.parseInt(string.substring(6, 8));
                int n4 = Integer.parseInt(string.substring(8, 10));
                int n5 = Integer.parseInt(string.substring(10, 12));
                int n6 = string.length() >= 14 ? Integer.parseInt(string.substring(12, 14)) : 0;
                Calendar calendar = Calendar.getInstance();
                calendar.set(n, n2, n3, n4, n5, n6);
                return calendar;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static Calendar getCalendar(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        return calendar;
    }

    public static String getFormatTimeAgo(int n, long l, String string) {
        Calendar calendar = Calendar.getInstance();
        long l2 = calendar.getTimeInMillis();
        long l3 = l2 - l;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 < 86400000L * (long)n) {
            if (l3 < 3600000L) {
                return Math.max(l3 / 60000L, 1L) + "\u5206\u949f\u524d";
            }
            if (l3 < 86400000L) {
                return l3 / 3600000L + "\u5c0f\u65f6\u524d";
            }
            return l3 / 86400000L + "\u5929\u524d";
        }
        calendar.setTimeInMillis(l);
        return DateUtil.getFormatTime(calendar, string);
    }

    public static int getWeekInt(Calendar calendar) {
        calendar.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        if (calendar.get(7) - 1 == 0) {
            return 7;
        }
        return calendar.get(7) - 1;
    }

    public static String getWeekString(Calendar calendar) {
        int n = DateUtil.getWeekInt(calendar);
        switch (n) {
            case 1: {
                return "\u4e00";
            }
            case 2: {
                return "\u4e8c";
            }
            case 3: {
                return "\u4e09";
            }
            case 4: {
                return "\u56db";
            }
            case 5: {
                return "\u4e94";
            }
            case 6: {
                return "\u516d";
            }
        }
        return "\u65e5";
    }
}

