/*
 * Decompiled with CFR 0.152.
 */
package io.github.msyysoft.java.utiltools;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.github.msyysoft.java.utiltools.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class GsonUtil {
    public static final TypeAdapter<Date> DATE = new TypeAdapter<Date>(){

        private static Date a(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return new Date(new SimpleDateFormat("yyyy-MM-dd").parse(jsonReader.nextString()).getTime());
            }
            catch (Exception exception) {
                throw new JsonSyntaxException((Throwable)exception);
            }
        }

        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            return 1.a(jsonReader);
        }

        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            if ((object = (Date)object) == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(new SimpleDateFormat("yyyy-MM-dd").format((java.util.Date)object));
        }
    };
    public static final TypeAdapter<Time> TIME = new TypeAdapter<Time>(){

        private static Time a(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return new Time(new SimpleDateFormat("HH:mm:ss").parse(jsonReader.nextString()).getTime());
            }
            catch (Exception exception) {
                throw new JsonSyntaxException((Throwable)exception);
            }
        }

        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            return 2.a(jsonReader);
        }

        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            if ((object = (Time)object) == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(new SimpleDateFormat("HH:mm:ss").format((java.util.Date)object));
        }
    };
    public static final TypeAdapter<Timestamp> DATETIME = new TypeAdapter<Timestamp>(){

        private static Timestamp a(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return new Timestamp(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(jsonReader.nextString()).getTime());
            }
            catch (Exception exception) {
                throw new JsonSyntaxException((Throwable)exception);
            }
        }

        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            return 3.a(jsonReader);
        }

        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            if ((object = (Timestamp)object) == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((java.util.Date)object));
        }
    };
    private static Gson a;

    public static <T> List<T> jsonArrayToList(String object, Class<T> clazz) {
        if (object == null || ((String)object).trim().equals("")) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Gson gson = new Gson();
        Object object2 = new JsonParser();
        object = object2.parse((String)object);
        object = object.getAsJsonArray();
        object2 = object.iterator();
        while (object2.hasNext()) {
            object = (JsonElement)object2.next();
            object = object.toString();
            object = gson.fromJson((String)object, clazz);
            arrayList.add(object);
        }
        return arrayList;
    }

    public static String allToJson(Object ... objectArray) {
        Gson gson = new Gson();
        if (objectArray != null) {
            return gson.toJson((Object)objectArray);
        }
        return gson.toJson((Object)new Object[0]);
    }

    public static boolean isJsonValid(JsonReader jsonReader) {
        try {
            JsonToken jsonToken;
            block11: while ((jsonToken = jsonReader.peek()) != JsonToken.END_DOCUMENT && jsonToken != null) {
                switch (jsonToken) {
                    case BEGIN_ARRAY: {
                        jsonReader.beginArray();
                        continue block11;
                    }
                    case END_ARRAY: {
                        jsonReader.endArray();
                        continue block11;
                    }
                    case BEGIN_OBJECT: {
                        jsonReader.beginObject();
                        continue block11;
                    }
                    case END_OBJECT: {
                        jsonReader.endObject();
                        continue block11;
                    }
                    case NAME: {
                        jsonReader.nextName();
                        continue block11;
                    }
                    case STRING: 
                    case NUMBER: 
                    case BOOLEAN: 
                    case NULL: {
                        jsonReader.skipValue();
                        continue block11;
                    }
                    case END_DOCUMENT: {
                        break block11;
                    }
                    default: {
                        throw new AssertionError(jsonToken);
                    }
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isJsonValid(String string) {
        return GsonUtil.isJsonValid(new JsonReader((Reader)new StringReader(string)));
    }

    public static GsonBuilder getGsonBuilder() {
        GsonBuilder gsonBuilder = new Gson().newBuilder();
        gsonBuilder.setDateFormat("yyyy-MM-dd HH:mm:ss");
        gsonBuilder.enableComplexMapKeySerialization();
        return gsonBuilder;
    }

    public static Gson getGson(GsonBuilder gsonBuilder) {
        if (a == null) {
            a = gsonBuilder.create();
        }
        return a;
    }

    public static Gson getGson() {
        return GsonUtil.getGson(GsonUtil.getGsonBuilder());
    }

    public static class GsonHttpMessageConverter
    extends org.springframework.http.converter.json.GsonHttpMessageConverter {
        public GsonHttpMessageConverter() {
            this.setGson(GsonUtil.getGson());
        }
    }

    public static enum FieldNamingPolicy implements FieldNamingStrategy
    {
        UNDERSCORES_UPPER_CAMEL_CASE{

            public final String translateName(Field field) {
                return StringUtil.lineToHump(field.getName());
            }
        };


        private FieldNamingPolicy() {
        }

        /* synthetic */ FieldNamingPolicy(String string, int n, byte by) {
            this();
        }
    }
}

