/*
 * Decompiled with CFR 0.152.
 */
package io.github.msyysoft.java.utiltools;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TypeUtil {
    private static ConcurrentMap<String, Class<?>> a = new ConcurrentHashMap();

    public static final String castToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static final Byte castToByte(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            if (((String)(object = (String)object)).length() == 0) {
                return null;
            }
            try {
                return Byte.parseByte((String)object);
            }
            catch (Exception exception) {
                return null;
            }
        }
        throw new RuntimeException("can not cast to byte, value : " + object);
    }

    public static final Character castToChar(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            if (string.length() != 1) {
                throw new RuntimeException("can not cast to byte, value : " + object);
            }
            return Character.valueOf(string.charAt(0));
        }
        throw new RuntimeException("can not cast to byte, value : " + object);
    }

    public static final Short castToShort(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        if (object instanceof String) {
            if (((String)(object = (String)object)).length() == 0) {
                return null;
            }
            try {
                return Short.parseShort((String)object);
            }
            catch (Exception exception) {
                return null;
            }
        }
        throw new RuntimeException("can not cast to short, value : " + object);
    }

    public static final BigDecimal castToBigDecimal(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof BigInteger) {
            return new BigDecimal((BigInteger)object);
        }
        if (((String)(object = object.toString())).length() == 0) {
            return null;
        }
        return new BigDecimal((String)object);
    }

    public static final BigInteger castToBigInteger(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        if (object instanceof Float || object instanceof Double) {
            return BigInteger.valueOf(((Number)object).longValue());
        }
        if (((String)(object = object.toString())).length() == 0) {
            return null;
        }
        return new BigInteger((String)object);
    }

    public static final Float castToFloat(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return Float.valueOf(((Number)object).floatValue());
        }
        if (object instanceof String) {
            if (((String)(object = object.toString())).length() == 0) {
                return null;
            }
            try {
                return Float.valueOf(Float.parseFloat((String)object));
            }
            catch (Exception exception) {
                return null;
            }
        }
        throw new RuntimeException("can not cast to float, value : " + object);
    }

    public static final Double castToDouble(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            if (((String)(object = object.toString())).length() == 0) {
                return null;
            }
            try {
                return Double.parseDouble((String)object);
            }
            catch (Exception exception) {
                return null;
            }
        }
        throw new RuntimeException("can not cast to double, value : " + object);
    }

    public static final java.util.Date castToDate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Calendar) {
            return ((Calendar)object).getTime();
        }
        if (object instanceof java.util.Date) {
            return (java.util.Date)object;
        }
        long l = 0L;
        if (object instanceof Number) {
            l = ((Number)object).longValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.indexOf(45) != -1) {
                object = string.length() == 19 ? "yyyy-MM-dd HH:mm:ss" : (string.length() == 10 ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss.SSS");
                object = new SimpleDateFormat((String)object);
                try {
                    return ((DateFormat)object).parse(string);
                }
                catch (ParseException parseException) {
                    throw new RuntimeException("can not cast to Date, value : " + string);
                }
            }
            if (string.length() == 0) {
                return null;
            }
            l = Long.parseLong(string);
        }
        if (l <= 0L) {
            throw new RuntimeException("can not cast to Date, value : " + object);
        }
        return new java.util.Date(l);
    }

    public static final Date castToSqlDate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Calendar) {
            return new Date(((Calendar)object).getTimeInMillis());
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof java.util.Date) {
            return new Date(((java.util.Date)object).getTime());
        }
        long l = 0L;
        if (object instanceof Number) {
            l = ((Number)object).longValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            l = Long.parseLong(string);
        }
        if (l <= 0L) {
            throw new RuntimeException("can not cast to Date, value : " + object);
        }
        return new Date(l);
    }

    public static final Timestamp castToTimestamp(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Calendar) {
            return new Timestamp(((Calendar)object).getTimeInMillis());
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)object).getTime());
        }
        long l = 0L;
        if (object instanceof Number) {
            l = ((Number)object).longValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            l = Long.parseLong(string);
        }
        if (l <= 0L) {
            throw new RuntimeException("can not cast to Date, value : " + object);
        }
        return new Timestamp(l);
    }

    public static final Long castToLong(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            if (((String)(object = (String)object)).length() == 0) {
                return null;
            }
            try {
                return Long.parseLong((String)object);
            }
            catch (Exception exception) {
                return null;
            }
        }
        throw new RuntimeException("can not cast to long, value : " + object);
    }

    public static final Integer castToInt(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            if (((String)(object = (String)object)).length() == 0) {
                return null;
            }
            try {
                return Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                return null;
            }
        }
        throw new RuntimeException("can not cast to int, value : " + object);
    }

    public static final byte[] castToBytes(Object object) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        throw new RuntimeException("can not cast to int, value : " + object);
    }

    public static final Boolean castToBoolean(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() == 1;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            if ("true".equals(string)) {
                return Boolean.TRUE;
            }
            if ("false".equals(string)) {
                return Boolean.FALSE;
            }
            if ("0".equals(string)) {
                return Boolean.FALSE;
            }
            if ("1".equals(string)) {
                return Boolean.TRUE;
            }
        }
        throw new RuntimeException("can not cast to int, value : " + object);
    }

    public static void addClassMapping(String string, Class<?> clazz) {
        if (string == null) {
            string = clazz.getName();
        }
        a.put(string, clazz);
    }

    public static void addBaseClassMappings() {
        a.put("byte", Byte.TYPE);
        a.put("short", Short.TYPE);
        a.put("int", Integer.TYPE);
        a.put("long", Long.TYPE);
        a.put("float", Float.TYPE);
        a.put("double", Double.TYPE);
        a.put("boolean", Boolean.TYPE);
        a.put("char", Character.TYPE);
        a.put("[byte", byte[].class);
        a.put("[short", short[].class);
        a.put("[int", int[].class);
        a.put("[long", long[].class);
        a.put("[float", float[].class);
        a.put("[double", double[].class);
        a.put("[boolean", boolean[].class);
        a.put("[char", char[].class);
        a.put(HashMap.class.getName(), HashMap.class);
    }

    public static void clearClassMapping() {
        a.clear();
        TypeUtil.addBaseClassMappings();
    }

    public static Class<?> loadClass(String object) {
        Class<?> clazz;
        while (true) {
            if (object == null || ((String)object).length() == 0) {
                return null;
            }
            clazz = (Class<?>)a.get(object);
            if (clazz != null) {
                return clazz;
            }
            if (((String)object).charAt(0) == '[') {
                object = TypeUtil.loadClass(((String)object).substring(1));
                return Array.newInstance(object, 0).getClass();
            }
            if (!((String)object).startsWith("L") || !((String)object).endsWith(";")) break;
            object = ((String)object).substring(1, ((String)object).length() - 1);
        }
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass((String)object);
            TypeUtil.addClassMapping((String)object, clazz);
            return clazz;
        }
        catch (Throwable throwable) {
            try {
                clazz = Class.forName((String)object);
                TypeUtil.addClassMapping((String)object, clazz);
                return clazz;
            }
            catch (Throwable throwable2) {
                return clazz;
            }
        }
    }

    public static Class<?> getClass(Type type) {
        while (true) {
            if (type.getClass() == Class.class) {
                return (Class)type;
            }
            if (!(type instanceof ParameterizedType)) break;
            type = ((ParameterizedType)type).getRawType();
        }
        return Object.class;
    }

    static {
        TypeUtil.addBaseClassMappings();
    }
}

