/*
 * Decompiled with CFR 0.152.
 */
package io.github.msyysoft.java.utiltools.cache4j.core.impl;

import io.github.msyysoft.java.utiltools.cache4j.core.ICache;
import io.github.msyysoft.java.utiltools.cache4j.core.impl.CacheConfig;
import io.github.msyysoft.java.utiltools.cache4j.factory.INodeFactory;
import io.github.msyysoft.java.utiltools.cache4j.linked.impl.CacheLinked;
import io.github.msyysoft.java.utiltools.cache4j.node.NodeAbstract;
import java.util.concurrent.atomic.AtomicInteger;

public class LruCache<K, V>
implements ICache<K, V> {
    private CacheLinked<K, V> a = null;
    private INodeFactory<K, V> b = null;
    private CacheConfig c = null;
    private AtomicInteger d = new AtomicInteger();
    private AtomicInteger e = new AtomicInteger();

    public LruCache(CacheConfig cacheConfig, INodeFactory<K, V> iNodeFactory) {
        this.c = cacheConfig;
        this.a = new CacheLinked();
        this.b = iNodeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K k, V object) {
        object = this.b.createNode(k, object);
        LruCache lruCache = this;
        synchronized (lruCache) {
            this.remove(k);
            if (this.size() == this.c.getMaxElement()) {
                this.a.pop();
            }
            this.a.unshift((NodeAbstract<K, V>)object);
            return;
        }
    }

    @Override
    public V get(K object) {
        if ((object = this.a.get(object)) != null) {
            this.a.remove(object);
            this.a.unshift((NodeAbstract<K, V>)object);
            this.e.incrementAndGet();
            return ((NodeAbstract)object).getValue();
        }
        this.d.incrementAndGet();
        return null;
    }

    @Override
    public int size() {
        return this.a.size();
    }

    @Override
    public double hitRatio() {
        double d;
        double d2 = this.e.doubleValue();
        double d3 = d2 + (d = this.d.doubleValue());
        if (d3 == 0.0) {
            return 0.0;
        }
        return d2 / d3;
    }

    @Override
    public void clear() {
        this.a = new CacheLinked();
        this.e.set(0);
        this.d.set(0);
    }

    @Override
    public NodeAbstract<K, V> getNode(K k) {
        return this.a.get(k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K k) {
        LruCache lruCache = this;
        synchronized (lruCache) {
            this.a.remove(k);
            return;
        }
    }

    public AtomicInteger getMissCount() {
        return this.d;
    }

    public AtomicInteger getHitCount() {
        return this.e;
    }
}

