/*
 * Decompiled with CFR 0.152.
 */
package io.github.msyysoft.java.utiltools.cache4j.core.impl;

import io.github.msyysoft.java.utiltools.cache4j.core.ICache;
import io.github.msyysoft.java.utiltools.cache4j.core.impl.CacheConfig;
import io.github.msyysoft.java.utiltools.cache4j.core.impl.FifoCache;
import io.github.msyysoft.java.utiltools.cache4j.core.impl.LruCache;
import io.github.msyysoft.java.utiltools.cache4j.factory.INodeFactory;
import io.github.msyysoft.java.utiltools.cache4j.node.NodeAbstract;
import io.github.msyysoft.java.utiltools.cache4j.node.impl.CacheNode;

public class TwoQueuesCache<K, V>
implements ICache<K, V> {
    private FifoCache<K, V> a = null;
    private LruCache<K, V> b = null;
    private CacheConfig c = null;
    private CacheConfig d = null;
    private INodeFactory<K, V> e = null;
    private int f = 2;

    public TwoQueuesCache(CacheConfig cacheConfig, INodeFactory<K, V> iNodeFactory) {
        this.d = CacheConfig.custom().setMaxElement(cacheConfig.getMaxElement() / 2);
        this.c = cacheConfig.getMaxElement() % 2 == 0 ? CacheConfig.custom().setMaxElement(cacheConfig.getMaxElement() / 2) : CacheConfig.custom().setMaxElement(cacheConfig.getMaxElement() / 2 + 1);
        this.e = iNodeFactory;
        this.b = new LruCache<K, V>(this.d, iNodeFactory);
        this.a = new FifoCache<K, V>(this.c, iNodeFactory);
    }

    @Override
    public void put(K k, V v) {
        this.a.put(k, v);
    }

    @Override
    public V get(K k) {
        NodeAbstract<K, V> nodeAbstract = this.a.getNode(k);
        if (nodeAbstract != null) {
            int n = ((CacheNode)nodeAbstract).usedCountIncrement();
            if (n >= this.f) {
                this.b.put(k, nodeAbstract.getValue());
                this.a.remove(k);
            }
            return nodeAbstract.getValue();
        }
        nodeAbstract = this.b.getNode(k);
        if (nodeAbstract != null) {
            return nodeAbstract.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.a.size() + this.b.size();
    }

    @Override
    public double hitRatio() {
        double d;
        double d2 = this.a.getHitCount().doubleValue() + this.b.getHitCount().doubleValue();
        double d3 = d2 + (d = this.a.getMissCount().doubleValue() + this.b.getMissCount().doubleValue());
        if (d3 == 0.0) {
            return 0.0;
        }
        return d2 / d3;
    }

    @Override
    public void clear() {
        this.b = new LruCache<K, V>(this.d, this.e);
        this.a = new FifoCache<K, V>(this.c, this.e);
    }

    @Override
    public NodeAbstract<K, V> getNode(K k) {
        return null;
    }

    @Override
    public void remove(K k) {
        this.a.remove(k);
        this.b.remove(k);
    }
}

