/*
 * Decompiled with CFR 0.152.
 */
package io.github.msyysoft.java.utiltools.cache4j.linked;

import io.github.msyysoft.java.utiltools.cache4j.node.NodeAbstract;
import io.github.msyysoft.java.utiltools.cache4j.node.impl.GuardNode;
import java.util.HashMap;
import java.util.Map;

public abstract class LinkedAbstract<K, V> {
    private NodeAbstract<K, V> a;
    private NodeAbstract<K, V> b;
    private Map<K, NodeAbstract<K, V>> c = new HashMap<K, NodeAbstract<K, V>>();

    public LinkedAbstract() {
        this.a = new GuardNode();
        this.b = this.a;
        this.a.setNextNode(this.b);
        this.b.setPrevNode(this.a);
    }

    public NodeAbstract<K, V> unshift(NodeAbstract<K, V> nodeAbstract) {
        LinkedAbstract linkedAbstract = this;
        return linkedAbstract.insertAfter(linkedAbstract.a, nodeAbstract);
    }

    public NodeAbstract<K, V> push(NodeAbstract<K, V> nodeAbstract) {
        LinkedAbstract linkedAbstract = this;
        return linkedAbstract.insertBefore(linkedAbstract.b, nodeAbstract);
    }

    public NodeAbstract<K, V> insertBefore(NodeAbstract<K, V> nodeAbstract, NodeAbstract<K, V> nodeAbstract2) {
        nodeAbstract2.setPrevNode(nodeAbstract.getPrevNode());
        nodeAbstract2.getPrevNode().setNextNode(nodeAbstract2);
        nodeAbstract2.setNextNode(nodeAbstract);
        nodeAbstract.setPrevNode(nodeAbstract2);
        this.saveToSearchMap(nodeAbstract2);
        return nodeAbstract2;
    }

    public NodeAbstract<K, V> insertAfter(NodeAbstract<K, V> nodeAbstract, NodeAbstract<K, V> nodeAbstract2) {
        nodeAbstract2.setNextNode(nodeAbstract.getNextNode());
        nodeAbstract2.getNextNode().setPrevNode(nodeAbstract2);
        nodeAbstract.setNextNode(nodeAbstract2);
        nodeAbstract2.setPrevNode(nodeAbstract);
        this.saveToSearchMap(nodeAbstract2);
        return nodeAbstract2;
    }

    public NodeAbstract<K, V> get(K k) {
        return this.c.get(k);
    }

    public void remove(NodeAbstract<K, V> nodeAbstract) {
        nodeAbstract.getNextNode().setPrevNode(nodeAbstract.getPrevNode());
        nodeAbstract.getPrevNode().setNextNode(nodeAbstract.getNextNode());
        this.deleteFromSearchMap(nodeAbstract);
    }

    public void remove(K object) {
        if ((object = this.get(object)) != null) {
            this.remove(object);
        }
    }

    public NodeAbstract<K, V> shift() {
        NodeAbstract<K, V> nodeAbstract = this.a.getNextNode();
        if (nodeAbstract instanceof GuardNode) {
            return null;
        }
        this.remove((K)nodeAbstract);
        return nodeAbstract;
    }

    public NodeAbstract<K, V> pop() {
        NodeAbstract<K, V> nodeAbstract = this.b.getPrevNode();
        if (nodeAbstract instanceof GuardNode) {
            return null;
        }
        this.remove((K)nodeAbstract);
        return nodeAbstract;
    }

    public int size() {
        return this.c.keySet().size();
    }

    protected void saveToSearchMap(NodeAbstract<K, V> nodeAbstract) {
        this.c.put(nodeAbstract.getKey(), nodeAbstract);
    }

    protected void deleteFromSearchMap(NodeAbstract<K, V> nodeAbstract) {
        this.c.remove(nodeAbstract.getKey());
    }
}

