/*
 * Decompiled with CFR 0.152.
 */
package io.github.msyysoft.java.utiltools.httpclientutil;

import io.github.msyysoft.java.utiltools.httpclientutil.builder.HCB;
import io.github.msyysoft.java.utiltools.httpclientutil.builder.HCBProxyConfig;
import io.github.msyysoft.java.utiltools.httpclientutil.common.HttpConfig;
import io.github.msyysoft.java.utiltools.httpclientutil.common.HttpMethods;
import io.github.msyysoft.java.utiltools.httpclientutil.common.Utils;
import io.github.msyysoft.java.utiltools.httpclientutil.exception.HttpProcessException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static HttpClient a;
    private static HttpClient b;

    public static String get(HttpClient httpClient, String string, Header[] headerArray, HttpContext httpContext, String string2) throws HttpProcessException {
        return HttpClientUtil.get(HttpConfig.custom().client(httpClient).url(string).headers(headerArray).context(httpContext).encoding(string2));
    }

    public static String get(HttpConfig httpConfig) throws HttpProcessException {
        return HttpClientUtil.send(httpConfig.method(HttpMethods.GET));
    }

    public static String post(HttpClient httpClient, String string, Header[] headerArray, Map<String, Object> map, HttpContext httpContext, String string2) throws HttpProcessException {
        return HttpClientUtil.post(HttpConfig.custom().client(httpClient).url(string).headers(headerArray).map(map).context(httpContext).encoding(string2));
    }

    public static String post(HttpConfig httpConfig) throws HttpProcessException {
        return HttpClientUtil.send(httpConfig.method(HttpMethods.POST));
    }

    public static String put(HttpClient httpClient, String string, Map<String, Object> map, Header[] headerArray, HttpContext httpContext, String string2) throws HttpProcessException {
        return HttpClientUtil.put(HttpConfig.custom().client(httpClient).url(string).headers(headerArray).map(map).context(httpContext).encoding(string2));
    }

    public static String put(HttpConfig httpConfig) throws HttpProcessException {
        return HttpClientUtil.send(httpConfig.method(HttpMethods.PUT));
    }

    public static String delete(HttpClient httpClient, String string, Header[] headerArray, HttpContext httpContext, String string2) throws HttpProcessException {
        return HttpClientUtil.delete(HttpConfig.custom().client(httpClient).url(string).headers(headerArray).context(httpContext).encoding(string2));
    }

    public static String delete(HttpConfig httpConfig) throws HttpProcessException {
        return HttpClientUtil.send(httpConfig.method(HttpMethods.DELETE));
    }

    public static String patch(HttpClient httpClient, String string, Map<String, Object> map, Header[] headerArray, HttpContext httpContext, String string2) throws HttpProcessException {
        return HttpClientUtil.patch(HttpConfig.custom().client(httpClient).url(string).headers(headerArray).map(map).context(httpContext).encoding(string2));
    }

    public static String patch(HttpConfig httpConfig) throws HttpProcessException {
        return HttpClientUtil.send(httpConfig.method(HttpMethods.PATCH));
    }

    public static String head(HttpClient httpClient, String string, Header[] headerArray, HttpContext httpContext, String string2) throws HttpProcessException {
        return HttpClientUtil.head(HttpConfig.custom().client(httpClient).url(string).headers(headerArray).context(httpContext).encoding(string2));
    }

    public static String head(HttpConfig httpConfig) throws HttpProcessException {
        return HttpClientUtil.send(httpConfig.method(HttpMethods.HEAD));
    }

    public static String options(HttpClient httpClient, String string, Header[] headerArray, HttpContext httpContext, String string2) throws HttpProcessException {
        return HttpClientUtil.options(HttpConfig.custom().client(httpClient).url(string).headers(headerArray).context(httpContext).encoding(string2));
    }

    public static String options(HttpConfig httpConfig) throws HttpProcessException {
        return HttpClientUtil.send(httpConfig.method(HttpMethods.OPTIONS));
    }

    public static String trace(HttpClient httpClient, String string, Header[] headerArray, HttpContext httpContext, String string2) throws HttpProcessException {
        return HttpClientUtil.trace(HttpConfig.custom().client(httpClient).url(string).headers(headerArray).context(httpContext).encoding(string2));
    }

    public static String trace(HttpConfig httpConfig) throws HttpProcessException {
        return HttpClientUtil.send(httpConfig.method(HttpMethods.TRACE));
    }

    public static OutputStream down(HttpClient httpClient, String string, Header[] headerArray, HttpContext httpContext, OutputStream outputStream) throws HttpProcessException {
        return HttpClientUtil.down(HttpConfig.custom().client(httpClient).url(string).headers(headerArray).context(httpContext).out(outputStream));
    }

    public static OutputStream down(HttpConfig httpConfig) throws HttpProcessException {
        return HttpClientUtil.fmt2Stream(HttpClientUtil.a(httpConfig.method(HttpMethods.GET)), httpConfig.out());
    }

    public static String upload(HttpClient httpClient, String string, Header[] headerArray, HttpContext httpContext) throws HttpProcessException {
        return HttpClientUtil.upload(HttpConfig.custom().client(httpClient).url(string).headers(headerArray).context(httpContext));
    }

    public static String upload(HttpConfig httpConfig) throws HttpProcessException {
        if (httpConfig.method() != HttpMethods.POST && httpConfig.method() != HttpMethods.PUT) {
            httpConfig.method(HttpMethods.POST);
        }
        return HttpClientUtil.send(httpConfig);
    }

    public static int status(HttpClient httpClient, String string, Header[] headerArray, HttpContext httpContext, HttpMethods httpMethods) throws HttpProcessException {
        return HttpClientUtil.status(HttpConfig.custom().client(httpClient).url(string).headers(headerArray).context(httpContext).method(httpMethods));
    }

    public static int status(HttpConfig httpConfig) throws HttpProcessException {
        return HttpClientUtil.a(HttpClientUtil.a(httpConfig));
    }

    public static String send(HttpConfig httpConfig) throws HttpProcessException {
        return HttpClientUtil.a(HttpClientUtil.a(httpConfig), httpConfig.outenc());
    }

    private static HttpResponse a(HttpConfig httpConfig) throws HttpProcessException {
        Object object = httpConfig;
        if (((HttpConfig)object).client() == null) {
            if (((HttpConfig)object).url().toLowerCase().startsWith("https://")) {
                ((HttpConfig)object).client(b);
            } else {
                ((HttpConfig)object).client(a);
            }
        }
        try {
            Object object2 = httpConfig.method();
            object = httpConfig.url();
            switch (((HttpMethods)((Object)object2)).getCode()) {
                case 0: {
                    object = new HttpGet((String)object);
                    break;
                }
                case 1: {
                    object = new HttpPost((String)object);
                    break;
                }
                case 2: {
                    object = new HttpHead((String)object);
                    break;
                }
                case 3: {
                    object = new HttpPut((String)object);
                    break;
                }
                case 4: {
                    object = new HttpDelete((String)object);
                    break;
                }
                case 5: {
                    object = new HttpTrace((String)object);
                    break;
                }
                case 6: {
                    object = new HttpPatch((String)object);
                    break;
                }
                case 7: {
                    object = new HttpOptions((String)object);
                    break;
                }
                default: {
                    object = new HttpPost((String)object);
                }
            }
            object.setHeaders(httpConfig.headers());
            if (HttpEntityEnclosingRequestBase.class.isAssignableFrom(object.getClass())) {
                object2 = new ArrayList();
                HttpConfig httpConfig2 = httpConfig;
                httpConfig2.url(Utils.checkHasParas(httpConfig2.url(), (List<NameValuePair>)object2, httpConfig.inenc()));
                HttpEntity httpEntity = Utils.map2HttpEntity((List<NameValuePair>)object2, httpConfig.map(), httpConfig.inenc());
                ((HttpEntityEnclosingRequestBase)object).setEntity(httpEntity);
                Utils.info("\u8bf7\u6c42\u5730\u5740\uff1a" + httpConfig.url());
                if (object2.size() > 0) {
                    Utils.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + object2.toString());
                }
                if (httpConfig.json() != null) {
                    Utils.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + httpConfig.json());
                }
            } else {
                int n = httpConfig.url().indexOf("?");
                Utils.info("\u8bf7\u6c42\u5730\u5740\uff1a" + httpConfig.url().substring(0, n > 0 ? n : httpConfig.url().length()));
                if (n > 0) {
                    Utils.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + httpConfig.url().substring(n + 1));
                }
            }
            Object object3 = object = httpConfig.context() == null ? httpConfig.client().execute((HttpUriRequest)object) : httpConfig.client().execute((HttpUriRequest)object, httpConfig.context());
            if (httpConfig.isReturnRespHeaders()) {
                httpConfig.headers(object.getAllHeaders());
            }
            return object;
        }
        catch (IOException iOException) {
            throw new HttpProcessException(iOException);
        }
    }

    private static String a(HttpResponse httpResponse, String string) throws HttpProcessException {
        try {
            if (httpResponse.getEntity() != null) {
                string = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)string);
                Utils.info(string);
            } else {
                string = httpResponse.getStatusLine().toString();
            }
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException iOException) {
            throw new HttpProcessException(iOException);
        }
        finally {
            HttpClientUtil.b(httpResponse);
        }
        return string;
    }

    private static int a(HttpResponse httpResponse) throws HttpProcessException {
        int n;
        try {
            n = httpResponse.getStatusLine().getStatusCode();
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException iOException) {
            throw new HttpProcessException(iOException);
        }
        finally {
            HttpClientUtil.b(httpResponse);
        }
        return n;
    }

    public static OutputStream fmt2Stream(HttpResponse httpResponse, OutputStream outputStream) throws HttpProcessException {
        try {
            httpResponse.getEntity().writeTo(outputStream);
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException iOException) {
            throw new HttpProcessException(iOException);
        }
        finally {
            HttpClientUtil.b(httpResponse);
        }
        return outputStream;
    }

    private static void b(HttpResponse object) {
        if (object == null) {
            return;
        }
        try {
            if (CloseableHttpResponse.class.isAssignableFrom(object.getClass())) {
                ((CloseableHttpResponse)object).close();
            }
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            Utils.exception(iOException);
            return;
        }
    }

    static {
        try {
            if (HCBProxyConfig.isProxy_switch()) {
                a = HCB.custom().proxy(HCBProxyConfig.getProxy_ip(), HCBProxyConfig.getProxy_port()).build();
                b = HCB.custom().ssl().proxy(HCBProxyConfig.getProxy_ip(), HCBProxyConfig.getProxy_port()).build();
            } else {
                a = HCB.custom().build();
                b = HCB.custom().ssl().build();
            }
        }
        catch (HttpProcessException httpProcessException) {
            Utils.errorException("\u521b\u5efahttps\u534f\u8bae\u7684HttpClient\u5bf9\u8c61\u51fa\u9519\uff1a{}", httpProcessException);
        }
    }
}

