/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.spring.boot.starter.socketio;

import com.corundumstudio.socketio.BroadcastAckCallback;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIOServer;
import com.corundumstudio.socketio.protocol.Packet;
import java.util.Collection;

public class SocketIoMessageTemplate {
    public static final String USER_ID_ROOM_PREFIX = "uid:";
    private final SocketIOServer server;

    public SocketIoMessageTemplate(SocketIOServer server) {
        this.server = server;
    }

    public Collection<SocketIOClient> getUserClients(String uid) {
        return this.server.getRoomOperations(USER_ID_ROOM_PREFIX + uid).getClients();
    }

    public <T> void sendToUser(String uid, Packet packet, BroadcastAckCallback<T> ackCallback) {
        this.server.getRoomOperations(USER_ID_ROOM_PREFIX + uid).send(packet, ackCallback);
    }

    public void sendEventToUser(String uid, String name, SocketIOClient excludedClient, Object ... data) {
        this.server.getRoomOperations(USER_ID_ROOM_PREFIX + uid).sendEvent(name, excludedClient, data);
    }

    public void sendEventToUser(String uid, String name, Object ... data) {
        this.server.getRoomOperations(USER_ID_ROOM_PREFIX + uid).sendEvent(name, data);
    }

    public <T> void sendEventToUser(String uid, String name, Object data, BroadcastAckCallback<T> ackCallback) {
        this.server.getRoomOperations(USER_ID_ROOM_PREFIX + uid).sendEvent(name, data, ackCallback);
    }

    public <T> void sendEventToUser(String uid, String name, Object data, SocketIOClient excludedClient, BroadcastAckCallback<T> ackCallback) {
        this.server.getRoomOperations(USER_ID_ROOM_PREFIX + uid).sendEvent(name, data, excludedClient, ackCallback);
    }

    public Collection<SocketIOClient> getTopicClients(String topic) {
        return this.server.getRoomOperations(topic).getClients();
    }

    public <T> void sendToTopic(String topic, Packet packet, BroadcastAckCallback<T> ackCallback) {
        this.server.getRoomOperations(topic).send(packet, ackCallback);
    }

    public void sendEventToTopic(String topic, String name, SocketIOClient excludedClient, Object ... data) {
        this.server.getRoomOperations(topic).sendEvent(name, excludedClient, data);
    }

    public void sendEventToTopic(String topic, String name, Object ... data) {
        this.server.getRoomOperations(topic).sendEvent(name, data);
    }

    public <T> void sendEventToTopic(String topic, String name, Object data, BroadcastAckCallback<T> ackCallback) {
        this.server.getRoomOperations(topic).sendEvent(name, data, ackCallback);
    }

    public <T> void sendEventToTopic(String topic, String name, Object data, SocketIOClient excludedClient, BroadcastAckCallback<T> ackCallback) {
        this.server.getRoomOperations(topic).sendEvent(name, data, excludedClient, ackCallback);
    }
}

