/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.spring.boot.starter.socketio.conf;

import com.corundumstudio.socketio.SocketIOClient;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Maps;
import io.github.opensabe.spring.boot.starter.socketio.AttributedSocketIoClient;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttributedSocketIoClientFactory {
    @Generated
    private static final Logger log = LogManager.getLogger(AttributedSocketIoClientFactory.class);
    private final Map<SocketIOClient, AttributedSocketIoClient> cache = Maps.newConcurrentMap();
    private final Cache<SocketIOClient, AttributedSocketIoClient> forRemoval = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).removalListener((key, value, cause) -> {
        log.info("AttributedSocketIoClientFactory, remove: {}", (Object)key.getSessionId());
        this.cache.remove(key);
    }).build();

    public AttributedSocketIoClientFactory() {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, r -> {
            Thread thread = new Thread(r);
            thread.setName("AttributedSocketIoClientFactory clean cache thread");
            thread.setDaemon(true);
            return thread;
        });
        scheduledExecutorService.scheduleAtFixedRate(() -> this.cache.entrySet().forEach(entry -> {
            if (!((SocketIOClient)entry.getKey()).isChannelOpen()) {
                log.info("AttributedSocketIoClientFactory, add to forRemoval: {}", (Object)((SocketIOClient)entry.getKey()).getSessionId());
                this.forRemoval.put((Object)((SocketIOClient)entry.getKey()), (Object)((AttributedSocketIoClient)entry.getValue()));
            }
        }), 1L, 1L, TimeUnit.MINUTES);
    }

    AttributedSocketIoClient addSocketIoClient(SocketIOClient socketIOClient) {
        AttributedSocketIoClient attributedSocketIoClient = new AttributedSocketIoClient(socketIOClient);
        this.cache.put(socketIOClient, attributedSocketIoClient);
        return attributedSocketIoClient;
    }

    public AttributedSocketIoClient getAttributedSocketIoClient(SocketIOClient socketIOClient) {
        return this.cache.get(socketIOClient);
    }

    public String getSocketIoClientUserId(SocketIOClient socketIOClient) {
        AttributedSocketIoClient attributedSocketIoClient = this.cache.get(socketIOClient);
        if (attributedSocketIoClient != null) {
            return attributedSocketIoClient.getUserId();
        }
        return null;
    }
}

