/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.spring.boot.starter.socketio.conf;

import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.HandshakeData;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.annotation.OnConnect;
import com.corundumstudio.socketio.annotation.OnEvent;
import io.github.opensabe.base.code.BizCodeEnum;
import io.github.opensabe.common.utils.json.JsonUtil;
import io.github.opensabe.spring.boot.starter.socketio.AttributedSocketIoClient;
import io.github.opensabe.spring.boot.starter.socketio.BaseAck;
import io.github.opensabe.spring.boot.starter.socketio.conf.AttributedSocketIoClientFactory;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Order(value=-2147482648)
@Configuration(proxyBeanMethods=false)
public class DefaultSocketIoHandlerConfiguration {
    @Generated
    private static final Logger log = LogManager.getLogger(DefaultSocketIoHandlerConfiguration.class);
    @Autowired
    private AttributedSocketIoClientFactory attributedSocketIoClientFactory;

    @OnConnect
    public void onConnect(SocketIOClient client) {
        HttpHeaders httpHeaders;
        AttributedSocketIoClient attributedSocketIoClient = this.attributedSocketIoClientFactory.addSocketIoClient(client);
        UUID socketSessionId = client.getSessionId();
        String ip = client.getRemoteAddress().toString();
        HandshakeData handshakeData = client.getHandshakeData();
        if (handshakeData != null && (httpHeaders = handshakeData.getHttpHeaders()) != null) {
            String operId;
            String uid = httpHeaders.get("uid");
            if (StringUtils.isNotBlank((CharSequence)uid)) {
                client.joinRoom("uid:" + uid);
                attributedSocketIoClient.setUserId(uid);
            }
            if (StringUtils.isNotBlank((CharSequence)(operId = httpHeaders.get("operId")))) {
                attributedSocketIoClient.setOperId(operId);
            }
        }
        log.info("DefaultSocketIoHandlerConfiguration-onConnect, socketSessionId:{}, ip:{}, headers: {}", (Object)socketSessionId, (Object)ip, (Object)client.getHandshakeData().getHttpHeaders().toString());
    }

    @OnEvent(value="sub")
    public void sub(SocketIOClient client, AckRequest request, String topic) {
        client.joinRoom(topic);
        log.info("DefaultSocketIoHandlerConfiguration-sub: client.id: {}, topic {}, allTopics: {}", (Object)client.getSessionId(), (Object)topic, (Object)JsonUtil.toJSONString((Object)client.getAllRooms()));
        request.sendAckData(new Object[]{BaseAck.builder().b(BizCodeEnum.SUCCESS.getVal()).build()});
    }

    @OnEvent(value="unsub")
    public void unsub(SocketIOClient client, AckRequest request, String topic) {
        client.leaveRoom(topic);
        log.info("DefaultSocketIoHandlerConfiguration-unsub: client.id: {}, topic {}, allTopics: {}", (Object)client.getSessionId(), (Object)topic, (Object)JsonUtil.toJSONString((Object)client.getAllRooms()));
        request.sendAckData(new Object[]{BaseAck.builder().b(BizCodeEnum.SUCCESS.getVal()).build()});
    }
}

