/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.spring.boot.starter.socketio.conf;

import com.corundumstudio.socketio.store.pubsub.PubSubListener;
import com.corundumstudio.socketio.store.pubsub.PubSubMessage;
import com.corundumstudio.socketio.store.pubsub.PubSubStore;
import com.corundumstudio.socketio.store.pubsub.PubSubType;
import io.github.opensabe.spring.boot.starter.socketio.conf.RedissonPubSubStoreMessageListener;
import io.github.opensabe.spring.boot.starter.socketio.conf.SocketIoServerProperties;
import io.netty.util.internal.PlatformDependent;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;

public class RedissonPubSubStore
implements PubSubStore {
    private final RedissonClient redissonPub;
    private final RedissonClient redissonSub;
    private final Long nodeId;
    private final String serviceName;
    private final SocketIoServerProperties socketIoServerProperties;
    private final ConcurrentMap<String, Queue<Integer>> map = PlatformDependent.newConcurrentHashMap();

    public RedissonPubSubStore(RedissonClient redissonPub, RedissonClient redissonSub, Long nodeId, SocketIoServerProperties socketIoServerProperties) {
        this.redissonPub = redissonPub;
        this.redissonSub = redissonSub;
        this.nodeId = nodeId;
        this.serviceName = socketIoServerProperties.getNameSpace();
        this.socketIoServerProperties = socketIoServerProperties;
    }

    public void publish(PubSubType type, PubSubMessage msg) {
        msg.setNodeId(this.nodeId);
        this.redissonPub.getTopic(this.getTopicName(type.toString())).publish((Object)msg);
    }

    public <T extends PubSubMessage> void subscribe(PubSubType type, PubSubListener<T> listener, Class<T> clazz) {
        Queue oldList;
        String name = this.getTopicName(type.toString());
        RTopic topic = this.redissonSub.getTopic(name);
        int regId = topic.addListener(PubSubMessage.class, new RedissonPubSubStoreMessageListener<T>(this.nodeId, listener, type, this.socketIoServerProperties));
        Queue<Integer> list = (ConcurrentLinkedQueue<Integer>)this.map.get(name);
        if (list == null && (oldList = (Queue)this.map.putIfAbsent(name, list = new ConcurrentLinkedQueue<Integer>())) != null) {
            list = oldList;
        }
        list.add(regId);
    }

    public void unsubscribe(PubSubType type) {
        String name = this.getTopicName(type.toString());
        Queue regIds = (Queue)this.map.remove(name);
        RTopic topic = this.redissonSub.getTopic(name);
        for (Integer id : regIds) {
            topic.removeListener(new Integer[]{id});
        }
    }

    private String getTopicName(String name) {
        return this.serviceName + "-" + name;
    }

    public void shutdown() {
    }
}

