/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.spring.boot.starter.socketio.conf;

import com.corundumstudio.socketio.store.pubsub.DispatchMessage;
import com.corundumstudio.socketio.store.pubsub.PubSubListener;
import com.corundumstudio.socketio.store.pubsub.PubSubMessage;
import com.corundumstudio.socketio.store.pubsub.PubSubType;
import io.github.opensabe.spring.boot.starter.socketio.conf.SocketIoHealthCheck;
import io.github.opensabe.spring.boot.starter.socketio.conf.SocketIoServerProperties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.redisson.api.listener.MessageListener;

public class RedissonPubSubStoreMessageListener<T>
implements MessageListener<PubSubMessage> {
    @Generated
    private static final Logger log = LogManager.getLogger(RedissonPubSubStoreMessageListener.class);
    final PubSubListener<T> listener;
    final SocketIoServerProperties socketIoServerProperties;
    private final Long nodeId;

    public RedissonPubSubStoreMessageListener(Long nodeId, PubSubListener<T> listener, PubSubType type, SocketIoServerProperties socketIoServerProperties) {
        this.nodeId = nodeId;
        this.listener = listener;
        this.socketIoServerProperties = socketIoServerProperties;
    }

    public void onMessage(CharSequence channel, PubSubMessage msg) {
        try {
            if (msg instanceof DispatchMessage) {
                boolean match;
                boolean bl = match = StringUtils.isBlank((CharSequence)this.socketIoServerProperties.getHealthCheckPacketName()) || StringUtils.equalsIgnoreCase((CharSequence)((DispatchMessage)msg).getPacket().getName(), (CharSequence)this.socketIoServerProperties.getHealthCheckPacketName());
                if (match) {
                    SocketIoHealthCheck.lastDispatchMessage = System.currentTimeMillis();
                }
            }
            if (!this.nodeId.equals(msg.getNodeId())) {
                this.listener.onMessage((Object)msg);
            }
        }
        catch (Throwable e) {
            log.error("RedissonPubSubStoreMessageListener-onMessage: error: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

