/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.spring.boot.starter.socketio.conf;

import com.corundumstudio.socketio.store.RedissonStore;
import com.corundumstudio.socketio.store.Store;
import com.corundumstudio.socketio.store.pubsub.BaseStoreFactory;
import com.corundumstudio.socketio.store.pubsub.PubSubStore;
import io.github.opensabe.spring.boot.starter.socketio.conf.RedissonPubSubStore;
import io.github.opensabe.spring.boot.starter.socketio.conf.SocketIoServerProperties;
import java.util.Map;
import java.util.UUID;
import org.redisson.api.RedissonClient;

public class RedissonStoreFactory
extends BaseStoreFactory {
    private final RedissonClient redisClient;
    private final RedissonClient redisPub;
    private final RedissonClient redisSub;
    private final PubSubStore pubSubStore;

    public RedissonStoreFactory(RedissonClient redisson, SocketIoServerProperties socketIoServerProperties) {
        this.redisClient = redisson;
        this.redisPub = redisson;
        this.redisSub = redisson;
        this.pubSubStore = new RedissonPubSubStore(this.redisPub, this.redisSub, this.getNodeId(), socketIoServerProperties);
    }

    public Store createStore(UUID sessionId) {
        return new RedissonStore(sessionId, this.redisClient);
    }

    public PubSubStore pubSubStore() {
        return this.pubSubStore;
    }

    public void shutdown() {
        this.redisClient.shutdown();
        this.redisPub.shutdown();
        this.redisSub.shutdown();
    }

    public <K, V> Map<K, V> createMap(String name) {
        return this.redisClient.getMap(name);
    }
}

