/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.spring.boot.starter.socketio.conf;

import com.corundumstudio.socketio.SocketIOServer;
import com.corundumstudio.socketio.annotation.OnConnect;
import com.corundumstudio.socketio.annotation.OnDisconnect;
import com.corundumstudio.socketio.annotation.OnEvent;
import com.corundumstudio.socketio.listener.DefaultExceptionListener;
import com.corundumstudio.socketio.listener.ExceptionListener;
import com.corundumstudio.socketio.store.StoreFactory;
import com.netflix.discovery.EurekaClient;
import io.github.opensabe.spring.boot.starter.rocketmq.AbstractMQConsumer;
import io.github.opensabe.spring.boot.starter.rocketmq.MQProducer;
import io.github.opensabe.spring.boot.starter.socketio.SocketIoMessageTemplate;
import io.github.opensabe.spring.boot.starter.socketio.conf.AttributedSocketIoClientFactory;
import io.github.opensabe.spring.boot.starter.socketio.conf.RedissonStoreFactory;
import io.github.opensabe.spring.boot.starter.socketio.conf.SocketIoEurekaMetadataModifier;
import io.github.opensabe.spring.boot.starter.socketio.conf.SocketIoHealthCheck;
import io.github.opensabe.spring.boot.starter.socketio.conf.SocketIoServerProperties;
import io.github.opensabe.spring.boot.starter.socketio.tracing.extend.NamespaceExtend;
import io.github.opensabe.spring.boot.starter.socketio.util.ForceDisconnectConsumer;
import io.github.opensabe.spring.boot.starter.socketio.util.ForceDisconnectProducer;
import io.github.opensabe.spring.boot.starter.socketio.util.SocketConnectionUtil;
import io.netty.channel.epoll.Epoll;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.ReflectionUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SocketIoServerProperties.class})
public class SocketIoConfiguration {
    @Generated
    private static final Logger log = LogManager.getLogger(SocketIoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public OrderedSpringAnnotationScanner springAnnotationScanner() {
        return new OrderedSpringAnnotationScanner();
    }

    @Bean
    @ConditionalOnMissingBean
    public ListenerAdder listenerAdder(SocketIOServer server, OrderedSpringAnnotationScanner scanner) {
        return new ListenerAdder(server, scanner);
    }

    @Bean
    @ConditionalOnMissingBean
    public ExceptionListener exceptionListener() {
        return new DefaultExceptionListener();
    }

    @Bean
    @ConditionalOnMissingBean
    public SocketIOServer server(SocketIoServerProperties socketIoServerProperties, StoreFactory storeFactory, ExceptionListener exceptionListener) {
        socketIoServerProperties.setStoreFactory(storeFactory);
        socketIoServerProperties.setExceptionListener(exceptionListener);
        if (socketIoServerProperties.isUseLinuxNativeEpoll() && !Epoll.isAvailable()) {
            log.warn("SocketIoConfiguration-server: Epoll library not available, disabling native epoll");
            socketIoServerProperties.setUseLinuxNativeEpoll(false);
        }
        socketIoServerProperties.setDefaultNamespace(new NamespaceExtend("", socketIoServerProperties.cloneForNamespace()));
        SocketIOServer socketIOServer = new SocketIOServer((com.corundumstudio.socketio.Configuration)socketIoServerProperties);
        return socketIOServer;
    }

    @Bean
    public SocketIoMessageTemplate socketIoMessageTemplate(SocketIOServer server) {
        return new SocketIoMessageTemplate(server);
    }

    @Bean
    public SocketIOServerLifecycle serverLifecycle(SocketIOServer socketIOServer) {
        return new SocketIOServerLifecycle(socketIOServer);
    }

    @Bean
    public AttributedSocketIoClientFactory attributedSocketIoClientFactory() {
        return new AttributedSocketIoClientFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public RedissonStoreFactory redissonStoreFactory(RedissonClient redissonClient, SocketIoServerProperties serverProperties) {
        return new RedissonStoreFactory(redissonClient, serverProperties);
    }

    @Bean
    @ConditionalOnClass(value={EurekaClient.class})
    public SocketIoEurekaMetadataModifier socketIoEurekaMetadataModifier(SocketIoServerProperties serverProperties) {
        return new SocketIoEurekaMetadataModifier(serverProperties);
    }

    @Bean
    @ConditionalOnBean(value={MQProducer.class})
    public ForceDisconnectProducer forceDisconnectProducer(MQProducer mqProducer) {
        return new ForceDisconnectProducer(mqProducer);
    }

    @Bean
    @ConditionalOnClass(value={AbstractMQConsumer.class})
    @ConditionalOnBean(value={MQProducer.class})
    public ForceDisconnectConsumer forceDisconnectConsumer(SocketIOServer socketIOServer) {
        return new ForceDisconnectConsumer(socketIOServer);
    }

    @Bean
    @ConditionalOnBean(value={ForceDisconnectProducer.class})
    public SocketConnectionUtil socketConnectionUtil(ForceDisconnectProducer forceDisconnectProducer) {
        return new SocketConnectionUtil(forceDisconnectProducer);
    }

    @Bean
    public SocketIoHealthCheck socketIoHealthCheck() {
        return new SocketIoHealthCheck();
    }

    public static class OrderedSpringAnnotationScanner
    implements BeanPostProcessor {
        private final List<Class<? extends Annotation>> annotations = Arrays.asList(OnConnect.class, OnDisconnect.class, OnEvent.class);
        private final Set<Object> listeners = new HashSet<Object>();

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            AtomicBoolean add = new AtomicBoolean();
            ReflectionUtils.doWithMethods(bean.getClass(), method -> add.set(true), method -> {
                for (Class<? extends Annotation> annotationClass : this.annotations) {
                    if (!method.isAnnotationPresent(annotationClass)) continue;
                    return true;
                }
                return false;
            });
            if (add.get()) {
                this.listeners.add(bean);
            }
            return bean;
        }
    }

    public static class ListenerAdder
    implements ApplicationListener<ApplicationStartedEvent> {
        private final OrderedSpringAnnotationScanner scanner;
        private final SocketIOServer server;

        public ListenerAdder(SocketIOServer server, OrderedSpringAnnotationScanner scanner) {
            this.server = server;
            this.scanner = scanner;
        }

        public void onApplicationEvent(ApplicationStartedEvent event) {
            ArrayList<Object> list = new ArrayList<Object>(this.scanner.listeners);
            AnnotationAwareOrderComparator.sort(list);
            list.forEach(l -> {
                this.server.addListeners(l, l.getClass());
                log.info("{} bean listeners added", l.getClass());
            });
        }
    }

    public static class SocketIOServerLifecycle
    implements SmartLifecycle {
        @Generated
        private static final Logger log = LogManager.getLogger(SocketIOServerLifecycle.class);
        private final SocketIOServer server;
        private volatile boolean running = false;

        public SocketIOServerLifecycle(SocketIOServer server) {
            this.server = server;
        }

        public void start() {
            try {
                this.server.start();
            }
            catch (Throwable e) {
                log.fatal("SocketIOServerLifecycle-start failed, {}", (Object)e.getMessage(), (Object)e);
            }
            this.running = true;
        }

        public void stop() {
            try {
                this.server.stop();
            }
            catch (Throwable e) {
                log.fatal("SocketIOServerLifecycle-stop failed, {}", (Object)e.getMessage(), (Object)e);
            }
            this.running = false;
        }

        public boolean isRunning() {
            return this.running;
        }
    }
}

