/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.spring.boot.starter.socketio.tracing.jfr;

import io.github.opensabe.common.jfr.ObservationToJFRGenerator;
import io.github.opensabe.spring.boot.starter.socketio.tracing.EventEnum;
import io.github.opensabe.spring.boot.starter.socketio.tracing.jfr.SocketIODisConnectEvent;
import io.github.opensabe.spring.boot.starter.socketio.tracing.observation.SocketIOExecuteContext;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.handler.TracingObservationHandler;
import java.util.Objects;

public class DisConnectExecuteJFRGenerator
extends ObservationToJFRGenerator<SocketIOExecuteContext> {
    public Class<SocketIOExecuteContext> getContextClazz() {
        return SocketIOExecuteContext.class;
    }

    protected boolean shouldCommitOnStop(SocketIOExecuteContext context) {
        return context.containsKey(SocketIODisConnectEvent.class);
    }

    protected boolean shouldGenerateOnStart(SocketIOExecuteContext context) {
        return context.getEventEnum() == EventEnum.OnDisconnect;
    }

    protected void commitOnStop(SocketIOExecuteContext context) {
        SocketIODisConnectEvent event = (SocketIODisConnectEvent)context.get(SocketIODisConnectEvent.class);
        TracingObservationHandler.TracingContext tracingContext = (TracingObservationHandler.TracingContext)context.get(TracingObservationHandler.TracingContext.class);
        if (Objects.nonNull(tracingContext)) {
            TraceContext traceContext = tracingContext.getSpan().context();
            event.setTraceId(traceContext.traceId());
            event.setSpanId(traceContext.spanId());
        }
        event.commit();
    }

    protected void generateOnStart(SocketIOExecuteContext context) {
        SocketIODisConnectEvent event = new SocketIODisConnectEvent(context);
        context.put(SocketIODisConnectEvent.class, event);
    }
}

