/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.spring.boot.starter.socketio.util;

import com.alibaba.fastjson.JSON;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIOServer;
import io.github.opensabe.common.entity.base.vo.BaseMQMessage;
import io.github.opensabe.common.utils.json.JsonUtil;
import io.github.opensabe.spring.boot.starter.rocketmq.AbstractMQConsumer;
import io.github.opensabe.spring.boot.starter.socketio.util.ForceDisconnectProducer;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;

@RocketMQMessageListener(consumerGroup="${spring.application.name}_force_disconnect_SuperKickForceDisconnect", consumeMode=ConsumeMode.CONCURRENTLY, topic="force_disconnect", messageModel=MessageModel.BROADCASTING, consumeThreadNumber=64)
public class ForceDisconnectConsumer
extends AbstractMQConsumer {
    @Generated
    private static final Logger log = LogManager.getLogger(ForceDisconnectConsumer.class);
    private SocketIOServer socketIOServer;

    public ForceDisconnectConsumer(SocketIOServer socketIOServer) {
        this.socketIOServer = socketIOServer;
    }

    protected void onBaseMQMessage(BaseMQMessage baseMQMessage) {
        log.info("ForceDisconnectConsumer-onBaseMQMessage {}", (Object)JsonUtil.toJSONString((Object)baseMQMessage));
        ForceDisconnectProducer.ForceDisconnectDTO forceDisconnectDTO = (ForceDisconnectProducer.ForceDisconnectDTO)JSON.parseObject((String)baseMQMessage.getData(), ForceDisconnectProducer.ForceDisconnectDTO.class);
        Collection clients = this.socketIOServer.getRoomOperations(forceDisconnectDTO.getRoomId()).getClients();
        for (SocketIOClient socketIOClient : clients) {
            UUID existSession = socketIOClient.getSessionId();
            UUID currentSession = forceDisconnectDTO.getSession();
            String userId = forceDisconnectDTO.getUserId();
            if (Objects.equals(currentSession, existSession)) continue;
            log.info("ForceDisconnectConsumer-onBaseMQMessage [force disconnected] userId:{}, currentSession:{}, existSession:{}", (Object)userId, (Object)currentSession, (Object)existSession);
            socketIOClient.disconnect();
        }
    }
}

