/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.spring.boot.starter.socketio.util;

import io.github.opensabe.spring.boot.starter.rocketmq.MQProducer;
import java.io.Serializable;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;

public class ForceDisconnectProducer {
    @Generated
    private static final Logger log = LogManager.getLogger(ForceDisconnectProducer.class);
    public static final String MQ_TOPIC_FORCE_DISCONNECT = "force_disconnect";
    public static final String MQ_TOPIC_LOGOUT = "force_logout";
    private MQProducer mqProducer;

    public ForceDisconnectProducer(MQProducer mqProducer) {
        this.mqProducer = mqProducer;
    }

    public void sendForceDisconnectMsg(String userId, UUID session, String roomId) {
        this.mqProducer.sendAsync(MQ_TOPIC_FORCE_DISCONNECT, (Object)new ForceDisconnectDTO(userId, session, roomId), new SendCallback(this){

            public void onSuccess(SendResult sendResult) {
                log.info("ForceDisconnectProducer-sendForceDisconnectMsg [success], msgId:{}", (Object)sendResult.getMsgId());
            }

            public void onException(Throwable throwable) {
                log.info("ForceDisconnectProducer-sendForceDisconnectMsg [exception]", throwable);
            }
        });
    }

    public void logout(String userId) {
        this.mqProducer.sendAsync(MQ_TOPIC_LOGOUT, (Object)new ForceDisconnectDTO(userId, null, null), new SendCallback(this){

            public void onSuccess(SendResult sendResult) {
                log.info("ForceDisconnectProducer-logout [success], msgId:{}", (Object)sendResult.getMsgId());
            }

            public void onException(Throwable throwable) {
                log.info("ForceDisconnectProducer-logout [exception]", throwable);
            }
        });
    }

    public static class ForceDisconnectDTO
    implements Serializable {
        private String userId;
        private UUID session;
        private String roomId;

        public ForceDisconnectDTO(String userId, UUID session, String roomId) {
            this.userId = userId;
            this.session = session;
            this.roomId = roomId;
        }

        @Generated
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @Generated
        public void setSession(UUID session) {
            this.session = session;
        }

        @Generated
        public void setRoomId(String roomId) {
            this.roomId = roomId;
        }

        @Generated
        public String getUserId() {
            return this.userId;
        }

        @Generated
        public UUID getSession() {
            return this.session;
        }

        @Generated
        public String getRoomId() {
            return this.roomId;
        }
    }
}

