/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.spring.boot.starter.socketio.util;

import com.corundumstudio.socketio.SocketIOClient;
import io.github.opensabe.spring.boot.starter.socketio.util.ForceDisconnectProducer;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SocketConnectionUtil {
    @Generated
    private static final Logger log = LogManager.getLogger(SocketConnectionUtil.class);
    private ForceDisconnectProducer forceDisconnectProducer;

    public SocketConnectionUtil(ForceDisconnectProducer forceDisconnectProducer) {
        this.forceDisconnectProducer = forceDisconnectProducer;
    }

    public void forceDisconnect(String gameFLg, SocketIOClient currentClient, ForceTypeEnum forceTypeEnum) throws Exception {
        HttpHeaders httpHeaders = currentClient.getHandshakeData().getHttpHeaders();
        String platform = httpHeaders.get("platform");
        String userId = httpHeaders.get("uid");
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw new Exception("userId is required");
        }
        String operatorId = httpHeaders.get("operId");
        UUID sessionId = currentClient.getSessionId();
        String checkPlatformRoom = gameFLg + "_" + userId;
        if (ForceTypeEnum.ONE_USER_ONE_PLATFORM.equals((Object)forceTypeEnum)) {
            if (StringUtils.isBlank((CharSequence)platform)) {
                throw new Exception("platform is required");
            }
            checkPlatformRoom = checkPlatformRoom + "_" + platform;
        }
        currentClient.joinRoom(checkPlatformRoom);
        log.info("SocketConnectionUtil-forceDisconnect [send force disconnect message] userId:{}, sessionId:{}, roomId:{}", (Object)userId, (Object)sessionId, (Object)checkPlatformRoom);
        this.forceDisconnectProducer.sendForceDisconnectMsg(userId, sessionId, checkPlatformRoom);
    }

    public void logout(String userId) {
        this.forceDisconnectProducer.logout(userId);
    }

    public static enum ForceTypeEnum {
        ONE_USER_ALL_PLATFORM,
        ONE_USER_ONE_PLATFORM;

    }
}

