package pluginloader.api

/**
 * Call method on load
 * Extremely recommend use internal, for compatibility with java 11+
 * ```
 * @Load
 * internal fun load(plugin: LoaderPlugin){}
 * //Or 'plugin: Plugin' on bukkit api
 * ```
 * @param plugin [LoaderPlugin]
 */
@Target(AnnotationTarget.FUNCTION)
@Retention(AnnotationRetention.RUNTIME)
annotation class Load

/**
 * Call method on unload, must be zero args
 * Calling before [LoaderPlugin.unloadHandler]
 * Extremely recommend use internal, for compatibility with java 11+
 * ```
 * @Unload
 * internal fun unload(){}
 * ```
 */
@Target(AnnotationTarget.FUNCTION)
@Retention(AnnotationRetention.RUNTIME)
annotation class Unload

/**
 * Initialize field with current plugin instance
 * Extremely recommend use internal, for compatibility with java 11+
 * ```
 * @Plu
 * internal lateinit var plu: LoaderPlugin //or Plugin
 * ```
 */
@Target(AnnotationTarget.FIELD)
@Retention(AnnotationRetention.RUNTIME)
annotation class Plu

/**
 * Call method after loading all expanding plugins
 * Extremely recommend use internal, for compatibility with java 11+
 * ```
 * @PostExpand
 * internal fun postExpand(){}
 * ```
 */
@Target(AnnotationTarget.FUNCTION)
@Retention(AnnotationRetention.RUNTIME)
annotation class PostExpand