/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.api;

import com.google.gson.reflect.TypeToken;
import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.model.SecretCreate;
import io.github.pod4dev.libpodj.model.SecretCreateLibpod201Response;
import io.github.pod4dev.libpodj.model.SecretInfoReportCompat;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.validation.constraints.NotNull;
import okhttp3.Call;

public class SecretsCompatApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SecretsCompatApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SecretsCompatApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call secretCreateCall(SecretCreate create, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretCreate localVarPostBody = create;
        String localVarPath = "/secrets/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call secretCreateValidateBeforeCall(SecretCreate create, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.secretCreateCall(create, _callback);
        return localVarCall;
    }

    private ApiResponse<SecretCreateLibpod201Response> secretCreateWithHttpInfo(SecretCreate create) throws ApiException {
        Call localVarCall = this.secretCreateValidateBeforeCall(create, null);
        Type localVarReturnType = new TypeToken<SecretCreateLibpod201Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call secretCreateAsync(SecretCreate create, ApiCallback<SecretCreateLibpod201Response> _callback) throws ApiException {
        Call localVarCall = this.secretCreateValidateBeforeCall(create, _callback);
        Type localVarReturnType = new TypeToken<SecretCreateLibpod201Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsecretCreateRequest secretCreate() {
        return new APIsecretCreateRequest();
    }

    private Call secretDeleteCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/secrets/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call secretDeleteValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling secretDelete(Async)");
        }
        Call localVarCall = this.secretDeleteCall(name, _callback);
        return localVarCall;
    }

    private ApiResponse<Void> secretDeleteWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.secretDeleteValidateBeforeCall(name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call secretDeleteAsync(String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.secretDeleteValidateBeforeCall(name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIsecretDeleteRequest secretDelete(String name) {
        return new APIsecretDeleteRequest(name);
    }

    private Call secretInspectCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/secrets/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call secretInspectValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling secretInspect(Async)");
        }
        Call localVarCall = this.secretInspectCall(name, _callback);
        return localVarCall;
    }

    private ApiResponse<SecretInfoReportCompat> secretInspectWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.secretInspectValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<SecretInfoReportCompat>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call secretInspectAsync(String name, ApiCallback<SecretInfoReportCompat> _callback) throws ApiException {
        Call localVarCall = this.secretInspectValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<SecretInfoReportCompat>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsecretInspectRequest secretInspect(String name) {
        return new APIsecretInspectRequest(name);
    }

    private Call secretListCall(String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/secrets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call secretListValidateBeforeCall(String filters, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.secretListCall(filters, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SecretInfoReportCompat>> secretListWithHttpInfo(String filters) throws ApiException {
        Call localVarCall = this.secretListValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<List<SecretInfoReportCompat>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call secretListAsync(String filters, ApiCallback<List<SecretInfoReportCompat>> _callback) throws ApiException {
        Call localVarCall = this.secretListValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<List<SecretInfoReportCompat>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsecretListRequest secretList() {
        return new APIsecretListRequest();
    }

    public class APIsecretCreateRequest {
        private SecretCreate create;

        private APIsecretCreateRequest() {
        }

        public APIsecretCreateRequest create(SecretCreate create) {
            this.create = create;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SecretsCompatApi.this.secretCreateCall(this.create, _callback);
        }

        public SecretCreateLibpod201Response execute() throws ApiException {
            ApiResponse<SecretCreateLibpod201Response> localVarResp = SecretsCompatApi.this.secretCreateWithHttpInfo(this.create);
            return localVarResp.getData();
        }

        public ApiResponse<SecretCreateLibpod201Response> executeWithHttpInfo() throws ApiException {
            return SecretsCompatApi.this.secretCreateWithHttpInfo(this.create);
        }

        public Call executeAsync(ApiCallback<SecretCreateLibpod201Response> _callback) throws ApiException {
            return SecretsCompatApi.this.secretCreateAsync(this.create, _callback);
        }
    }

    public class APIsecretDeleteRequest {
        private final String name;

        private APIsecretDeleteRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SecretsCompatApi.this.secretDeleteCall(this.name, _callback);
        }

        public void execute() throws ApiException {
            SecretsCompatApi.this.secretDeleteWithHttpInfo(this.name);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return SecretsCompatApi.this.secretDeleteWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return SecretsCompatApi.this.secretDeleteAsync(this.name, _callback);
        }
    }

    public class APIsecretInspectRequest {
        private final String name;

        private APIsecretInspectRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SecretsCompatApi.this.secretInspectCall(this.name, _callback);
        }

        public SecretInfoReportCompat execute() throws ApiException {
            ApiResponse<SecretInfoReportCompat> localVarResp = SecretsCompatApi.this.secretInspectWithHttpInfo(this.name);
            return localVarResp.getData();
        }

        public ApiResponse<SecretInfoReportCompat> executeWithHttpInfo() throws ApiException {
            return SecretsCompatApi.this.secretInspectWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<SecretInfoReportCompat> _callback) throws ApiException {
            return SecretsCompatApi.this.secretInspectAsync(this.name, _callback);
        }
    }

    public class APIsecretListRequest {
        private String filters;

        private APIsecretListRequest() {
        }

        public APIsecretListRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SecretsCompatApi.this.secretListCall(this.filters, _callback);
        }

        public List<SecretInfoReportCompat> execute() throws ApiException {
            ApiResponse<List<SecretInfoReportCompat>> localVarResp = SecretsCompatApi.this.secretListWithHttpInfo(this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<List<SecretInfoReportCompat>> executeWithHttpInfo() throws ApiException {
            return SecretsCompatApi.this.secretListWithHttpInfo(this.filters);
        }

        public Call executeAsync(ApiCallback<List<SecretInfoReportCompat>> _callback) throws ApiException {
            return SecretsCompatApi.this.secretListAsync(this.filters, _callback);
        }
    }
}

