/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

public class History
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_AUTHOR = "author";
    @SerializedName(value="author")
    private String author;
    public static final String SERIALIZED_NAME_COMMENT = "comment";
    @SerializedName(value="comment")
    private String comment;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_CREATED_BY = "created_by";
    @SerializedName(value="created_by")
    private String createdBy;
    public static final String SERIALIZED_NAME_EMPTY_LAYER = "empty_layer";
    @SerializedName(value="empty_layer")
    private Boolean emptyLayer;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public History author(String author) {
        this.author = author;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Author is the author of the build point.")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public History comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Comment is a custom message set when creating the layer.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public History created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Created is the combined date and time at which the layer was created, formatted as defined by RFC 3339, section 5.6.")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public History createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CreatedBy is the command which created the layer.")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public History emptyLayer(Boolean emptyLayer) {
        this.emptyLayer = emptyLayer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EmptyLayer is used to mark if the history item created a filesystem diff.")
    public Boolean getEmptyLayer() {
        return this.emptyLayer;
    }

    public void setEmptyLayer(Boolean emptyLayer) {
        this.emptyLayer = emptyLayer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        History history = (History)o;
        return Objects.equals(this.author, history.author) && Objects.equals(this.comment, history.comment) && Objects.equals(this.created, history.created) && Objects.equals(this.createdBy, history.createdBy) && Objects.equals(this.emptyLayer, history.emptyLayer);
    }

    public int hashCode() {
        return Objects.hash(this.author, this.comment, this.created, this.createdBy, this.emptyLayer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class History {\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    emptyLayer: ").append(this.toIndentedString(this.emptyLayer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in History is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `History` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTHOR) != null && !jsonObj.get(SERIALIZED_NAME_AUTHOR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_AUTHOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `author` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMENT) != null && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `comment` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREATED_BY) != null && !jsonObj.get(SERIALIZED_NAME_CREATED_BY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CREATED_BY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `created_by` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREATED_BY).toString()));
        }
    }

    public static History fromJson(String jsonString) throws IOException {
        return (History)JSON.getGson().fromJson(jsonString, History.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUTHOR);
        openapiFields.add(SERIALIZED_NAME_COMMENT);
        openapiFields.add(SERIALIZED_NAME_CREATED);
        openapiFields.add(SERIALIZED_NAME_CREATED_BY);
        openapiFields.add(SERIALIZED_NAME_EMPTY_LAYER);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!History.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(History.class));
            return new TypeAdapter<History>(){

                public void write(JsonWriter out, History value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public History read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    History.validateJsonObject(jsonObj);
                    return (History)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

