/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.ContainerNetworkStats;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ContainerStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_AVG_C_P_U = "AvgCPU";
    @SerializedName(value="AvgCPU")
    private Double avgCPU;
    public static final String SERIALIZED_NAME_BLOCK_INPUT = "BlockInput";
    @SerializedName(value="BlockInput")
    private Integer blockInput;
    public static final String SERIALIZED_NAME_BLOCK_OUTPUT = "BlockOutput";
    @SerializedName(value="BlockOutput")
    private Integer blockOutput;
    public static final String SERIALIZED_NAME_C_P_U = "CPU";
    @SerializedName(value="CPU")
    private Double CPU;
    public static final String SERIALIZED_NAME_CP_U_NANO = "CPUNano";
    @SerializedName(value="CPUNano")
    private Integer cpUNano;
    public static final String SERIALIZED_NAME_CP_U_SYSTEM_NANO = "CPUSystemNano";
    @SerializedName(value="CPUSystemNano")
    private Integer cpUSystemNano;
    public static final String SERIALIZED_NAME_CONTAINER_I_D = "ContainerID";
    @SerializedName(value="ContainerID")
    private String containerID;
    public static final String SERIALIZED_NAME_DURATION = "Duration";
    @SerializedName(value="Duration")
    private Integer duration;
    public static final String SERIALIZED_NAME_MEM_LIMIT = "MemLimit";
    @SerializedName(value="MemLimit")
    private Integer memLimit;
    public static final String SERIALIZED_NAME_MEM_PERC = "MemPerc";
    @SerializedName(value="MemPerc")
    private Double memPerc;
    public static final String SERIALIZED_NAME_MEM_USAGE = "MemUsage";
    @SerializedName(value="MemUsage")
    private Integer memUsage;
    public static final String SERIALIZED_NAME_NAME = "Name";
    @SerializedName(value="Name")
    private String name;
    public static final String SERIALIZED_NAME_NETWORK = "Network";
    @SerializedName(value="Network")
    private Map<String, ContainerNetworkStats> network = new HashMap<String, ContainerNetworkStats>();
    public static final String SERIALIZED_NAME_PI_DS = "PIDs";
    @SerializedName(value="PIDs")
    private Integer piDs;
    public static final String SERIALIZED_NAME_PER_C_P_U = "PerCPU";
    @SerializedName(value="PerCPU")
    private List<Integer> perCPU = new ArrayList<Integer>();
    public static final String SERIALIZED_NAME_SYSTEM_NANO = "SystemNano";
    @SerializedName(value="SystemNano")
    private Integer systemNano;
    public static final String SERIALIZED_NAME_UP_TIME = "UpTime";
    @SerializedName(value="UpTime")
    private Long upTime;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ContainerStats avgCPU(Double avgCPU) {
        this.avgCPU = avgCPU;
        return this;
    }

    @Nullable
    public Double getAvgCPU() {
        return this.avgCPU;
    }

    public void setAvgCPU(Double avgCPU) {
        this.avgCPU = avgCPU;
    }

    public ContainerStats blockInput(Integer blockInput) {
        this.blockInput = blockInput;
        return this;
    }

    @Nullable
    public Integer getBlockInput() {
        return this.blockInput;
    }

    public void setBlockInput(Integer blockInput) {
        this.blockInput = blockInput;
    }

    public ContainerStats blockOutput(Integer blockOutput) {
        this.blockOutput = blockOutput;
        return this;
    }

    @Nullable
    public Integer getBlockOutput() {
        return this.blockOutput;
    }

    public void setBlockOutput(Integer blockOutput) {
        this.blockOutput = blockOutput;
    }

    public ContainerStats CPU(Double CPU) {
        this.CPU = CPU;
        return this;
    }

    @Nullable
    public Double getCPU() {
        return this.CPU;
    }

    public void setCPU(Double CPU) {
        this.CPU = CPU;
    }

    public ContainerStats cpUNano(Integer cpUNano) {
        this.cpUNano = cpUNano;
        return this;
    }

    @Nullable
    public Integer getCpUNano() {
        return this.cpUNano;
    }

    public void setCpUNano(Integer cpUNano) {
        this.cpUNano = cpUNano;
    }

    public ContainerStats cpUSystemNano(Integer cpUSystemNano) {
        this.cpUSystemNano = cpUSystemNano;
        return this;
    }

    @Nullable
    public Integer getCpUSystemNano() {
        return this.cpUSystemNano;
    }

    public void setCpUSystemNano(Integer cpUSystemNano) {
        this.cpUSystemNano = cpUSystemNano;
    }

    public ContainerStats containerID(String containerID) {
        this.containerID = containerID;
        return this;
    }

    @Nullable
    public String getContainerID() {
        return this.containerID;
    }

    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    public ContainerStats duration(Integer duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public ContainerStats memLimit(Integer memLimit) {
        this.memLimit = memLimit;
        return this;
    }

    @Nullable
    public Integer getMemLimit() {
        return this.memLimit;
    }

    public void setMemLimit(Integer memLimit) {
        this.memLimit = memLimit;
    }

    public ContainerStats memPerc(Double memPerc) {
        this.memPerc = memPerc;
        return this;
    }

    @Nullable
    public Double getMemPerc() {
        return this.memPerc;
    }

    public void setMemPerc(Double memPerc) {
        this.memPerc = memPerc;
    }

    public ContainerStats memUsage(Integer memUsage) {
        this.memUsage = memUsage;
        return this;
    }

    @Nullable
    public Integer getMemUsage() {
        return this.memUsage;
    }

    public void setMemUsage(Integer memUsage) {
        this.memUsage = memUsage;
    }

    public ContainerStats name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContainerStats network(Map<String, ContainerNetworkStats> network) {
        this.network = network;
        return this;
    }

    public ContainerStats putNetworkItem(String key, ContainerNetworkStats networkItem) {
        if (this.network == null) {
            this.network = new HashMap<String, ContainerNetworkStats>();
        }
        this.network.put(key, networkItem);
        return this;
    }

    @Nullable
    @Valid
    public Map<String, ContainerNetworkStats> getNetwork() {
        return this.network;
    }

    public void setNetwork(Map<String, ContainerNetworkStats> network) {
        this.network = network;
    }

    public ContainerStats piDs(Integer piDs) {
        this.piDs = piDs;
        return this;
    }

    @Nullable
    public Integer getPiDs() {
        return this.piDs;
    }

    public void setPiDs(Integer piDs) {
        this.piDs = piDs;
    }

    public ContainerStats perCPU(List<Integer> perCPU) {
        this.perCPU = perCPU;
        return this;
    }

    public ContainerStats addPerCPUItem(Integer perCPUItem) {
        if (this.perCPU == null) {
            this.perCPU = new ArrayList<Integer>();
        }
        this.perCPU.add(perCPUItem);
        return this;
    }

    @Nullable
    public List<Integer> getPerCPU() {
        return this.perCPU;
    }

    public void setPerCPU(List<Integer> perCPU) {
        this.perCPU = perCPU;
    }

    public ContainerStats systemNano(Integer systemNano) {
        this.systemNano = systemNano;
        return this;
    }

    @Nullable
    public Integer getSystemNano() {
        return this.systemNano;
    }

    public void setSystemNano(Integer systemNano) {
        this.systemNano = systemNano;
    }

    public ContainerStats upTime(Long upTime) {
        this.upTime = upTime;
        return this;
    }

    @Nullable
    public Long getUpTime() {
        return this.upTime;
    }

    public void setUpTime(Long upTime) {
        this.upTime = upTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerStats containerStats = (ContainerStats)o;
        return Objects.equals(this.avgCPU, containerStats.avgCPU) && Objects.equals(this.blockInput, containerStats.blockInput) && Objects.equals(this.blockOutput, containerStats.blockOutput) && Objects.equals(this.CPU, containerStats.CPU) && Objects.equals(this.cpUNano, containerStats.cpUNano) && Objects.equals(this.cpUSystemNano, containerStats.cpUSystemNano) && Objects.equals(this.containerID, containerStats.containerID) && Objects.equals(this.duration, containerStats.duration) && Objects.equals(this.memLimit, containerStats.memLimit) && Objects.equals(this.memPerc, containerStats.memPerc) && Objects.equals(this.memUsage, containerStats.memUsage) && Objects.equals(this.name, containerStats.name) && Objects.equals(this.network, containerStats.network) && Objects.equals(this.piDs, containerStats.piDs) && Objects.equals(this.perCPU, containerStats.perCPU) && Objects.equals(this.systemNano, containerStats.systemNano) && Objects.equals(this.upTime, containerStats.upTime);
    }

    public int hashCode() {
        return Objects.hash(this.avgCPU, this.blockInput, this.blockOutput, this.CPU, this.cpUNano, this.cpUSystemNano, this.containerID, this.duration, this.memLimit, this.memPerc, this.memUsage, this.name, this.network, this.piDs, this.perCPU, this.systemNano, this.upTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerStats {\n");
        sb.append("    avgCPU: ").append(this.toIndentedString(this.avgCPU)).append("\n");
        sb.append("    blockInput: ").append(this.toIndentedString(this.blockInput)).append("\n");
        sb.append("    blockOutput: ").append(this.toIndentedString(this.blockOutput)).append("\n");
        sb.append("    CPU: ").append(this.toIndentedString(this.CPU)).append("\n");
        sb.append("    cpUNano: ").append(this.toIndentedString(this.cpUNano)).append("\n");
        sb.append("    cpUSystemNano: ").append(this.toIndentedString(this.cpUSystemNano)).append("\n");
        sb.append("    containerID: ").append(this.toIndentedString(this.containerID)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    memLimit: ").append(this.toIndentedString(this.memLimit)).append("\n");
        sb.append("    memPerc: ").append(this.toIndentedString(this.memPerc)).append("\n");
        sb.append("    memUsage: ").append(this.toIndentedString(this.memUsage)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    piDs: ").append(this.toIndentedString(this.piDs)).append("\n");
        sb.append("    perCPU: ").append(this.toIndentedString(this.perCPU)).append("\n");
        sb.append("    systemNano: ").append(this.toIndentedString(this.systemNano)).append("\n");
        sb.append("    upTime: ").append(this.toIndentedString(this.upTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ContainerStats is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ContainerStats` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ContainerID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PER_C_P_U) != null && !jsonObj.get(SERIALIZED_NAME_PER_C_P_U).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PER_C_P_U).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `PerCPU` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PER_C_P_U).toString()));
        }
    }

    public static ContainerStats fromJson(String jsonString) throws IOException {
        return (ContainerStats)JSON.getGson().fromJson(jsonString, ContainerStats.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AVG_C_P_U);
        openapiFields.add(SERIALIZED_NAME_BLOCK_INPUT);
        openapiFields.add(SERIALIZED_NAME_BLOCK_OUTPUT);
        openapiFields.add(SERIALIZED_NAME_C_P_U);
        openapiFields.add(SERIALIZED_NAME_CP_U_NANO);
        openapiFields.add(SERIALIZED_NAME_CP_U_SYSTEM_NANO);
        openapiFields.add(SERIALIZED_NAME_CONTAINER_I_D);
        openapiFields.add(SERIALIZED_NAME_DURATION);
        openapiFields.add(SERIALIZED_NAME_MEM_LIMIT);
        openapiFields.add(SERIALIZED_NAME_MEM_PERC);
        openapiFields.add(SERIALIZED_NAME_MEM_USAGE);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NETWORK);
        openapiFields.add(SERIALIZED_NAME_PI_DS);
        openapiFields.add(SERIALIZED_NAME_PER_C_P_U);
        openapiFields.add(SERIALIZED_NAME_SYSTEM_NANO);
        openapiFields.add(SERIALIZED_NAME_UP_TIME);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ContainerStats.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ContainerStats.class));
            return new TypeAdapter<ContainerStats>(this){

                public void write(JsonWriter out, ContainerStats value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ContainerStats read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ContainerStats.validateJsonElement(jsonElement);
                    return (ContainerStats)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

