/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.java;

import io.github.pod4dev.java.exceptions.PodmanException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.IntStream;
import lombok.Generated;

public final class Utils {
    public static String readYaml(String yamlPath) throws IOException {
        List<Path> files = Files.isDirectory(Path.of(yamlPath, new String[0]), new LinkOption[0]) ? Files.list(Path.of(yamlPath, new String[0])).toList() : List.of(Path.of(yamlPath, new String[0]));
        StringBuilder resultStringBuilder = new StringBuilder();
        for (Path file : files) {
            if (!file.getFileName().toString().endsWith(".yaml") && !file.getFileName().toString().endsWith(".yml")) continue;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file.toFile())));){
                String line;
                while ((line = br.readLine()) != null) {
                    resultStringBuilder.append(line).append(System.lineSeparator());
                }
                resultStringBuilder.append("---").append(System.lineSeparator());
            }
        }
        return resultStringBuilder.toString();
    }

    public static int findFreePort() throws PodmanException {
        Integer result = null;
        for (int port : IntStream.range(34400, 34500).toArray()) {
            try (ServerSocket serverSocket = new ServerSocket(port);){
                if (serverSocket == null || serverSocket.getLocalPort() != port) continue;
                result = port;
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new PodmanException("There is no free port");
        }
        return result;
    }

    @Generated
    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

