package javaforce.utils;

import javaforce.*;
import javaforce.awt.*;

/**
 *
 * @author User
 */
public class TestLDAP extends javax.swing.JFrame {

  /**
   * Creates new form TestLDAP
   */
  public TestLDAP() {
    initComponents();
    JFAWT.centerWindow(this);
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    jLabel1 = new javax.swing.JLabel();
    username = new javax.swing.JTextField();
    jLabel2 = new javax.swing.JLabel();
    password = new javax.swing.JPasswordField();
    login = new javax.swing.JButton();
    jLabel3 = new javax.swing.JLabel();
    server = new javax.swing.JTextField();
    domain = new javax.swing.JTextField();
    jLabel4 = new javax.swing.JLabel();
    jLabel5 = new javax.swing.JLabel();
    attr = new javax.swing.JTextField();
    query = new javax.swing.JButton();
    keyValue = new javax.swing.JTextField();
    jLabel7 = new javax.swing.JLabel();
    dn = new javax.swing.JTextField();
    keyType = new javax.swing.JComboBox<>();

    setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
    setTitle("LDAP Test");

    jLabel1.setText("Username");

    jLabel2.setText("Password");

    login.setText("Login");
    login.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        loginActionPerformed(evt);
      }
    });

    jLabel3.setText("Server");

    jLabel4.setText("Domain");

    jLabel5.setText("Attribute(s)");

    attr.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        attrActionPerformed(evt);
      }
    });

    query.setText("Query");
    query.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        queryActionPerformed(evt);
      }
    });

    jLabel7.setText("DN");

    keyType.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "SAMAccountName", "mail" }));

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(jLabel1)
          .addComponent(jLabel2)
          .addComponent(jLabel3)
          .addComponent(jLabel4)
          .addComponent(jLabel7)
          .addComponent(jLabel5)
          .addComponent(keyType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGap(22, 22, 22)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
          .addComponent(keyValue, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 225, Short.MAX_VALUE)
          .addComponent(dn, javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(domain, javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(username, javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(password, javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(server, javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(attr))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(login)
          .addComponent(query))
        .addContainerGap(8, Short.MAX_VALUE))
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel4)
          .addComponent(domain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGap(18, 18, 18)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel1)
          .addComponent(username, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGap(18, 18, 18)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel2)
          .addComponent(password, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGap(18, 18, 18)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel3)
          .addComponent(server, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(login))
        .addGap(42, 42, 42)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel7)
          .addComponent(dn, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGap(18, 18, 18)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(keyValue, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(keyType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGap(18, 18, 18)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel5)
          .addComponent(attr, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(query))
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void loginActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loginActionPerformed
    testLogin();
  }//GEN-LAST:event_loginActionPerformed

  private void attrActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_attrActionPerformed
    // TODO add your handling code here:
  }//GEN-LAST:event_attrActionPerformed

  private void queryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_queryActionPerformed
    query();
  }//GEN-LAST:event_queryActionPerformed

  /**
   * @param args the command line arguments
   */
  public static void main(String args[]) {
    /* Create and display the form */
    java.awt.EventQueue.invokeLater(new Runnable() {
      public void run() {
        new TestLDAP().setVisible(true);
      }
    });
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JTextField attr;
  private javax.swing.JTextField dn;
  private javax.swing.JTextField domain;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JLabel jLabel3;
  private javax.swing.JLabel jLabel4;
  private javax.swing.JLabel jLabel5;
  private javax.swing.JLabel jLabel7;
  private javax.swing.JComboBox<String> keyType;
  private javax.swing.JTextField keyValue;
  private javax.swing.JButton login;
  private javax.swing.JPasswordField password;
  private javax.swing.JButton query;
  private javax.swing.JTextField server;
  private javax.swing.JTextField username;
  // End of variables declaration//GEN-END:variables


  public void testLogin() {
    String user = username.getText();
    String pass = new String(password.getPassword());
    String svr = server.getText();
    String dom = domain.getText();
    try {
      LDAP ldap = new LDAP();
      if (!ldap.login(svr, dom, user, pass)) {
        throw ldap.lastException;
      }
      JFAWT.showMessage("LDAP", "Login Accepted");
    } catch (Exception e) {
      e.printStackTrace();
      JFAWT.showMessage("LDAP", "Login Denied");
    }
  }

  public void query() {
    String user = username.getText();
    String pass = new String(password.getPassword());
    String svr = server.getText();
    String dom = domain.getText();
    String dif_dn = dn.getText();
    String key_type = keyType.getSelectedItem().toString();
    String key_value = keyValue.getText();
    String atr = attr.getText();
    try {
      LDAP ldap = new LDAP();
      if (!ldap.login(svr, dom, user, pass)) {
        throw ldap.lastException;
      }
      String[] atrs = atr.split("[,]");
      String[] res = ldap.getAttributes(dif_dn, key_type + "=" + key_value, atrs);
      if (res == null) {
        JFAWT.showMessage("LDAP", "null result");
        return;
      }
      StringBuilder values = new StringBuilder();
      for(int a=0;a<res.length;a++) {
        values.append(res[a]);
        values.append("\r\n");
      }
      JFAWT.showMessage("Results", values.toString());
    } catch (Exception e) {
      e.printStackTrace();
      JFAWT.showMessage("LDAP", "Login Denied");
    }
  }
}
