/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.util.ArrayList;

public class JSON {
    public static Element parse(String str) throws Exception {
        Element root = new Element();
        root.key = "root";
        JSON.parseElement(root, str.trim());
        return root;
    }

    private static String readKey(Element e, String str) throws Exception {
        boolean quote = false;
        int pos = 0;
        e.key = "";
        block6: while (true) {
            char ch;
            if ((ch = str.charAt(pos++)) == '\"') {
                if (quote) {
                    quote = false;
                    continue;
                }
                if (e.key.length() > 0) {
                    throw new Exception("bad key name");
                }
                quote = true;
                continue;
            }
            if (quote) {
                e.key = e.key + ch;
                continue;
            }
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    if (e.key.length() <= 0) continue block6;
                    return str.substring(pos);
                }
                case '}': {
                    return str.substring(pos - 1);
                }
                case ':': {
                    if (e.key.length() == 0) {
                        throw new Exception("no key name");
                    }
                    return str.substring(pos);
                }
                case '[': 
                case ']': 
                case '{': {
                    throw new Exception("bad key name:" + ch);
                }
            }
            e.key = e.key + ch;
        }
    }

    private static String readArray(Element e, String key, String str) throws Exception {
        do {
            Element child = new Element();
            child.key = key;
            str = JSON.readValue(child, str, true);
            if (child.value.length() <= 0 && child.children.size() <= 0) continue;
            e.children.add(child);
        } while (!str.startsWith("]"));
        return str.substring(1);
    }

    private static String readValue(Element e, String str, boolean array) throws Exception {
        boolean quote = false;
        boolean escape = false;
        int pos = 0;
        e.value = "";
        block22: while (true) {
            char ch;
            if ((ch = str.charAt(pos++)) == '\"' && !escape) {
                if (quote) {
                    return str.substring(pos);
                }
                if (e.value.length() > 0) {
                    throw new Exception("bad value");
                }
                quote = true;
                continue;
            }
            if (ch == '\\' && !escape) {
                escape = true;
            }
            if (quote) {
                if (escape) {
                    switch (ch) {
                        case 'n': {
                            e.value = e.value + "\n";
                            break;
                        }
                        case 'r': {
                            e.value = e.value + "\r";
                            break;
                        }
                        case 't': {
                            e.value = e.value + "\t";
                            break;
                        }
                        case 'b': {
                            e.value = e.value + "\b";
                            break;
                        }
                        case 'f': {
                            e.value = e.value + "\f";
                            break;
                        }
                        default: {
                            e.value = e.value + ch;
                        }
                    }
                    escape = false;
                    continue;
                }
                e.value = e.value + ch;
                continue;
            }
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    if (e.value.length() <= 0) continue block22;
                    return str.substring(pos);
                }
                case ':': {
                    if (e.value.length() <= 0) continue block22;
                    throw new Exception("bad value");
                }
                case '{': {
                    if (e.value.length() > 0) {
                        throw new Exception("bad value");
                    }
                    return JSON.parseElement(e, str.substring(pos - 1));
                }
                case '}': {
                    if (e.value.length() > 0) {
                        return str.substring(pos);
                    }
                    throw new Exception("bad value");
                }
                case '[': {
                    if (e.value.length() > 0) {
                        throw new Exception("bad value");
                    }
                    return str.substring(pos - 1);
                }
                case ']': {
                    if (!array) {
                        throw new Exception("bad array");
                    }
                    return str.substring(pos - 1);
                }
            }
            if (escape) {
                switch (ch) {
                    case 'n': {
                        e.value = e.value + "\n";
                        break;
                    }
                    case 'r': {
                        e.value = e.value + "\r";
                        break;
                    }
                    case 't': {
                        e.value = e.value + "\t";
                        break;
                    }
                    case 'b': {
                        e.value = e.value + "\b";
                        break;
                    }
                    case 'f': {
                        e.value = e.value + "\f";
                        break;
                    }
                    default: {
                        e.value = e.value + ch;
                    }
                }
                escape = false;
                continue;
            }
            e.value = e.value + ch;
        }
    }

    private static String readOpen(String str) throws Exception {
        int pos = 0;
        block4: while (true) {
            char ch = str.charAt(pos++);
            switch (ch) {
                case '{': {
                    return str.substring(pos);
                }
                case '\t': 
                case ' ': {
                    continue block4;
                }
            }
            break;
        }
        throw new Exception("bad json string");
    }

    private static String parseElement(Element e, String str) throws Exception {
        str = JSON.readOpen(str);
        while (str.length() > 0) {
            Element child = new Element();
            if ((str = JSON.readKey(child, str)).startsWith("}")) {
                return str.substring(1);
            }
            if ((str = JSON.readValue(child, str, false)).startsWith("[")) {
                str = JSON.readArray(e, child.key, str.substring(1));
                continue;
            }
            e.children.add(child);
        }
        return str;
    }

    public static String escape(String in) {
        char[] ca;
        if (in == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (char ch : ca = in.toCharArray()) {
            if (ch < ' ') {
                sb.append(String.format("\\u%04x", ch));
                continue;
            }
            if (ch == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (ch == '\\') {
                sb.append("\\\\");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static class Element {
        public String key;
        public String value;
        public ArrayList<Element> children = new ArrayList();

        public Element getChild(String name) {
            for (Element child : this.children) {
                if (!child.key.equals(name)) continue;
                return child;
            }
            return null;
        }
    }
}

