/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ansi.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ansi.client.ANSI;
import javaforce.ansi.client.BufferViewer;
import javaforce.ansi.client.Char;
import javaforce.ansi.client.Script;
import javaforce.ansi.client.Settings;
import javaforce.ansi.client.Telnet;
import javaforce.ansi.client.UTF8;
import javaforce.awt.GetPassword;
import javaforce.awt.JFAWT;
import javaforce.jni.lnx.LnxCom;
import javaforce.jni.lnx.LnxPty;
import javaforce.jni.win.WinCom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;

public class Buffer {
    public Settings settings;
    public BufferViewer viewer;
    public int sx;
    public int sy;
    private int y1;
    private int y2;
    public Script script = null;
    private static int fx;
    private static int fy;
    private static int descent;
    private volatile boolean ready = false;
    private Object lock;
    private final int RenderPriority = 9;
    private Reader reader;
    private final int ReaderPriority = 9;
    private InputStream in;
    private OutputStream out;
    private Socket s;
    private SshClient client;
    private ClientSession session;
    private ClientChannel channel;
    private SSLSocket ssl;
    public int scrollBack;
    private Telnet telnet;
    public ANSI ansi;
    private UTF8 utf8;
    private char[] code = new char[64];
    private int codelen = 0;
    private final char IAC = (char)255;
    private final char ESC = (char)27;
    public Char[] chars = null;
    public int cx;
    public int cy;
    private Timer timer;
    private Color foreColor;
    private Color backColor;
    private boolean cursorShown = false;
    private int selectStart = -1;
    private int selectEnd = -1;
    private FileOutputStream fos;
    private boolean blinker = false;
    private boolean reverse = false;
    private boolean blinkerShown = false;
    private boolean connected = false;
    private boolean connecting = false;
    private boolean failed = false;
    private Frame parent;
    private boolean eol = false;
    private boolean closed = false;
    private boolean init = false;
    private LnxPty pty;
    private boolean autowrap = true;
    private long profile_last = 0L;
    private WinCom wincom;
    private LnxCom lnxcom;

    public Buffer(BufferViewer viewer, Settings settings) {
        this.viewer = viewer;
        this.settings = settings;
    }

    public void init() {
        JFLog.log("Buffer.init start");
        try {
            this.lock = new Object();
            this.scrollBack = this.settings.scrollBack;
            this.foreColor = this.settings.foreColor;
            this.backColor = this.settings.backColor;
            this.gotoPos(1, 1);
            this.ansi = new ANSI(this, this.settings.protocol.equals("telnet"));
            this.telnet = new Telnet();
            this.utf8 = new UTF8();
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Buffer.this.timer();
                }
            }, 500L, 500L);
            this.sx = this.settings.sx;
            this.sy = this.settings.sy;
            this.y1 = 0;
            this.y2 = this.sy - 1;
            this.chars = new Char[this.sx * (this.sy + this.scrollBack)];
            for (int a = 0; a < this.sx * (this.sy + this.scrollBack); ++a) {
                this.chars[a] = new Char(this.settings.foreColor, this.settings.backColor);
            }
            this.init = true;
            this.ready = true;
            this.reader = new Reader();
            this.reader.setPriority(9);
            this.reader.start();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        JFLog.log("Buffer.init done");
    }

    private void profile(boolean show, String msg) {
        long current = System.nanoTime();
        if (show) {
            System.out.println(msg + "Diff=" + (current - this.profile_last));
        }
        this.profile_last = current;
    }

    public byte[] char2byte(char[] buf, int buflen) {
        byte[] tmp = new byte[buflen];
        for (int a = 0; a < buflen; ++a) {
            tmp[a] = (byte)buf[a];
        }
        return tmp;
    }

    public char[] byte2char(byte[] buf, int buflen) {
        char[] tmp = new char[buflen];
        int a = 0;
        while (a < buflen) {
            tmp[a] = (char)buf[a];
            int n = a++;
            tmp[n] = (char)(tmp[n] & 0xFF);
        }
        return tmp;
    }

    public void output(char[] buf) {
        block3: {
            if (this.settings.localEcho) {
                this.input(buf, buf.length);
            }
            byte[] tmp = this.char2byte(buf, buf.length);
            try {
                this.out.write(tmp);
                this.out.flush();
            }
            catch (Exception e) {
                JFLog.log(e);
                if (this.closed) break block3;
                this.close();
            }
        }
    }

    public void output(char ch) {
        block3: {
            if (this.settings.localEcho) {
                this.input(ch);
            }
            try {
                this.out.write(new byte[]{(byte)ch});
                this.out.flush();
            }
            catch (Exception e) {
                JFLog.log(e);
                if (this.closed) break block3;
                this.close();
            }
        }
    }

    private void input(String str) {
        this.input(str.toCharArray(), str.length());
    }

    private void input(char[] buf, int buflen) {
        if (this.fos != null) {
            byte[] tmp = this.char2byte(buf, buflen);
            JF.write(this.fos, tmp, 0, tmp.length);
        }
        char[] newbuf = new char[buflen];
        int newbuflen = 0;
        for (int a = 0; a < buflen; ++a) {
            if (this.codelen == 0) {
                if (buf[a] == '\u00ff' || buf[a] == '\u001b' || this.settings.utf8 && this.utf8.isUTF8(buf[a])) {
                    if (newbuflen > 0) {
                        this.print(newbuf, newbuflen);
                        newbuflen = 0;
                    }
                    this.codelen = 1;
                    this.code[0] = buf[a];
                    continue;
                }
                newbuf[newbuflen++] = this.ansi.encodeChar(buf[a]);
                continue;
            }
            this.code[this.codelen++] = buf[a];
            if (this.codelen == 2 && this.code[0] == '\u001b' && this.code[1] == '\u001b') {
                this.codelen = 1;
            }
            if (this.code[0] == '\u00ff') {
                if (!this.telnet.decode(this.code, this.codelen, this)) continue;
                this.codelen = 0;
                continue;
            }
            if (this.code[0] == '\u001b') {
                if (!this.ansi.decode(this.code, this.codelen, this)) continue;
                this.codelen = 0;
                continue;
            }
            if (!this.utf8.decode(this.code, this.codelen, this)) continue;
            this.codelen = 0;
            newbuf[newbuflen++] = this.utf8.char16;
        }
        if (newbuflen > 0) {
            this.print(newbuf, newbuflen);
        }
    }

    private void input(char ch) {
        char[] tmp = new char[]{ch};
        this.input(tmp, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changeSize(Dimension extent) {
        int y;
        if (!this.init) {
            return;
        }
        if (!this.settings.autoSize) {
            return;
        }
        if (extent.width < fx) {
            extent.width = fx;
        }
        if (extent.height < fy) {
            extent.height = fy;
        }
        int newsx = extent.width / fx;
        int newsy = extent.height / fy;
        this.y1 = 0;
        this.y2 = newsy - 1;
        Char[] newChars = new Char[newsx * (newsy + this.scrollBack)];
        int newsy2 = newsy + this.scrollBack;
        int sy2 = this.sy + this.scrollBack;
        if (newsy2 > sy2) {
            int x;
            for (y = 0; y < sy2; ++y) {
                if (newsx > this.sx) {
                    for (x = 0; x < this.sx; ++x) {
                        newChars[y * newsx + x] = this.chars[y * this.sx + x];
                    }
                    for (x = this.sx; x < newsx; ++x) {
                        newChars[y * newsx + x] = new Char(this.settings.foreColor, this.settings.backColor);
                    }
                    continue;
                }
                for (x = 0; x < newsx; ++x) {
                    newChars[y * newsx + x] = this.chars[y * this.sx + x];
                }
            }
            for (y = sy2; y < newsy2; ++y) {
                for (x = 0; x < newsx; ++x) {
                    newChars[y * newsx + x] = new Char(this.settings.foreColor, this.settings.backColor);
                }
            }
        } else {
            for (y = 0; y < newsy2; ++y) {
                int x;
                if (newsx > this.sx) {
                    for (x = 0; x < this.sx; ++x) {
                        newChars[y * newsx + x] = this.chars[y * this.sx + x];
                    }
                    for (x = this.sx; x < newsx; ++x) {
                        newChars[y * newsx + x] = new Char(this.settings.foreColor, this.settings.backColor);
                    }
                    continue;
                }
                for (x = 0; x < newsx; ++x) {
                    newChars[y * newsx + x] = this.chars[y * this.sx + x];
                }
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.sx = newsx;
            this.sy = newsy;
            if (this.channel != null) {
                this.setPtyType();
            }
            if (this.settings.protocol.equals("local")) {
                this.pty_setsize();
            }
            if (this.cx >= this.sx) {
                this.cx = this.sx - 1;
            }
            if (this.cy >= this.sy) {
                this.cy = this.sy - 1;
            }
            this.chars = newChars;
            System.gc();
        }
        this.signalRepaint(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeScrollBack(int newSize) {
        int y;
        Char[] newChars = new Char[this.sx * (this.sy + newSize)];
        if (newSize > this.scrollBack) {
            int x;
            int diff = newSize - this.scrollBack;
            for (y = 0; y < diff; ++y) {
                for (x = 0; x < this.sx; ++x) {
                    newChars[y * this.sx + x] = new Char(this.settings.foreColor, this.settings.backColor);
                }
            }
            int pos = 0;
            for (y = diff; y < this.sy + newSize; ++y) {
                for (x = 0; x < this.sx; ++x) {
                    newChars[y * this.sx + x] = this.chars[pos * this.sx + x];
                }
                if (++pos != this.sy + this.scrollBack) continue;
                pos = 0;
            }
        } else {
            int diff = this.scrollBack - newSize;
            int pos = diff;
            if (pos >= this.sy + this.scrollBack) {
                pos -= this.sy + this.scrollBack;
            }
            for (y = 0; y < this.sy + newSize; ++y) {
                for (int x = 0; x < this.sx; ++x) {
                    newChars[y * this.sx + x] = this.chars[pos * this.sx + x];
                }
                if (++pos != this.sy + this.scrollBack) continue;
                pos = 0;
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.scrollBack = newSize;
            this.chars = newChars;
        }
        this.signalRepaint(true, true);
    }

    public void setForeColor(int newClr) {
        this.foreColor = new Color(newClr);
    }

    public void setBackColor(int newClr) {
        this.backColor = new Color(newClr);
    }

    public void setForeColor(Color newClr) {
        this.foreColor = newClr;
    }

    public void setBackColor(Color newClr) {
        this.backColor = newClr;
    }

    public void setBlinker(boolean state) {
        this.blinker = state;
    }

    public void setReverse(boolean state) {
        this.reverse = state;
    }

    public Color getForeColor() {
        return this.foreColor;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void clrscr() {
        for (int pos = 0; pos < this.sx * (this.sy + this.scrollBack); ++pos) {
            this.chars[pos].ch = '\u0000';
            this.chars[pos].fc = this.foreColor;
            this.chars[pos].bc = this.backColor;
            this.chars[pos].blink = false;
        }
        this.cx = 0;
        this.cy = 0;
        this.signalRepaint(true, false);
        if (this.settings.protocol.equals("local")) {
            this.pty_setsize();
        }
    }

    public void print(String txt) {
        this.print(txt.toCharArray(), txt.length());
    }

    public void print(char[] buf, int buflen) {
        block6: for (int a = 0; a < buflen; ++a) {
            switch (buf[a]) {
                case '\b': 
                case '\u007f': {
                    this.decPosX();
                    continue block6;
                }
                case '\t': {
                    int ts = (this.getx() - 1) % this.settings.tabStops;
                    for (int t = 0; t < this.settings.tabStops - ts; ++t) {
                        if (this.eol) {
                            this.incPosX();
                        }
                        this.incPosX();
                    }
                    continue block6;
                }
                case '\n': {
                    this.incPosY();
                    continue block6;
                }
                case '\r': {
                    this.gotoPos(1, this.gety());
                    continue block6;
                }
                default: {
                    if (buf[a] < ' ' && buf[a] >= '\u0000') continue block6;
                    if (this.eol) {
                        this.incPosX();
                    }
                    this.setChar(this.cx + 1, this.cy + 1, buf[a]);
                    this.incPosX();
                }
            }
        }
        this.signalRepaint(true, false);
    }

    public void print(char ch) {
        char[] x = new char[]{ch};
        this.print(x, 1);
    }

    public void setChar(int cx, int cy, char ch) {
        int pos = (--cy + this.scrollBack) * this.sx + --cx;
        this.chars[pos].ch = ch;
        if (this.reverse) {
            this.chars[pos].fc = this.backColor;
            this.chars[pos].bc = this.foreColor;
        } else {
            this.chars[pos].fc = this.foreColor;
            this.chars[pos].bc = this.backColor;
        }
        this.chars[pos].blink = this.blinker;
    }

    private void decPosX() {
        if (this.cx > 0) {
            this.eol = false;
            --this.cx;
        } else {
            this.cx = this.sx - 1;
            this.decPosY();
            this.eol = true;
        }
    }

    private void decPosY() {
        if (this.cy > 0) {
            --this.cy;
        }
    }

    private void incPosX() {
        if (this.eol) {
            if (!this.autowrap) {
                return;
            }
            this.cx = 0;
            this.incPosY();
            this.eol = false;
        } else if (this.cx < this.sx - 1) {
            ++this.cx;
        } else {
            this.eol = true;
        }
    }

    private void incPosY() {
        if (this.cy < this.y2) {
            ++this.cy;
        } else {
            this.scrollUp(1);
        }
    }

    public void setAutoWrap(boolean state) {
        this.autowrap = state;
    }

    public int getx() {
        return this.cx + 1;
    }

    public int gety() {
        return this.cy + 1;
    }

    public void gotoPos(int x, int y) {
        this.cx = x - 1;
        if (this.cx < 0) {
            this.cx = 0;
        }
        if (this.cx >= this.sx) {
            this.cx = this.sx - 1;
        }
        this.cy = y - 1;
        if (this.cy < 0) {
            this.cy = 0;
        }
        if (this.cy >= this.sy) {
            this.cy = this.sy - 1;
        }
        this.eol = false;
    }

    public int gety1() {
        return this.y1 + 1;
    }

    public int gety2() {
        return this.y2 + 1;
    }

    public void sety1(int v) {
        this.y1 = v - 1;
    }

    public void sety2(int v) {
        this.y2 = v - 1;
    }

    public void scrollUp(int cnt) {
        while (cnt > 0) {
            int p;
            if (this.y1 == 0) {
                for (p = 0; p < this.sx * (this.y2 + 1 + this.scrollBack - 1); ++p) {
                    this.chars[p] = this.chars[p + this.sx];
                }
            } else {
                for (p = this.sx * (this.y1 + this.scrollBack); p < this.sx * (this.y2 + 1 + this.scrollBack - 1); ++p) {
                    this.chars[p] = this.chars[p + this.sx];
                }
            }
            for (p = 0; p < this.sx; ++p) {
                this.chars[p + this.sx * (this.y2 + 1 + this.scrollBack - 1)] = new Char(this.foreColor, this.backColor, this.blinker);
            }
            this.selectEnd = -1;
            this.selectStart = -1;
            --cnt;
        }
    }

    public void scrollDown(int cnt) {
        while (cnt > 0) {
            int p;
            for (p = this.sx * (this.y2 + 1 + this.scrollBack) - 1; p >= this.sx * (this.y1 + this.scrollBack + 1); --p) {
                this.chars[p] = this.chars[p - this.sx];
            }
            for (p = 0; p < this.sx; ++p) {
                this.chars[p + this.sx * (this.y1 + this.scrollBack)] = new Char(this.foreColor, this.backColor, this.blinker);
            }
            this.selectEnd = -1;
            this.selectStart = -1;
            --cnt;
        }
    }

    public void delete() {
        for (int p = this.cx; p < this.sx - 1; ++p) {
            this.chars[(this.cy + this.scrollBack) * this.sx + p] = this.chars[(this.cy + this.scrollBack) * this.sx + p + 1];
        }
        this.chars[(this.cy + this.scrollBack) * this.sx + this.sx - 1] = new Char(this.foreColor, this.backColor, this.blinker);
    }

    public void insert() {
        for (int p = this.sx - 2; p >= this.cx; --p) {
            this.chars[(this.cy + this.scrollBack) * this.sx + p + 1] = this.chars[(this.cy + this.scrollBack) * this.sx + p];
        }
        this.chars[(this.cy + this.scrollBack) * this.sx + this.cx] = new Char(this.foreColor, this.backColor, this.blinker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Reader reader = this.reader;
        synchronized (reader) {
            this.closed = true;
            this.connected = false;
            this.connecting = false;
        }
        this.signalRepaint(false, false);
        this.signalReconnect();
        try {
            if (this.pty != null) {
                this.pty.close();
                this.pty = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.wincom != null) {
                this.wincom.close();
                this.wincom = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.lnxcom != null) {
                this.lnxcom.close();
                this.lnxcom = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void nextTab() {
        System.out.println("nextTab");
    }

    public void prevTab() {
        System.out.println("prevTab");
    }

    public void setTab(int idx) {
        System.out.println("setTab" + idx);
    }

    public void setName(String str) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalReconnect() {
        Reader reader = this.reader;
        synchronized (reader) {
            this.reader.notify();
        }
    }

    public void signalRepaint(boolean findScreen, boolean revalidate) {
        this.viewer.signalRepaint(findScreen, revalidate);
    }

    public void copy() {
        if (this.selectStart == -1 || this.selectEnd == -1) {
            return;
        }
        try {
            StringBuilder str = new StringBuilder();
            if (this.selectStart > this.selectEnd) {
                int tmp = this.selectStart;
                this.selectStart = this.selectEnd;
                this.selectEnd = tmp;
            }
            boolean eol = false;
            for (int a = this.selectStart; a <= this.selectEnd; ++a) {
                if (this.chars[a].ch != '\u0000') {
                    str.append(this.chars[a].ch);
                    if (eol) {
                        eol = false;
                    }
                    if (a % this.sx != this.sx - 1) continue;
                    str.append("\n");
                    continue;
                }
                if (eol) continue;
                eol = true;
                str.append("\n");
            }
            StringSelection ss = new StringSelection(str.toString());
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (cb == null) {
                return;
            }
            cb.setContents(ss, ss);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paste() {
        if (!this.connected) {
            return;
        }
        try {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            String str = (String)cb.getContents(null).getTransferData(DataFlavor.stringFlavor);
            if (str == null) {
                return;
            }
            this.output(str.replaceAll("\r", "\n").toCharArray());
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        this.signalRepaint(true, false);
    }

    private boolean doConnect() {
        if (this.settings.protocol.equals("com")) {
            return this.connectCom();
        }
        if (this.settings.protocol.equals("local")) {
            return this.connectLocal();
        }
        if (this.settings.protocol.equals("telnet")) {
            return this.connectTelnet();
        }
        if (this.settings.protocol.equals("ssh")) {
            return this.connectSSH(this.parent);
        }
        if (this.settings.protocol.equals("ssl")) {
            return this.connectSSL();
        }
        return false;
    }

    private void sendTT() {
        this.input(new char[]{'\u00ff', '\u00fa', '\u0018', '\u00ff', '\u00f0'}, 5);
    }

    private void pty_setsize() {
        if (this.pty == null) {
            return;
        }
        this.pty.setSize(this.sx, this.sy);
    }

    private boolean connectCom() {
        try {
            if (!this.settings.hasComm) {
                throw new Exception("no com support");
            }
            String[] f = this.settings.host.split(",");
            if (JF.isWindows()) {
                this.wincom = WinCom.open(f[0], JF.atoi(f[1]));
                if (this.wincom == null) {
                    return false;
                }
                this.in = new InputStream(){

                    @Override
                    public int read() throws IOException {
                        byte[] data = new byte[1];
                        int read = 0;
                        while ((read = Buffer.this.wincom.read(data)) != 1) {
                        }
                        return data[0];
                    }

                    @Override
                    public int read(byte[] buf) throws IOException {
                        int read;
                        while ((read = Buffer.this.wincom.read(buf)) <= 0) {
                        }
                        return read;
                    }
                };
                this.out = new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        Buffer.this.wincom.write(new byte[]{(byte)b});
                    }

                    @Override
                    public void write(byte[] buf) throws IOException {
                        Buffer.this.wincom.write(buf);
                    }
                };
            } else {
                this.lnxcom = LnxCom.open(f[0], JF.atoi(f[1]));
                if (this.lnxcom == null) {
                    return false;
                }
                this.in = new InputStream(){

                    @Override
                    public int read() throws IOException {
                        int read;
                        byte[] data = new byte[1];
                        while ((read = Buffer.this.lnxcom.read(data)) <= 0) {
                        }
                        return data[0];
                    }

                    @Override
                    public int read(byte[] buf) throws IOException {
                        int read;
                        while ((read = Buffer.this.lnxcom.read(buf)) <= 0) {
                        }
                        return read;
                    }
                };
                this.out = new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        Buffer.this.lnxcom.write(new byte[]{(byte)b});
                    }

                    @Override
                    public void write(byte[] buf) throws IOException {
                        Buffer.this.lnxcom.write(buf);
                    }
                };
            }
            return true;
        }
        catch (Throwable t) {
            if (!this.closed) {
                this.input(t.toString());
            }
            return false;
        }
    }

    private boolean connectLocal() {
        try {
            this.pty = LnxPty.exec(this.settings.termApp, new String[]{this.settings.termApp, "-i", "-l", null}, LnxPty.makeEnvironment(new String[]{"TERM=" + this.settings.termType}));
            if (this.pty == null) {
                throw new Exception("pty failed");
            }
            this.in = new InputStream(){

                @Override
                public int read() {
                    return -1;
                }

                @Override
                public int read(byte[] buf) {
                    return Buffer.this.pty.read(buf);
                }
            };
            this.out = new OutputStream(){

                @Override
                public void write(int x) {
                }

                @Override
                public void write(byte[] buf) {
                    Buffer.this.pty.write(buf);
                }
            };
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            if (!this.closed) {
                this.input(e.toString());
            }
            return false;
        }
    }

    private boolean connectTelnet() {
        try {
            this.s = new Socket(this.settings.host, this.settings.port);
            this.in = this.s.getInputStream();
            this.out = this.s.getOutputStream();
            return true;
        }
        catch (Exception e) {
            if (!this.closed) {
                this.input(e.toString());
            }
            return false;
        }
    }

    private int detectX11port() {
        int port = 6000;
        return port;
    }

    private void setPtyType() {
        JFLog.log("TODO : set Pty Type");
    }

    private boolean connectSSH(Frame parent) {
        try {
            if (this.settings.sshKey.length() == 0) {
                if (this.settings.password.length() == 0) {
                    this.settings.password = GetPassword.getPassword(parent);
                }
                if (this.settings.password == null) {
                    return false;
                }
            }
            this.client = SshClient.setUpDefaultClient();
            this.client.start();
            JFLog.log("TODO : set knownhosts");
            ConnectFuture cf = this.client.connect(this.settings.username, this.settings.host, this.settings.port);
            this.session = (ClientSession)((ConnectFuture)cf.verify(new CancelOption[0])).getSession();
            if (this.settings.x11) {
                JFLog.log("TODO : set X11 host / port");
            }
            if (this.settings.sshKey.length() == 0) {
                this.session.addPasswordIdentity(this.settings.password);
            } else {
                JFLog.log("using key:" + this.settings.sshKey);
                JFLog.log("TODO : set ssh key");
            }
            this.session.auth().verify(30000L, new CancelOption[0]);
            this.channel = this.session.createChannel("shell");
            if (this.settings.x11) {
                JFLog.log("TODO : enable x11 forwarding");
            } else {
                JFLog.log("TODO : enable agent forwarding");
            }
            Object[] pipes = this.createPipes();
            if (pipes == null) {
                return false;
            }
            this.out = (OutputStream)pipes[1];
            this.channel.setIn((InputStream)pipes[0]);
            pipes = this.createPipes();
            if (pipes == null) {
                return false;
            }
            this.in = (InputStream)pipes[0];
            this.channel.setOut((OutputStream)pipes[1]);
            this.channel.open();
            return true;
        }
        catch (Exception e) {
            if (!this.closed) {
                this.input(e.toString());
            }
            return false;
        }
    }

    private Object[] createPipes() {
        Object[] ret = new Object[2];
        try {
            ret[0] = new PipedInputStream();
            ret[1] = new PipedOutputStream((PipedInputStream)ret[0]);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean connectSSL() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslsocketfactory = sc.getSocketFactory();
            this.ssl = (SSLSocket)sslsocketfactory.createSocket(this.settings.host, this.settings.port);
            this.s = this.ssl;
            this.in = this.s.getInputStream();
            this.out = this.s.getOutputStream();
            return true;
        }
        catch (Exception e) {
            if (!this.closed) {
                this.input(e.toString());
            }
            return false;
        }
    }

    public String toString() {
        return "Buffer";
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int keyMods = e.getModifiersEx() & JFAWT.KEY_MASKS;
        if (keyMods == 128) {
            switch (keyCode) {
                case 65: {
                    this.selectStart = 0;
                    this.selectEnd = this.sx * (this.sy + this.scrollBack) - 1;
                    break;
                }
                case 87: {
                    this.close();
                    break;
                }
                case 67: 
                case 155: {
                    this.copy();
                    break;
                }
                case 86: {
                    this.paste();
                    break;
                }
                case 9: {
                    this.nextTab();
                    break;
                }
                case 35: 
                case 36: {
                    e.consume();
                }
            }
        }
        if (keyMods == 64) {
            switch (keyCode) {
                case 155: {
                    this.paste();
                }
            }
        }
        if (keyMods == 0) {
            switch (keyCode) {
                case 9: {
                    this.prevTab();
                }
            }
        }
        if (keyMods == 512) {
            switch (keyCode) {
                case 36: {
                    this.clrscr();
                    break;
                }
                case 49: {
                    this.setTab(0);
                    break;
                }
                case 50: {
                    this.setTab(1);
                    break;
                }
                case 51: {
                    this.setTab(2);
                    break;
                }
                case 52: {
                    this.setTab(3);
                    break;
                }
                case 53: {
                    this.setTab(4);
                    break;
                }
                case 54: {
                    this.setTab(5);
                    break;
                }
                case 55: {
                    this.setTab(6);
                    break;
                }
                case 56: {
                    this.setTab(7);
                    break;
                }
                case 57: {
                    this.setTab(8);
                    break;
                }
                case 48: {
                    this.setTab(9);
                }
            }
        }
        if (keyMods == 0) {
            switch (keyCode) {
                case 33: 
                case 34: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 121: {
                    e.consume();
                }
            }
        }
        if (!this.connected) {
            return;
        }
        this.ansi.keyPressed(keyCode, keyMods, this);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (!this.connected) {
            if (this.failed) {
                this.failed = false;
                this.signalReconnect();
            }
            return;
        }
        char key = e.getKeyChar();
        int mods = e.getModifiersEx() & JFAWT.KEY_MASKS;
        if (mods == 128) {
            if (key == '\n' || key == '\r') {
                this.output('\r');
                this.output('\n');
            }
            return;
        }
        if (mods == 512) {
            return;
        }
        if (mods == 640) {
            return;
        }
        if (key == '\n') {
            key = '\r';
        }
        if (key == '\u007f') {
            return;
        }
        this.output(key);
    }

    public void timer() {
        if (this.cursorShown) {
            this.blinkerShown = !this.blinkerShown;
            this.cursorShown = false;
        } else {
            this.cursorShown = true;
        }
        if (this.script != null && this.script.process(this)) {
            this.script = null;
        }
        this.signalRepaint(false, false);
    }

    private class Reader
    extends Thread {
        private Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Buffer.this.closed) {
                try {
                    Buffer.this.connecting = true;
                    Buffer.this.input("Connecting...");
                    Buffer.this.signalRepaint(true, false);
                    if (!Buffer.this.doConnect()) {
                        Buffer.this.input("\r\nConnection failed! Press any key to retry...");
                        Buffer.this.signalRepaint(true, false);
                        Buffer.this.failed = true;
                        Reader reader = Buffer.this.reader;
                        synchronized (reader) {
                            if (Buffer.this.closed) {
                                break;
                            }
                            try {
                                Buffer.this.reader.wait();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        Buffer.this.input("\r\n");
                        continue;
                    }
                    Buffer.this.connected = true;
                    Buffer.this.connecting = false;
                    Buffer.this.input("\u001b[2J");
                    byte[] buf = new byte[1024];
                    while (Buffer.this.connected) {
                        int buflen = Buffer.this.in.read(buf);
                        if (buflen == -1) {
                            throw new Exception("read error");
                        }
                        if (buflen <= 0) continue;
                        Buffer.this.input(Buffer.this.byte2char(buf, buflen), buflen);
                    }
                }
                catch (Exception e) {
                    JFLog.log(e);
                    if (Buffer.this.closed) continue;
                    Buffer.this.close();
                }
            }
            JFLog.log("Reader thread done");
        }
    }
}

