/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ansi.server;

import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javaforce.JF;
import javaforce.ansi.server.ANSI;
import javaforce.ansi.server.Dialog;
import javaforce.ansi.server.Field;
import javaforce.ansi.server.List;
import javaforce.ansi.server.TextField;

public class FileDialog
implements Dialog {
    private ANSI ansi;
    private boolean closed = false;
    private boolean cancel = false;
    private boolean load;
    private String filename;
    private static String path;
    private String[] files;
    private Field[] fields;
    private TextField file;
    private int pathx;
    private int pathy;
    private List list;
    private int field;

    public FileDialog(ANSI ansi, boolean load, String path, String filename) {
        this.ansi = ansi;
        this.load = load;
        if (path == null) {
            if (FileDialog.path == null) {
                FileDialog.path = JF.getCurrentPath();
            }
        } else {
            FileDialog.path = path;
        }
        FileDialog.path = FileDialog.path.replaceAll("\\\\", "/");
        if (filename == null) {
            filename = "";
        }
        this.filename = filename;
        this.listFiles();
    }

    @Override
    public void draw() {
        int width = 42;
        int height = this.ansi.height - 3;
        int x = (this.ansi.width - width) / 2;
        int y = 3;
        String title = this.load ? "Open" : "Save";
        String[] lns = new String[height - 2];
        lns[0] = "Filename: [" + ANSI.pad(this.filename, 28) + "]";
        lns[1] = "";
        lns[2] = ANSI.pad("{list}", 40);
        lns[height - 3] = "<Ok> <Cancel>";
        this.pathx = x + 1;
        this.pathy = y + 2;
        this.fields = this.ansi.drawWindow(x, y, width, height, lns);
        ANSI.gotoPos(x + (width - title.length()) / 2, y);
        System.out.print(title);
        title = "Files/Folders";
        ANSI.gotoPos(x + (width - title.length()) / 2, y + 3);
        System.out.print(title);
        this.drawPath();
        this.file = (TextField)this.fields[0];
        this.list = (List)this.fields[1];
        this.list.width = 40;
        this.list.height = height - 5;
        this.list.items = this.files;
        this.list.draw();
        this.fields[0].gotoCurrentPos();
    }

    public void drawPath() {
        ANSI.gotoPos(this.pathx, this.pathy);
        FileDialog fileDialog = this;
        fileDialog.ansi.setDialogColor();
        System.out.print(ANSI.pad(path, 40));
    }

    public void drawFiles() {
        this.list.draw();
    }

    @Override
    public void keyPressed(int keyCode, int keyMods) {
        block0 : switch (keyMods) {
            case 0: {
                switch (keyCode) {
                    case 27: {
                        this.closed = true;
                        this.cancel = true;
                        break block0;
                    }
                }
                this.fields[this.field].keyPressed(keyCode, keyMods);
            }
        }
    }

    @Override
    public void keyTyped(char key) {
        switch (key) {
            case '\t': {
                ++this.field;
                if (this.field == this.fields.length) {
                    this.field = 0;
                }
                this.fields[this.field].gotoCurrentPos();
                break;
            }
            case '\n': {
                if (this.field == 1) {
                    String item = this.list.getItem();
                    if (item.startsWith("[") && item.endsWith("]")) {
                        String folder = item.substring(1, item.length() - 1);
                        if (folder.equals("..")) {
                            int lastIdx = path.lastIndexOf(47);
                            path = lastIdx == -1 ? "/" : path.substring(0, lastIdx);
                        } else {
                            if (!path.endsWith("/")) {
                                path = path + "/";
                            }
                            if (JF.isWindows() && path.equals("/")) {
                                path = "";
                            }
                            path = path + folder;
                        }
                        this.listFiles();
                        this.list.items = this.files;
                        this.list.cy = 0;
                        this.list.wy = 0;
                        this.drawPath();
                        this.drawFiles();
                        break;
                    }
                    this.file.setText(item);
                    this.closed = true;
                    this.cancel = false;
                    break;
                }
                this.closed = true;
                this.cancel = this.field == 3;
                break;
            }
            default: {
                this.fields[this.field].keyTyped(key);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    private void listFiles() {
        if (JF.isWindows() && path.equals("/")) {
            ArrayList<CallSite> drives = new ArrayList<CallSite>();
            for (char drv = 'A'; drv <= 'Z'; drv = (char)(drv + '\u0001')) {
                if (!new File(drv + ":/").exists()) continue;
                drives.add((CallSite)((Object)("[" + drv + ":]")));
            }
            this.files = drives.toArray(new String[0]);
        } else {
            int start;
            File[] tmp = new File(path).listFiles();
            if (tmp == null) {
                tmp = new File[]{};
            }
            if (path.equals("/")) {
                this.files = new String[tmp.length];
                start = 0;
            } else {
                this.files = new String[tmp.length + 1];
                this.files[0] = "[..]";
                start = 1;
            }
            for (int a = 0; a < tmp.length; ++a) {
                this.files[a + start] = tmp[a].isDirectory() ? "[" + tmp[a].getName() + "]" : tmp[a].getName();
            }
            Arrays.sort(this.files, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    boolean f2;
                    boolean f1 = o1.startsWith("[");
                    if (f1 != (f2 = o2.startsWith("["))) {
                        return f2 ? 1 : -1;
                    }
                    return o1.compareTo(o2);
                }
            });
        }
    }

    public String getPath() {
        return path;
    }

    public String getFilename() {
        if (this.cancel) {
            return null;
        }
        return this.file.getText();
    }

    public boolean isLoading() {
        return this.load;
    }
}

