/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ansi.server;

import javaforce.ansi.server.ANSI;
import javaforce.ansi.server.Field;

public class TextField
extends Field {
    public StringBuilder text = new StringBuilder();

    @Override
    public void keyPressed(int keyCode, int keyMods) {
        if (keyMods != 0) {
            return;
        }
        switch (keyCode) {
            case 38: {
                break;
            }
            case 40: {
                break;
            }
            case 37: {
                if (this.cx > 0) {
                    --this.cx;
                }
                this.gotoCurrentPos();
                break;
            }
            case 39: {
                if (this.cx < this.text.length()) {
                    ++this.cx;
                }
                this.gotoCurrentPos();
                break;
            }
            case 127: {
                if (this.cx >= this.text.length()) {
                    return;
                }
                this.text.deleteCharAt(this.cx);
                this.draw();
            }
        }
    }

    @Override
    public void keyTyped(char key) {
        switch (key) {
            case '\b': 
            case '\u007f': {
                if (this.text.length() == 0) {
                    return;
                }
                if (this.cx == 0) {
                    return;
                }
                --this.cx;
                this.text.deleteCharAt(this.cx);
                break;
            }
            default: {
                if (key < ' ') {
                    return;
                }
                this.text.append(key);
                ++this.cx;
            }
        }
        this.draw();
    }

    @Override
    public void draw() {
        this.gotoHomePos();
        ANSI.setFieldColor();
        int x1 = this.cx - this.width;
        if (x1 < 0) {
            x1 = 0;
        }
        System.out.print(ANSI.pad(this.text.substring(x1), this.width));
        this.gotoCurrentPos();
    }

    public void setText(String in) {
        this.text.setLength(0);
        this.text.append(in);
        this.cx = 0;
        this.dx = 0;
    }

    public String getText() {
        return this.text.toString();
    }
}

