/*
 * Decompiled with CFR 0.152.
 */
package javaforce.jni;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.jni.Library;
import javaforce.jni.LnxNative;
import javaforce.jni.MacNative;
import javaforce.jni.WinNative;

public class JFNative {
    private static Class<Object> PinnedObject;
    private static Method PinnedObject_create;
    private static Method PinnedObject_addressOfArrayElement;
    private static Class<Object> WordBase;
    private static Method WordBase_rawValue;
    public static boolean loaded;
    public static boolean inited;
    public static boolean load_ffmpeg;

    public static void load() {
        if (loaded) {
            return;
        }
        try {
            JFNative.test();
            loaded = true;
        }
        catch (Throwable t) {
            JFNative.loadNative();
        }
        if (!loaded) {
            return;
        }
        if (!inited) {
            try {
                PinnedObject = Class.forName("org.graalvm.nativeimage.PinnedObject");
                PinnedObject_create = PinnedObject.getMethod("create", Object.class);
                PinnedObject_addressOfArrayElement = PinnedObject.getMethod("addressOfArrayElement", Integer.TYPE);
                WordBase = Class.forName("org.graalvm.word.WordBase");
                WordBase_rawValue = WordBase.getMethod("rawValue", new Class[0]);
                inited = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (JF.isWindows()) {
            WinNative.load();
        }
        if (JF.isUnix() && !JF.isMac()) {
            LnxNative.load();
        }
        if (JF.isMac()) {
            MacNative.load();
        }
    }

    private static void loadNative() {
        try {
            String path = System.getProperty("java.app.home");
            if (path == null) {
                path = ".";
            }
            String ext = "";
            String bits = "";
            bits = JF.is64Bit() ? "64" : "32";
            if (JF.isWindows()) {
                ext = ".dll";
            } else if (JF.isMac()) {
                ext = ".dylib";
            } else {
                ext = ".so";
                path = "/usr/lib";
            }
            Library lib = new Library("jfnative" + bits);
            if (!JFNative.findLibraries(new File[]{new File(path)}, new Library[]{lib}, ext, 1)) {
                JFLog.log("Warning:Unable to find jfnative library");
                JFLog.log("Library Path=" + path);
            }
            if (lib.path != null) {
                System.load(lib.path);
                loaded = true;
            }
        }
        catch (Throwable t) {
            JFLog.log("Error:" + t);
        }
    }

    public static native long getPointer(Object var0);

    public static native void freePointer(Object var0, long var1);

    public static Object createPinnedObject(Object array) {
        try {
            return PinnedObject_create.invoke(null, array);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long getPinnedObjectPointer(Object pin) {
        try {
            Object word = PinnedObject_addressOfArrayElement.invoke(pin, 0);
            if (word == null) {
                throw new Exception("word == null");
            }
            return (Long)WordBase_rawValue.invoke(word, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    private static native void test();

    private static native void init();

    public static boolean findLibraries(File[] folders, Library[] libs, String ext, int needed) {
        boolean once = false;
        for (int fn = 0; fn < folders.length; ++fn) {
            File[] files = folders[fn].listFiles();
            if (files == null || files.length == 0) continue;
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    boolean d1 = f1.isDirectory();
                    boolean d2 = f2.isDirectory();
                    if (d1 && d2) {
                        return 0;
                    }
                    if (d1) {
                        return 1;
                    }
                    if (d2) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (int a = 0; a < files.length; ++a) {
                File file = files[a];
                String fileName = files[a].getName();
                if (file.isDirectory() || !fileName.contains(ext)) continue;
                int cnt = 0;
                for (int b = 0; b < libs.length; ++b) {
                    if (!fileName.startsWith(libs[b].name) && !fileName.startsWith("lib" + libs[b].name) || once && libs[b].once) continue;
                    libs[b].path = file.getAbsolutePath();
                    ++cnt;
                    if (!libs[b].once) continue;
                    once = true;
                }
                if (cnt != needed) continue;
                return true;
            }
        }
        return false;
    }

    static {
        load_ffmpeg = true;
    }
}

