/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.JFLog;
import javaforce.media.AudioOutput;
import javaforce.media.Wav;

public class Music {
    public static final int VERSION = 1;
    private Track[] sounds = new Track[0];
    public Song song;
    private boolean playing;
    private Object lock = new Object();
    private Play play;
    public static final byte NOTE_NONE = -1;
    public static final byte VOLCMD_NONE = 0;
    public static final byte VOLCMD_SET_VOLUME = 1;
    public static final byte VOLCMD_SET_PANNING = 2;
    public static final byte VOLCMD_SLIDE = 3;
    public static final byte VOLCMD_PAN_SLIDE = 4;
    public static final byte VOLCMD_SET_VOL_VIBRATE_SPEED = 5;
    public static final byte VOLCMD_SET_PAN_VIBRATE_SPEED = 6;
    public static final byte VOLCMD_TREMOLO = 7;
    public static final byte VOLCMD_PANBRELLO = 8;
    public static final byte VOLCMD_MASTER_FLAG = -128;
    public static final byte FXCMD_NONE = 0;
    public static final byte FXCMD_PORTAMENTO = 1;
    public static final byte FXCMD_PORTAMENTO_TO_NOTE = 2;
    public static final byte FXCMD_SET_VIBRATE_SPEED = 3;
    public static final byte FXCMD_VIBRATO = 4;
    public static final byte FXCMD_TREMOR = 5;
    public static final byte FXCMD_PATTERN_BREAK = 6;
    public static final byte FXCMD_KEY_OFF = 7;
    public static final byte FXCMD_CUT_OFF = 8;
    public static final byte FXCMD_SET_INSTRUMENT = 9;
    public static final byte FXCMD_DELAY_START = 10;
    public static final byte FXCMD_SAMPLE_OFFSET = 11;
    public static final byte FXCMD_SET_BPM = 12;
    private Listener listener;
    private AudioOutput output;
    private int samplesPerBuffer;
    private short[] samples;
    private Timer timer;
    private static ArrayList<Instrument> loadedSounds = new ArrayList();
    private static ArrayList<Sample> loadedSoundsSamples = new ArrayList();
    private int seqIdx = 0;
    private int patternIdx = 0;
    private Pattern pattern;
    private boolean repeatSong;
    private float m_volL = 1.0f;
    private float m_volR = 1.0f;
    private float s_volL = 1.0f;
    private float s_volR = 1.0f;
    private int samplesPerBeat;
    private int samplesThisBeat;
    private int rowIdx;
    public static final float[] octave12 = new float[12];
    private static final int chs = 2;

    public boolean start(int milliSec, int soundChannels) {
        if (this.output != null) {
            this.stop();
        }
        this.output = new AudioOutput();
        this.sounds = new Track[soundChannels];
        for (int a = 0; a < soundChannels; ++a) {
            this.sounds[a] = new Track();
        }
        this.samplesPerBuffer = 44100 * milliSec / 1000;
        this.samples = new short[this.samplesPerBuffer * 2];
        if (!this.output.start(2, 44100, 16, this.samplesPerBuffer * 2 * 2, null)) {
            JFLog.log("Music.start() failed");
            return false;
        }
        this.output.write(this.samples);
        this.output.write(this.samples);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Music.this.process();
            }
        }, milliSec / 2, (long)milliSec);
        return true;
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.output != null) {
            this.output.stop();
            this.output = null;
        }
    }

    public static Song load(String fn) {
        try {
            FileInputStream fis = new FileInputStream(fn);
            Song song = Music.load(fis);
            fis.close();
            return song;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static Song load(InputStream is) {
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            Version version = (Version)ois.readObject();
            Song song = (Song)ois.readObject();
            if (song.samples == null) {
                song.samples = new ArrayList();
            }
            return song;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public boolean load(Song song) {
        this.close();
        this.song = song;
        return true;
    }

    public boolean save(String fn) {
        try {
            FileOutputStream fos = new FileOutputStream(fn);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            this.song.flags = 0;
            oos.writeObject(new Version());
            oos.writeObject(this.song);
            fos.close();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.playing = false;
        }
        this.song = null;
    }

    public void reset() {
        this.close();
        this.song = new Song();
        Pattern pattern = new Pattern();
        pattern.name = "Verse 1";
        pattern.bpm = 80;
        pattern.addTracks(4);
        this.song.patterns.add(pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay() {
        Object object = this.lock;
        synchronized (object) {
            this.playing = false;
        }
        this.seqIdx = 0;
        this.rowIdx = 0;
        if (!this.prepNextPattern()) {
            return;
        }
        this.playing = true;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void playSong(boolean repeat) {
        if (this.playing) {
            JFLog.log("Music:error:playSong:already playing");
            return;
        }
        this.repeatSong = repeat;
        this.play = Play.song;
        this.seqIdx = 0;
        this.rowIdx = 0;
        if (!this.prepNextPattern()) {
            return;
        }
        if (this.listener != null) {
            this.listener.musicRow(this.seqIdx, this.patternIdx, this.rowIdx);
        }
        this.playing = true;
    }

    public void playPattern(int patternIdx) {
        if (this.playing) {
            JFLog.log("Music:error:playPattern:already playing");
            return;
        }
        this.play = Play.pattern;
        this.seqIdx = -1;
        this.patternIdx = patternIdx;
        this.rowIdx = 0;
        this.pattern = this.song.patterns.get(patternIdx);
        this.pattern.reset(this);
        if (this.listener != null) {
            this.listener.musicRow(this.seqIdx, patternIdx, this.rowIdx);
        }
        this.playing = true;
    }

    public void playRow(int patternIdx, int rowIdx) {
        if (this.playing) {
            return;
        }
        this.play = Play.note;
        this.seqIdx = -1;
        this.patternIdx = patternIdx;
        this.rowIdx = rowIdx;
        this.pattern = this.song.patterns.get(patternIdx);
        this.pattern.reset(this);
        this.playing = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMusic() {
        Object object = this.lock;
        synchronized (object) {
            this.playing = false;
        }
    }

    public boolean isRunning() {
        return this.output != null;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public synchronized int instrumentPlay(int idx, float volL, float volR, int note) {
        for (int a = 0; a < this.sounds.length; ++a) {
            if (this.sounds[a].playing) continue;
            Track t = this.sounds[a];
            t.volL = volL;
            t.volR = volR;
            t.vol = 1.0f;
            t.i = this.song.instruments.get(idx);
            t.r = t.i.getRegion(note);
            t.s = this.song.samples.get(t.r.sample);
            t.freq = (float)(note - t.r.unity) / 12.0f;
            t.freqPow2 = (float)Math.pow(2.0, t.freq);
            t.interpolate = t.freq % 1.0f != 0.0f;
            t.sIdx = 0.0f;
            t.sustain = t.s.sustainStart != -1;
            t.loop = t.s.loopStart != -1 && t.s.sustainStart == -1;
            t.playing = true;
            return a;
        }
        return -1;
    }

    public synchronized int samplePlay(int idx, float L, float R) {
        for (int a = 0; a < this.sounds.length; ++a) {
            if (this.sounds[a].playing) continue;
            Track t = this.sounds[a];
            t.volL = L;
            t.volR = R;
            t.vol = 1.0f;
            t.i = null;
            t.r = null;
            t.s = this.song.samples.get(idx);
            t.freq = 0.0f;
            t.freqPow2 = (float)Math.pow(2.0, t.freq);
            t.interpolate = t.freq % 1.0f != 0.0f;
            t.sIdx = 0.0f;
            t.sustain = t.s.sustainStart != -1;
            t.loop = t.s.loopStart != -1 && t.s.sustainStart == -1;
            t.playing = true;
            return a;
        }
        return -1;
    }

    public synchronized int soundLoad(short[] samples, int loopStart, int loopEnd, int sustainStart, int sustainEnd, float attenuation, int unityNote) {
        Instrument i = new Instrument();
        i.name = "";
        Region r = new Region();
        i.regions.add(r);
        r.low = 0;
        r.high = 127;
        r.unity = unityNote;
        r.sample = loadedSoundsSamples.size();
        Sample s = new Sample();
        s.samples = samples;
        s.loopStart = loopStart;
        s.loopEnd = loopEnd;
        s.sustainStart = sustainStart;
        s.sustainEnd = sustainEnd;
        s.attenuation = attenuation;
        loadedSounds.add(i);
        loadedSoundsSamples.add(s);
        return loadedSounds.size() - 1;
    }

    public synchronized int soundLoad(String fn, int loopStart, int loopEnd, int sustainStart, int sustainEnd, float attenuation) {
        for (int a = 0; a < loadedSounds.size(); ++a) {
            if (!Music.loadedSounds.get((int)a).name.equals(fn)) continue;
            return a;
        }
        Wav wav = new Wav();
        wav.load(fn);
        wav.readAllSamples();
        return this.soundLoad(wav.samples16, loopStart, loopEnd, sustainStart, sustainEnd, attenuation, 60);
    }

    public void soundRemove(int idx) {
        loadedSounds.remove(idx);
        loadedSoundsSamples.remove(idx);
    }

    public void soundClear() {
        loadedSounds.clear();
        loadedSoundsSamples.clear();
    }

    public void soundAttenuation(int idx, float value) {
        Music.loadedSoundsSamples.get((int)idx).attenuation = value;
    }

    public synchronized int soundPlay(int idx, float volL, float volR, int note) {
        for (int a = 0; a < this.sounds.length; ++a) {
            if (this.sounds[a].playing) continue;
            Track t = this.sounds[a];
            t.volL = volL;
            t.volR = volR;
            t.vol = 1.0f;
            t.i = loadedSounds.get(idx);
            t.r = t.i.getRegion(note);
            t.s = loadedSoundsSamples.get(t.r.sample);
            t.freq = (float)(note - t.r.unity) / 12.0f;
            t.freqPow2 = (float)Math.pow(2.0, t.freq);
            t.interpolate = t.freq % 1.0f != 0.0f;
            t.sIdx = 0.0f;
            t.sustain = t.s.sustainStart != -1;
            t.loop = t.s.loopStart != -1 && t.s.sustainStart == -1;
            t.attenuation = t.s.attenuation;
            t.playing = true;
            return a;
        }
        return -1;
    }

    public void channelStop(int idx) {
        this.sounds[idx].playing = false;
    }

    public void channelKeyUp(int idx) {
        this.sounds[idx].sustain = false;
    }

    public void channelAttenuation(int idx, float value) {
        this.sounds[idx].attenuation = value;
    }

    public void channelPan(int idx, float L, float R) {
        this.sounds[idx].volL = L;
        this.sounds[idx].volR = R;
    }

    public void channelFreq(int idx, float freq) {
        this.sounds[idx].freq = freq;
        this.sounds[idx].freqPow2 = (float)Math.pow(2.0, freq);
        this.sounds[idx].interpolate = freq % 1.0f != 0.0f;
    }

    public void channelApplyFX(int idx, byte fxcmd, int fxparam) {
        this.sounds[idx].setCmds((byte)0, 0, fxcmd, fxparam, this);
    }

    public void addTrack(int pattern) {
        this.song.patterns.get((int)pattern).tracks.add(new Track());
    }

    public void removeTrack(int pattern, int track) {
        this.song.patterns.get((int)pattern).tracks.remove(track);
    }

    public void addPattern(int nTracks) {
        Pattern newPattern = new Pattern();
        newPattern.addTracks(nTracks);
        this.song.patterns.add(newPattern);
    }

    public void removePattern(int pattern) {
        this.song.patterns.remove(pattern);
        int a = 0;
        while (a < this.song.sequence.size()) {
            Integer seq = this.song.sequence.get(a);
            if (seq == pattern) {
                this.song.sequence.remove(a);
                continue;
            }
            ++a;
        }
    }

    public boolean addSamples(String name, short[] samples, int loopStart, int loopEnd, int sustainStart, int sustainEnd, float attenuation) {
        Sample s = new Sample();
        s.name = name;
        s.loopStart = loopStart;
        s.loopEnd = loopEnd;
        s.sustainStart = sustainStart;
        s.sustainEnd = sustainEnd;
        s.attenuation = attenuation;
        s.samples = samples;
        this.song.samples.add(s);
        return true;
    }

    public boolean addSamples(String name, String fn, int loopStart, int loopEnd, int sustainStart, int sustainEnd, float attenuation) {
        Wav wav = new Wav();
        if (!wav.load(fn)) {
            return false;
        }
        wav.readAllSamples();
        return this.addSamples(name, wav.samples16, loopStart, loopEnd, sustainStart, sustainEnd, attenuation);
    }

    public void removeSamples(int idx) {
        this.song.samples.remove(idx);
        for (int a = 0; a < this.song.instruments.size(); ++a) {
            Instrument i = this.song.instruments.get(a);
            for (int b = 0; b < i.regions.size(); ++b) {
                Region r = i.regions.get(b);
                if (r.sample > idx) {
                    --r.sample;
                    continue;
                }
                if (r.sample != idx) continue;
                r.sample = 0;
            }
        }
    }

    public int addInstrument(String name) {
        Instrument i = new Instrument();
        i.name = name;
        this.song.instruments.add(i);
        return this.song.instruments.size() - 1;
    }

    public void removeInstrument(int idx) {
        this.song.instruments.remove(idx);
        for (int p = 0; p < this.song.patterns.size(); ++p) {
            Pattern pat = this.song.patterns.get(p);
            for (int t = 0; t < pat.tracks.size(); ++t) {
                Track trk = pat.tracks.get(t);
                if (trk.startInstrument == idx) {
                    trk.startInstrument = 0;
                } else if (trk.startInstrument > idx) {
                    trk.startInstrument = (byte)(trk.startInstrument - 1);
                }
                for (int n = 0; n < 64; ++n) {
                    if (trk.fxcmds[n] != 9) continue;
                    if (trk.fxparams[n] == idx) {
                        trk.fxcmds[n] = 0;
                        trk.fxparams[n] = 0;
                        continue;
                    }
                    if (trk.fxparams[n] <= idx) continue;
                    int n2 = n;
                    trk.fxparams[n2] = trk.fxparams[n2] - 1;
                }
            }
        }
    }

    public void addRegion(int iidx, int low, int high, int unityNote, int sample) {
        Region r = new Region();
        r.low = low;
        r.high = high;
        r.unity = unityNote;
        r.sample = sample;
        this.song.instruments.get((int)iidx).regions.add(r);
    }

    public void removeRegion(int iidx, int ridx) {
        this.song.instruments.get((int)iidx).regions.remove(ridx);
    }

    public void setMasterMusicVolume(float l, float r) {
        this.m_volL = l;
        this.m_volR = r;
    }

    public void setMasterSoundVolume(float l, float r) {
        this.s_volL = l;
        this.s_volR = r;
    }

    private boolean prepNextPattern() {
        if (this.seqIdx >= this.song.sequence.size()) {
            this.playing = false;
            if (this.listener != null) {
                this.listener.musicEnded();
            }
            return false;
        }
        this.patternIdx = this.song.sequence.get(this.seqIdx);
        this.pattern = this.song.patterns.get(this.patternIdx);
        this.pattern.reset(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        try {
            Arrays.fill(this.samples, (short)0);
            Object object = this.lock;
            synchronized (object) {
                if (this.playing) {
                    this.processMusic();
                }
                this.processSound();
                if (this.listener != null) {
                    this.listener.musicSamples(this.samples);
                }
            }
            if (this.output != null) {
                this.output.write(this.samples);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private void processMusic() {
        int idx = 0;
        for (int a = 0; a < this.samplesPerBuffer; ++a) {
            int nTracks;
            float L = 0.0f;
            float R = 0.0f;
            ++this.samplesThisBeat;
            if (this.samplesThisBeat == this.samplesPerBeat) {
                this.samplesThisBeat = 0;
                if (this.play == Play.note) {
                    this.playing = false;
                    if (this.listener != null) {
                        this.listener.musicEnded();
                    }
                    return;
                }
                ++this.rowIdx;
                if (this.rowIdx == 64) {
                    this.rowIdx = 0;
                    ++this.seqIdx;
                    if (this.play == Play.pattern) {
                        this.playing = false;
                        if (this.listener != null) {
                            this.listener.musicEnded();
                        }
                        return;
                    }
                    if (this.seqIdx == this.song.sequence.size()) {
                        if (this.listener != null) {
                            this.listener.musicEnded();
                        }
                        if (!this.repeatSong) {
                            this.playing = false;
                            if (this.listener != null) {
                                this.listener.musicEnded();
                            }
                            return;
                        }
                        this.seqIdx = 0;
                    }
                    if (!this.prepNextPattern()) {
                        return;
                    }
                } else {
                    nTracks = this.pattern.tracks.size();
                    for (int t = 0; t < nTracks; ++t) {
                        this.pattern.tracks.get(t).nextNote(this);
                    }
                }
                if (this.listener != null) {
                    this.listener.musicRow(this.seqIdx, this.patternIdx, this.rowIdx);
                }
            }
            nTracks = this.pattern.tracks.size();
            for (int b = 0; b < nTracks; ++b) {
                float sample;
                Track t = this.pattern.tracks.get(b);
                if (!t.playing || t.mute) continue;
                if (t.delay > 0) {
                    --t.delay;
                    continue;
                }
                int cIdx = (int)t.sIdx;
                if (t.interpolate && cIdx + 1 < t.s.samples.length) {
                    float yA = t.s.samples[cIdx];
                    float yB = t.s.samples[cIdx + 1];
                    float mB = t.sIdx % 1.0f;
                    float mA = 1.0f - mB;
                    sample = yA * mA + yB * mB;
                } else {
                    sample = t.s.samples[cIdx];
                }
                t.sIdx += t.freqPow2;
                cIdx = (int)t.sIdx;
                t.vol -= t.attenuation;
                L += sample * t.volL * t.vol;
                R += sample * t.volR * t.vol;
                if (t.vol <= 0.0f) {
                    t.playing = false;
                } else if (t.sustain && cIdx >= t.s.sustainEnd) {
                    t.sIdx -= (float)(t.s.sustainEnd - t.s.sustainStart);
                } else if (t.loop && cIdx >= t.s.loopEnd) {
                    t.sIdx -= (float)(t.s.loopEnd - t.s.loopStart);
                } else if (cIdx >= t.s.samples.length) {
                    t.playing = false;
                }
                if (!t.playing) continue;
                t.doCmds();
            }
            int iL = (int)(L *= this.m_volL);
            int iR = (int)(R *= this.m_volR);
            if (iL < Short.MIN_VALUE) {
                iL = Short.MIN_VALUE;
            }
            if (iL > Short.MAX_VALUE) {
                iL = Short.MAX_VALUE;
            }
            if (iR < Short.MIN_VALUE) {
                iR = Short.MIN_VALUE;
            }
            if (iR > Short.MAX_VALUE) {
                iR = Short.MAX_VALUE;
            }
            this.samples[idx++] = (short)iL;
            this.samples[idx++] = (short)iR;
        }
    }

    private void processSound() {
        int idx = 0;
        for (int b = 0; b < this.samplesPerBuffer; ++b) {
            float samL = 0.0f;
            float samR = 0.0f;
            for (int a = 0; a < this.sounds.length; ++a) {
                float sample;
                Track t = this.sounds[a];
                if (!t.playing || t.mute) continue;
                if (t.delay > 0) {
                    --t.delay;
                    continue;
                }
                int cIdx = (int)t.sIdx;
                if (t.interpolate && cIdx + 1 < t.s.samples.length) {
                    float yA = t.s.samples[cIdx];
                    float yB = t.s.samples[cIdx + 1];
                    float mB = t.sIdx % 1.0f;
                    float mA = 1.0f - mB;
                    sample = yA * mA + yB * mB;
                } else {
                    sample = t.s.samples[cIdx];
                }
                t.sIdx += t.freqPow2;
                cIdx = (int)t.sIdx;
                t.vol -= t.attenuation;
                samL += sample * t.volL * t.vol;
                samR += sample * t.volR * t.vol;
                if (t.vol <= 0.0f) {
                    t.playing = false;
                } else if (t.sustain && cIdx >= t.s.sustainEnd) {
                    t.sIdx -= (float)(t.s.sustainEnd - t.s.sustainStart);
                } else if (t.loop && cIdx >= t.s.loopEnd) {
                    t.sIdx -= (float)(t.s.loopEnd - t.s.loopStart);
                } else if (cIdx >= t.s.samples.length) {
                    t.playing = false;
                }
                if (!t.playing) continue;
                t.doCmds();
            }
            int isamL = (int)(samL *= this.s_volL);
            int isamR = (int)(samR *= this.s_volR);
            isamR += this.samples[idx + 1];
            if ((isamL += this.samples[idx]) < Short.MIN_VALUE) {
                isamL = Short.MIN_VALUE;
            }
            if (isamL > Short.MAX_VALUE) {
                isamL = Short.MAX_VALUE;
            }
            if (isamR < Short.MIN_VALUE) {
                isamR = Short.MIN_VALUE;
            }
            if (isamR > Short.MAX_VALUE) {
                isamR = Short.MAX_VALUE;
            }
            this.samples[idx++] = (short)isamL;
            this.samples[idx++] = (short)isamR;
        }
    }

    static {
        float step = 0.083333336f;
        float value = 1.0f;
        for (int a = 0; a < 12; ++a) {
            Music.octave12[a] = value;
            value += step;
        }
    }

    public static class Track
    implements Serializable {
        public static final long serialVersionUID = 1L;
        public byte startInstrument;
        public float startVolL;
        public float startVolR;
        public float startVolVibrateSpeed;
        public float startPanVibrateSpeed;
        public float startFreqVibrateSpeed;
        public byte[] notes = new byte[64];
        public byte[] volcmds = new byte[64];
        public int[] volparams = new int[64];
        public byte[] fxcmds = new byte[64];
        public int[] fxparams = new int[64];
        public int flags;
        public transient float sIdx;
        public transient float freq;
        public transient float freqPow2;
        public transient boolean playing;
        public transient Instrument i;
        public transient Region r;
        public transient Sample s;
        public transient int volcmd;
        public transient float volparam;
        public transient int fxcmd;
        public transient float fxparam;
        public transient float volL;
        public transient float volR;
        public transient float vol;
        public transient boolean loop;
        public transient boolean sustain;
        public transient float volVibrateSpeed;
        public transient float panVibrateSpeed;
        public transient float freqVibrateSpeed;
        public transient float port;
        public transient float lastFreq;
        public transient float targetFreq;
        public transient int on;
        public transient int off;
        public transient boolean on_off;
        public transient int on_off_cnt;
        public transient boolean mute;
        public transient int delay;
        public transient float volSlide;
        public transient float panSlide;
        public transient float volVibratePos;
        public transient float volVibrateDir;
        public transient float volVibrateMag;
        public transient float panVibratePos;
        public transient float panVibrateDir;
        public transient float panVibrateMag;
        public transient float freqVibratePos;
        public transient float freqVibrateDir;
        public transient float freqVibrateMag;
        public transient boolean interpolate;
        public transient float attenuation;

        public Track() {
            for (int n = 0; n < 64; ++n) {
                this.notes[n] = -1;
            }
            this.startVolL = 1.0f;
            this.startVolR = 1.0f;
            this.startVolVibrateSpeed = 5.668934E-6f;
            this.startPanVibrateSpeed = 5.668934E-6f;
            this.startFreqVibrateSpeed = 5.668934E-6f;
        }

        public void reset(Music music) {
            this.sIdx = 0.0f;
            this.freq = -0.0f;
            this.playing = false;
            this.i = music.song.instruments.get(this.startInstrument);
            this.volL = this.startVolL;
            this.volR = this.startVolR;
            this.volVibrateSpeed = this.startVolVibrateSpeed;
            this.panVibrateSpeed = this.startPanVibrateSpeed;
            this.freqVibrateSpeed = this.startFreqVibrateSpeed;
            this.nextNote(music);
        }

        public void nextNote(Music music) {
            this.lastFreq = this.freq;
            int idx = music.rowIdx;
            byte note = this.notes[idx];
            if (note != -1) {
                this.sIdx = 0.0f;
                this.interpolate = note % 12 != 0;
                this.playing = true;
                this.vol = 1.0f;
                this.r = this.i.getRegion(note);
                this.s = music.song.samples.get(this.r.sample);
                this.freq = (float)(note - this.r.unity) / 12.0f;
                this.freqPow2 = (float)Math.pow(2.0, this.freq);
                this.sustain = this.s.sustainStart != -1;
                this.loop = !this.sustain && this.s.loopStart != -1;
                this.attenuation = this.s.attenuation;
            }
            this.setCmds(this.volcmds[idx], this.volparams[idx], this.fxcmds[idx], this.fxparams[idx], music);
        }

        public void setCmds(byte volcmd, int volparam, byte fxcmd, int fxparam, Music music) {
            this.volcmd = volcmd;
            this.volparam = volparam;
            this.mute = false;
            this.delay = 0;
            switch (volcmd) {
                case 1: {
                    this.vol = Float.intBitsToFloat(volparam);
                    break;
                }
                case 5: {
                    this.volVibrateSpeed = Float.intBitsToFloat(volparam);
                    break;
                }
                case 6: {
                    this.panVibrateSpeed = Float.intBitsToFloat(volparam);
                    break;
                }
                case 7: {
                    this.volVibrateMag = Float.intBitsToFloat(volparam);
                    this.volVibrateDir = this.volVibrateSpeed;
                    this.volVibratePos = 0.0f;
                    break;
                }
                case 8: {
                    this.panVibrateMag = Float.intBitsToFloat(volparam);
                    this.panVibrateDir = this.panVibrateSpeed;
                    this.panVibratePos = 0.0f;
                    break;
                }
                case 2: {
                    float pan = Float.intBitsToFloat(volparam);
                    if (pan == 0.0f) {
                        this.volR = 1.0f;
                        this.volL = 1.0f;
                        break;
                    }
                    if (pan > 0.0f) {
                        this.volR = 1.0f;
                        this.volL = 1.0f - pan;
                        break;
                    }
                    this.volL = 1.0f;
                    this.volR = 1.0f + pan;
                    break;
                }
                case 3: {
                    this.volSlide = Float.intBitsToFloat(volparam);
                    break;
                }
                case 4: {
                    this.panSlide = Float.intBitsToFloat(volparam);
                }
            }
            this.fxcmd = fxcmd;
            this.fxparam = fxparam;
            switch (fxcmd) {
                case 7: {
                    this.sustain = false;
                    break;
                }
                case 8: {
                    this.playing = false;
                    break;
                }
                case 6: {
                    music.rowIdx = 63;
                    break;
                }
                case 2: {
                    if (fxparam != 0) {
                        this.port = Float.intBitsToFloat(fxparam);
                    }
                    this.targetFreq = this.freq;
                    this.freq = this.lastFreq;
                    break;
                }
                case 3: {
                    this.freqVibrateSpeed = Float.intBitsToFloat(fxparam);
                    break;
                }
                case 4: {
                    this.freqVibrateMag = Float.intBitsToFloat(fxparam);
                    this.freqVibrateDir = this.freqVibrateSpeed;
                    this.freqVibratePos = 0.0f;
                    break;
                }
                case 1: {
                    if (fxparam == 0) break;
                    this.port = Float.intBitsToFloat(fxparam);
                    break;
                }
                case 5: {
                    if (fxparam == 0) break;
                    this.on = fxparam >>> 16;
                    if (this.on == 0) {
                        ++this.on;
                    }
                    this.off = fxparam & 0xFFFF;
                    if (this.off == 0) {
                        ++this.off;
                    }
                    this.on_off = true;
                    this.on_off_cnt = 0;
                    break;
                }
                case 9: {
                    this.i = music.song.instruments.get(fxparam);
                    break;
                }
                case 10: {
                    this.delay = fxparam;
                    break;
                }
                case 11: {
                    this.sIdx = fxparam;
                    break;
                }
                case 12: {
                    music.samplesPerBeat = 2646000 / fxparam;
                    music.samplesThisBeat = 0;
                }
            }
        }

        public void doCmds() {
            switch (this.volcmd) {
                case 7: {
                    this.vol = this.volVibrateDir > 0.0f ? (this.vol += this.volVibrateMag) : (this.vol -= this.volVibrateMag);
                    if (this.vol > 1.0f) {
                        this.vol = 1.0f;
                    }
                    if (this.vol < 0.0f) {
                        this.vol = 0.0f;
                    }
                    this.volVibratePos += this.volVibrateDir;
                    if (!(this.volVibratePos > 1.0f) && !(this.volVibratePos < 0.0f)) break;
                    this.volVibrateDir *= -1.0f;
                    break;
                }
                case 8: {
                    if (this.panVibrateDir > 0.0f) {
                        this.volR += this.panVibrateMag;
                        this.volL -= this.panVibrateMag;
                    } else {
                        this.volR -= this.panVibrateMag;
                        this.volL += this.panVibrateMag;
                    }
                    if (this.volR > 1.0f) {
                        this.volR = 1.0f;
                    }
                    if (this.volR < 0.0f) {
                        this.volR = 0.0f;
                    }
                    if (this.volL > 1.0f) {
                        this.volL = 1.0f;
                    }
                    if (this.volL < 0.0f) {
                        this.volL = 0.0f;
                    }
                    this.panVibratePos += this.panVibrateDir;
                    if (!(this.panVibratePos > 1.0f) && !(this.panVibratePos < 0.0f)) break;
                    this.panVibrateDir *= -1.0f;
                    break;
                }
                case 3: {
                    this.vol += this.volSlide;
                    if (this.vol > 1.0f) {
                        this.vol = 1.0f;
                    }
                    if (!(this.vol < 0.0f)) break;
                    this.vol = 0.0f;
                    break;
                }
                case 4: {
                    this.volR += this.panSlide;
                    if (this.volR > 1.0f) {
                        this.volR = 1.0f;
                    }
                    if (this.volR < 0.0f) {
                        this.volR = 0.0f;
                    }
                    this.volL -= this.panSlide;
                    if (this.volL > 1.0f) {
                        this.volL = 1.0f;
                    }
                    if (!(this.volL < 0.0f)) break;
                    this.volL = 0.0f;
                }
            }
            switch (this.fxcmd) {
                case 2: {
                    if (this.freq == this.targetFreq) break;
                    if (this.freq < this.targetFreq) {
                        this.freq += this.port;
                        if (this.freq > this.targetFreq) {
                            this.freq = this.targetFreq;
                        }
                    } else {
                        this.freq -= this.port;
                        if (this.freq < this.targetFreq) {
                            this.freq = this.targetFreq;
                        }
                    }
                    this.freqPow2 = (float)Math.pow(2.0, this.freq);
                    this.interpolate = true;
                    break;
                }
                case 4: {
                    this.freq = this.freqVibrateDir > 0.0f ? (this.freq += this.freqVibrateMag) : (this.freq -= this.freqVibrateMag);
                    this.freqPow2 = (float)Math.pow(2.0, this.freq);
                    this.interpolate = true;
                    this.freqVibratePos += this.freqVibrateDir;
                    if (!(this.freqVibratePos > 1.0f) && !(this.freqVibratePos < 0.0f)) break;
                    this.freqVibrateDir *= -1.0f;
                    break;
                }
                case 1: {
                    this.freq += this.port;
                    this.freqPow2 = (float)Math.pow(2.0, this.freq);
                    this.interpolate = true;
                    break;
                }
                case 5: {
                    this.mute = this.on_off;
                    ++this.on_off_cnt;
                    if (this.on_off && this.on_off_cnt == this.on) {
                        this.on_off = false;
                        this.on_off_cnt = 0;
                        break;
                    }
                    if (this.on_off || this.on_off_cnt != this.off) break;
                    this.on_off = true;
                    this.on_off_cnt = 0;
                }
            }
        }
    }

    public static class Song
    implements Serializable {
        public static final long serialVersionUID = 1L;
        public String name;
        public String comment;
        public int flags;
        public ArrayList<Pattern> patterns = new ArrayList();
        public ArrayList<Integer> sequence = new ArrayList();
        public ArrayList<Instrument> instruments = new ArrayList();
        public ArrayList<Sample> samples = new ArrayList();
    }

    public static class Version
    implements Serializable {
        public static final long serialVersionUID = 1L;
        public int version = 1;
    }

    public static class Pattern
    implements Serializable {
        public static final long serialVersionUID = 1L;
        public String name;
        public int bpm = 80;
        public int flags;
        public ArrayList<Track> tracks = new ArrayList();

        public void reset(Music music) {
            music.samplesPerBeat = 2646000 / this.bpm;
            music.samplesThisBeat = 0;
            music.rowIdx = 0;
            int nTracks = this.tracks.size();
            for (int a = 0; a < nTracks; ++a) {
                this.tracks.get(a).reset(music);
            }
        }

        public void addTracks(int cnt) {
            for (int a = 0; a < cnt; ++a) {
                this.tracks.add(new Track());
            }
        }
    }

    public static interface Listener {
        public void musicEnded();

        public void musicSamples(short[] var1);

        public void musicRow(int var1, int var2, int var3);
    }

    private static enum Play {
        song,
        pattern,
        note;

    }

    public static class Instrument
    implements Serializable {
        public static final long serialVersionUID = 1L;
        public String name;
        public int flags;
        public ArrayList<Region> regions = new ArrayList();

        public Region getRegion(int note) {
            for (int a = 0; a < this.regions.size(); ++a) {
                Region r = this.regions.get(a);
                if (note < r.low || note > r.high) continue;
                return r;
            }
            return null;
        }
    }

    public static class Region
    implements Serializable {
        public static final long serialVersionUID = 1L;
        public int low;
        public int high;
        public int unity;
        public int fineTune;
        public int flags;
        public int sample;
    }

    public static class Sample
    implements Serializable {
        public static final long serialVersionUID = 1L;
        public String name;
        public int loopStart = -1;
        public int loopEnd = -1;
        public int sustainStart = -1;
        public int sustainEnd = -1;
        public float attenuation;
        public int flags;
        public short[] samples;
    }

    public static class Notes {
        public int A = 0;
        public int As = 1;
        public int B = 2;
        public int C = 3;
        public int Cs = 4;
        public int D = 5;
        public int Ds = 6;
        public int E = 7;
        public int F = 8;
        public int Fs = 9;
        public int G = 10;
        public int Gs = 11;
    }
}

