/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.LE;

public class Wav {
    public String errmsg;
    public int chs = -1;
    public int rate = -1;
    public int bits = -1;
    public int bytes = -1;
    public byte[] samples8;
    public short[] samples16;
    public int[] samples32;
    public int dataLength;
    private InputStream wav = null;

    public boolean load(String fn) {
        try {
            this.wav = new FileInputStream(fn);
            return this.load(this.wav);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean load(InputStream is) {
        this.wav = is;
        this.errmsg = "";
        try {
            byte[] data = new byte[30];
            this.wav.read(data, 0, 20);
            if (!LE.getString(data, 0, 4).equals("RIFF")) {
                throw new Exception("wav is not a valid WAV file (RIFF)");
            }
            if (!LE.getString(data, 8, 4).equals("WAVE")) {
                throw new Exception("wav is not a valid WAV file (WAVE)");
            }
            if (!LE.getString(data, 12, 4).equals("fmt ")) {
                throw new Exception("wav is not a valid WAV file (fmt )");
            }
            int fmtsiz = LE.getuint32(data, 16);
            if (fmtsiz < 16 || fmtsiz > 30) {
                throw new Exception("wav is not a valid WAV file (fmtsiz)");
            }
            this.wav.read(data, 0, fmtsiz);
            if (LE.getuint16(data, 0) != 1) {
                throw new Exception("wav is not PCM");
            }
            this.chs = LE.getuint16(data, 2);
            if (this.chs < 1 || this.chs > 2) {
                throw new Exception("wav is not supported (# chs)");
            }
            this.rate = LE.getuint32(data, 4);
            this.bits = LE.getuint16(data, 14);
            switch (this.bits) {
                case 16: {
                    this.bytes = 2;
                    break;
                }
                case 24: {
                    this.bytes = 3;
                    break;
                }
                case 32: {
                    this.bytes = 4;
                    break;
                }
                default: {
                    throw new Exception("wav is not supported (bits=" + this.bits + ")");
                }
            }
            this.wav.read(data, 0, 8);
            while (true) {
                this.dataLength = LE.getuint32(data, 4);
                if (!LE.getString(data, 0, 4).equals("data")) {
                    this.wav.skip(this.dataLength);
                    this.wav.read(data, 0, 8);
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException e2) {
            this.errmsg = "WAV file not found";
            try {
                if (this.wav != null) {
                    this.wav.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        catch (Exception e1) {
            this.errmsg = e1.toString();
            try {
                if (this.wav != null) {
                    this.wav.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public void close() {
        try {
            this.wav.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean readAllSamples() {
        try {
            this.samples8 = JF.readAll(this.wav, this.dataLength);
            this.wav.close();
            switch (this.bits) {
                case 8: {
                    return true;
                }
                case 24: {
                    break;
                }
                case 16: {
                    this.samples16 = new short[this.dataLength / 2];
                    ByteBuffer.wrap(this.samples8).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(this.samples16);
                    break;
                }
                case 32: {
                    this.samples32 = new int[this.dataLength / 4];
                    ByteBuffer.wrap(this.samples8).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().get(this.samples32);
                }
            }
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public byte[] readSamples(int nSamples) {
        int byteLength = nSamples * this.bytes * this.chs;
        byte[] read8 = JF.readAll(this.wav, byteLength);
        if (read8 == null) {
            return null;
        }
        int lenXchs = nSamples * this.chs;
        int pos = 0;
        int pos24 = 0;
        switch (this.bits) {
            case 16: {
                byte[] read32 = new byte[nSamples * 2 * this.chs];
                for (int a = 0; a < lenXchs; ++a) {
                    read32[pos + 0] = read8[pos + 0];
                    read32[pos + 1] = read8[pos + 1];
                    pos += 2;
                }
                return read32;
            }
            case 32: {
                byte[] read32 = new byte[nSamples * 4 * this.chs];
                for (int a = 0; a < lenXchs; ++a) {
                    read32[pos + 0] = read8[pos + 0];
                    read32[pos + 1] = read8[pos + 1];
                    read32[pos + 2] = read8[pos + 2];
                    read32[pos + 3] = read8[pos + 3];
                    pos += 4;
                }
                return read32;
            }
            case 24: {
                byte[] read32 = new byte[nSamples * 4 * this.chs];
                for (int a = 0; a < lenXchs; ++a) {
                    read32[pos + 0] = read8[pos24 + 0];
                    read32[pos + 1] = read8[pos24 + 1];
                    read32[pos + 2] = read8[pos24 + 2];
                    pos += 4;
                    pos24 += 3;
                }
                return read32;
            }
        }
        return null;
    }

    public boolean save(String fn) {
        try {
            FileOutputStream fos = new FileOutputStream(fn);
            boolean ret = this.save(fos);
            fos.close();
            return ret;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean save(OutputStream os) {
        if (this.bits != 16 && this.bits != 32) {
            return false;
        }
        int size = 0;
        switch (this.bits) {
            case 16: {
                this.bytes = 2;
                size = this.samples16.length * 2;
                break;
            }
            case 32: {
                this.bytes = 4;
                size = this.samples32.length * 4;
            }
        }
        try {
            byte[] data = new byte[20];
            LE.setString(data, 0, 4, "RIFF");
            LE.setuint32(data, 4, size + 36);
            LE.setString(data, 8, 4, "WAVE");
            LE.setString(data, 12, 4, "fmt ");
            LE.setuint32(data, 16, 16);
            os.write(data, 0, 20);
            data = new byte[24];
            LE.setuint16(data, 0, 1);
            LE.setuint16(data, 2, this.chs);
            LE.setuint32(data, 4, this.rate);
            LE.setuint32(data, 8, this.bytes * this.chs * this.rate);
            LE.setuint32(data, 12, this.bytes * this.chs);
            LE.setuint16(data, 14, this.bits);
            LE.setString(data, 16, 4, "data");
            LE.setuint32(data, 20, size);
            os.write(data, 0, 24);
            switch (this.bits) {
                case 16: {
                    os.write(LE.shortArray2byteArray(this.samples16, null));
                    break;
                }
                case 32: {
                    os.write(LE.intArray2byteArray(this.samples32, null));
                }
            }
        }
        catch (Exception e) {
            this.errmsg = e.toString();
            return false;
        }
        return false;
    }
}

