/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.util.ArrayList;
import javaforce.JF;
import javaforce.ShellProcess;
import javaforce.ShellProcessListener;

public class ExecGraalAgent
implements ShellProcessListener {
    private void error(String msg) {
        System.out.print(msg);
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            System.out.println("ExecGraalAgent : Runs project using Graal agentlib");
            System.out.println("  Usage : ExecGraalAgent CLASSPATH MAINCLASS");
            System.exit(1);
        }
        new ExecGraalAgent().run(args);
    }

    public void run(String[] args) {
        new File("META-INF/native-image").mkdirs();
        ShellProcess sp = new ShellProcess();
        sp.addListener(this);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("java");
        cmd.add("-agentlib:native-image-agent=config-output-dir=META-INF/native-image");
        cmd.add("-cp");
        if (JF.isWindows()) {
            cmd.add(args[0]);
        } else {
            cmd.add(args[0].replaceAll("[;]", ":"));
        }
        cmd.add(args[1]);
        sp.run(cmd.toArray(new String[0]), true);
    }

    @Override
    public void shellProcessOutput(String str) {
        System.out.print(str);
    }
}

