/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FormatSource {
    public static void main(String[] args) {
        new FormatSource().run(args);
    }

    public void run(String[] args) {
        if (args.length == 0) {
            System.out.println("usage:FormatSource folder");
            System.exit(0);
        }
        this.doFolder(args[0]);
    }

    public boolean isID(byte ch) {
        if (ch >= 97 && ch <= 122) {
            return true;
        }
        if (ch >= 65 && ch <= 90) {
            return true;
        }
        if (ch >= 48 && ch <= 57) {
            return true;
        }
        return ch == 95;
    }

    public boolean isType(byte[] data, int offset, int length) {
        String type;
        char first = (char)data[offset];
        if (first >= 'A' && first <= 'Z') {
            return true;
        }
        switch (type = new String(data, offset, length)) {
            case "byte": {
                return true;
            }
            case "short": {
                return true;
            }
            case "int": {
                return true;
            }
            case "long": {
                return true;
            }
            case "float": {
                return true;
            }
            case "double": {
                return true;
            }
            case "boolean": {
                return true;
            }
            case "char": {
                return true;
            }
        }
        return false;
    }

    public int doSource(byte[] data) {
        int count = 0;
        int offset = 0;
        boolean inMultiComment = false;
        boolean inSingleComment = false;
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        while (offset < data.length) {
            if (inMultiComment) {
                if (data[offset] == 42 && data[offset + 1] == 47) {
                    inMultiComment = false;
                }
                offset += 2;
                continue;
            }
            if (inSingleComment) {
                if (data[offset] == 10) {
                    inSingleComment = false;
                }
                ++offset;
                continue;
            }
            if (inDoubleQuote) {
                if (data[offset] == 92 && data[offset + 1] == 34) {
                    offset += 2;
                    continue;
                }
                if (data[offset] == 34) {
                    inDoubleQuote = false;
                }
                ++offset;
                continue;
            }
            if (inSingleQuote) {
                if (data[offset] == 92 && data[offset + 1] == 39) {
                    offset += 2;
                    continue;
                }
                if (data[offset] == 39) {
                    inDoubleQuote = false;
                }
                ++offset;
                continue;
            }
            if (data[offset] == 47 && data[offset + 1] == 42) {
                inMultiComment = true;
                offset += 2;
                continue;
            }
            if (data[offset] == 47 && data[offset + 1] == 47) {
                inSingleComment = true;
                offset += 2;
                continue;
            }
            if (data[offset] == 34) {
                inDoubleQuote = true;
                ++offset;
                continue;
            }
            if (data[offset] == 39) {
                inSingleQuote = true;
                ++offset;
                continue;
            }
            int length = 0;
            while (data[offset + length] == 91 && data[offset + length + 1] == 93) {
                length += 2;
            }
            if (length > 0) {
                int nameStart = offset - 1;
                int nameLength = 0;
                while (data[nameStart] == 32) {
                    --nameStart;
                }
                while (this.isID(data[nameStart])) {
                    --nameStart;
                    ++nameLength;
                }
                if (nameLength > 0 && !this.isType(data, ++nameStart, nameLength)) {
                    int typeStart = nameStart - 1;
                    int typeLength = 0;
                    while (data[typeStart] == 32) {
                        --typeStart;
                    }
                    while (this.isID(data[typeStart])) {
                        --typeStart;
                        ++typeLength;
                    }
                    ++typeStart;
                    if (typeLength > 0) {
                        int src = typeStart + typeLength;
                        int dst = src + length;
                        System.arraycopy(data, src, data, dst, offset - src);
                        int pairs = length / 2;
                        for (int a = 0; a < pairs; ++a) {
                            data[src++] = 91;
                            data[src++] = 93;
                        }
                        ++count;
                    }
                }
                offset += length;
                continue;
            }
            ++offset;
        }
        return count;
    }

    public void doFile(String file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] data = fis.readAllBytes();
            fis.close();
            int count = this.doSource(data);
            if (count == 0) {
                return;
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(data);
            fos.close();
            System.out.println("Fixed " + count + " arrays in " + file);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void doFolder(String folder) {
        File[] files;
        for (File file : files = new File(folder).listFiles()) {
            if (file.isDirectory()) {
                this.doFolder(file.getAbsolutePath());
                continue;
            }
            String name = file.getAbsolutePath();
            if (!name.endsWith(".java")) continue;
            this.doFile(name);
        }
    }
}

