/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javaforce.JF;
import javaforce.utils.ResourceManager;
import javaforce.utils.WinPE;

public class GenExecutable {
    public static void copy(String src, String dest) throws Exception {
        Files.copy(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void chmod(String file) {
        new File(file).setExecutable(true);
    }

    public static void main(String[] args) {
        if (args.length != 5) {
            System.out.println("Usage:GenExecutable home app apptype ico cfg");
            System.exit(1);
        }
        String home = args[0];
        String app = args[1];
        String type = args[2];
        String ico = args[3];
        String cfg = args[4];
        if (type.equals("w")) {
            type = "";
        }
        try {
            if (JF.isWindows()) {
                GenExecutable.copy(home + "/stubs/win64" + type + ".exe", app + ".exe");
                WinPE.main(new String[]{app + ".exe", ico, cfg});
            } else if (JF.isMac()) {
                GenExecutable.copy(home + "/stubs/mac64.bin", app);
                GenExecutable.chmod(app);
            } else {
                GenExecutable.copy(home + "/stubs/linux64.bin", app + ".bin");
                ResourceManager.main(new String[]{app + ".bin", cfg});
                GenExecutable.chmod("/usr/bin/" + app);
            }
            System.out.println("Native Executable generated!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

