/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Random;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.STUN;
import javaforce.voip.Codec;
import javaforce.voip.RTPChannel;
import javaforce.voip.RTPInterface;
import javaforce.voip.SDP;
import javaforce.voip.SRTPChannel;

public class RTP
implements STUN.Listener {
    private static int nextlocalrtpport = 32768;
    private static int rtpmin = 32768;
    private static int rtpmax = 65536;
    protected DatagramSocket sock1;
    protected DatagramSocket sock2;
    private Worker worker1;
    private Worker worker2;
    private int localrtpport;
    public volatile boolean active = false;
    protected RTPInterface iface;
    private int mtu = 1500;
    protected boolean rawMode;
    public ArrayList<RTPChannel> channels = new ArrayList();
    public static long now = 0L;
    private static boolean hasBouncyCastle;
    public int log;
    protected static boolean useTURN;
    protected static String turnHost;
    protected static String turnIP;
    protected static String turnUser;
    protected static String turnPass;
    protected STUN stun1;
    protected STUN stun2;
    protected byte[] turnToken;
    protected long turnAllocExpires;
    public Object userobj;
    public static boolean debug;
    public static final Codec CODEC_UNKNOWN;
    public static final Codec CODEC_G711u;
    public static final Codec CODEC_GSM;
    public static final Codec CODEC_G711a;
    public static final Codec CODEC_G722;
    public static final Codec CODEC_G729a;
    public static final Codec CODEC_JPEG;
    public static final Codec CODEC_H263;
    public static final Codec CODEC_VP8;
    public static final Codec CODEC_H264;
    public static final Codec CODEC_H263_1998;
    public static final Codec CODEC_H263_2000;
    public static final Codec CODEC_RFC2833;
    private boolean turnSuccess;
    private boolean turnFailed;
    protected volatile RTPChannel bindingChannel;
    protected final Object bindLock = new Object();
    Random r = new Random();

    public void setLog(int id) {
        this.log = id;
    }

    public static void enableTURN(String host, String user, String pass) {
        useTURN = true;
        turnHost = host;
        turnUser = user;
        turnPass = pass;
    }

    public static void disableTURN() {
        useTURN = false;
    }

    public static synchronized int getnextlocalrtpport() {
        int ret = nextlocalrtpport;
        if ((nextlocalrtpport += 2) + 1 > rtpmax) {
            nextlocalrtpport = rtpmin;
        }
        return ret;
    }

    public int getlocalrtpport() {
        if (useTURN) {
            return this.stun1.getPort();
        }
        return this.localrtpport;
    }

    @Override
    public void stunPublicIP(STUN stun, String ip, int port) {
    }

    @Override
    public void turnAlloc(STUN stun, String ip, int port, byte[] token, int lifetime) {
        this.turnToken = token;
        this.turnSuccess = true;
        turnIP = ip;
        this.turnAllocExpires = System.currentTimeMillis() + (long)(lifetime * 1000);
    }

    @Override
    public void turnBind(STUN stun) {
        this.turnSuccess = true;
        this.bindingChannel.turnBindExpires = System.currentTimeMillis() + 300000L;
    }

    @Override
    public void turnRefresh(STUN stun, int lifetime) {
        this.turnAllocExpires = System.currentTimeMillis() + (long)(lifetime * 1000);
    }

    @Override
    public void turnFailed(STUN stun) {
        this.turnFailed = true;
    }

    @Override
    public void turnData(STUN stun, byte[] data, int offset, int length, short turnChannel) {
        RTPChannel channel = this.findChannel(turnChannel);
        if (channel == null) {
            return;
        }
        if (stun == this.stun1) {
            channel.processRTP(data, offset, length);
        } else if (stun == this.stun2) {
            channel.processRTCP(data, offset, length);
        }
    }

    protected void wait4reset() {
        this.turnSuccess = false;
        this.turnFailed = false;
    }

    protected void wait4reply() throws Exception {
        for (int a = 0; a < 100; ++a) {
            JF.sleep(10);
            if (this.turnFailed) {
                throw new Exception("Turn failed");
            }
            if (!this.turnSuccess) continue;
            return;
        }
        throw new Exception("Turn timeout");
    }

    public boolean init(RTPInterface iface, int port) {
        this.iface = iface;
        try {
            this.localrtpport = port;
            if (useTURN) {
                this.wait4reset();
                this.stun1 = new STUN();
                if (!this.stun1.start(this.localrtpport, turnHost, turnUser, turnPass, this)) {
                    throw new Exception("STUN init failed");
                }
                this.stun1.requestAlloc(true, null);
                this.wait4reply();
                if (this.turnToken == null) {
                    throw new Exception("Turn token missing");
                }
                JFLog.log(this.log, "RTP:TURN:host=" + this.stun1.getIP());
                JFLog.log(this.log, "RTP:TURN:port=" + this.stun1.getPort());
                this.wait4reset();
                this.stun2 = new STUN();
                if (!this.stun2.start(this.localrtpport + 1, turnHost, turnUser, turnPass, this)) {
                    throw new Exception("STUN init failed");
                }
                this.stun2.requestAlloc(false, this.turnToken);
                this.wait4reply();
                JFLog.log(this.log, "RTP:TURN:host=" + this.stun2.getIP());
                JFLog.log(this.log, "RTP:TURN:port=" + this.stun2.getPort());
            } else {
                this.sock1 = new DatagramSocket(this.localrtpport);
                this.sock2 = new DatagramSocket(this.localrtpport + 1);
            }
            JFLog.log(this.log, "RTP:localport=" + this.localrtpport);
        }
        catch (Exception e2) {
            JFLog.log(this.log, (Throwable)e2);
            return false;
        }
        return true;
    }

    public boolean init(RTPInterface iface) {
        this.iface = iface;
        for (int a = 0; a < 5; ++a) {
            try {
                this.localrtpport = RTP.getnextlocalrtpport();
                if (useTURN) {
                    this.wait4reset();
                    this.stun1 = new STUN();
                    if (!this.stun1.start(this.localrtpport, turnHost, turnUser, turnPass, this)) {
                        throw new Exception("STUN init failed");
                    }
                    this.stun1.requestAlloc(true, null);
                    this.wait4reply();
                    if (this.turnToken == null) {
                        throw new Exception("Turn token missing");
                    }
                    JFLog.log(this.log, "RTP:TURN:host=" + this.stun1.getIP());
                    JFLog.log(this.log, "RTP:TURN:port=" + this.stun1.getPort());
                    this.wait4reset();
                    this.stun2 = new STUN();
                    if (!this.stun2.start(this.localrtpport + 1, turnHost, turnUser, turnPass, this)) {
                        throw new Exception("STUN init failed");
                    }
                    this.stun2.requestAlloc(false, this.turnToken);
                    this.wait4reply();
                    JFLog.log(this.log, "RTP:TURN:host=" + this.stun2.getIP());
                    JFLog.log(this.log, "RTP:TURN:port=" + this.stun2.getPort());
                } else {
                    this.sock1 = new DatagramSocket(this.localrtpport);
                    this.sock2 = new DatagramSocket(this.localrtpport + 1);
                    this.setReceiveBufferSize(0x1000000);
                }
                JFLog.log(this.log, "RTP:localport=" + this.localrtpport);
            }
            catch (Exception e2) {
                JFLog.log(this.log, (Throwable)e2);
                continue;
            }
            return true;
        }
        return false;
    }

    public void setReceiveBufferSize(int bytes) {
        if (this.sock1 == null) {
            return;
        }
        try {
            this.sock1.setReceiveBufferSize(bytes);
            this.sock2.setReceiveBufferSize(bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMTU(int mtu) {
        if (this.active) {
            return;
        }
        this.mtu = mtu;
    }

    protected short getNextTURNChannel() {
        return (short)(this.r.nextInt(16382) + 16384);
    }

    public boolean start() {
        now = System.currentTimeMillis();
        if (this.active) {
            return true;
        }
        this.active = true;
        if (!useTURN) {
            this.worker1 = new Worker(this, this.sock1, false);
            this.worker1.start();
            this.worker2 = new Worker(this, this.sock2, true);
            this.worker2.start();
        }
        return true;
    }

    public void stop() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.closeSockets();
        this.freeWorkers();
        if (useTURN) {
            if (this.stun1 != null) {
                this.stun1.requestRefresh(0);
                this.stun1.close();
                this.stun1 = null;
            }
            if (this.stun2 != null) {
                this.stun2.requestRefresh(0);
                this.stun2.close();
                this.stun2 = null;
            }
        }
    }

    private void freeWorkers() {
        if (this.worker1 != null) {
            try {
                this.worker1.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.worker1 = null;
        }
        if (this.worker2 != null) {
            try {
                this.worker2.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.worker2 = null;
        }
    }

    public void uninit() {
        this.stop();
        this.closeSockets();
        this.freeWorkers();
    }

    private void closeSockets() {
        if (this.sock1 != null) {
            try {
                this.sock1.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sock1 = null;
        }
        if (this.sock2 != null) {
            try {
                this.sock2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sock2 = null;
        }
    }

    public RTPChannel createChannel(SDP.Stream stream) {
        return this.createChannel(-1, stream);
    }

    public RTPChannel createChannel(int ssrc, SDP.Stream stream) {
        JFLog.log(this.log, "RTP.createChannel()" + stream.getIP() + ":" + stream.port);
        RTPChannel channel = null;
        switch (stream.profile) {
            case AVP: 
            case AVPF: {
                channel = new RTPChannel(this, ssrc, stream);
                break;
            }
            case SAVP: 
            case SAVPF: {
                if (!hasBouncyCastle) {
                    JFLog.log(this.log, "RTP:Couldn't create SRTPChannel");
                    return null;
                }
                channel = new SRTPChannel(this, ssrc, stream);
                break;
            }
            case UNKNOWN: {
                JFLog.log(this.log, "RTP:Can not create unknown profile");
                return null;
            }
        }
        channel.setLog(this.log);
        this.channels.add(channel);
        return channel;
    }

    public void removeChannel(RTPChannel channel) {
        this.channels.remove(channel);
    }

    public RTPChannel getDefaultChannel() {
        if (this.channels.size() == 0) {
            return null;
        }
        return this.channels.get(0);
    }

    public RTPChannel findChannel(short turnChannel) {
        for (int a = 0; a < this.channels.size(); ++a) {
            RTPChannel channel = this.channels.get(a);
            if (!channel.active) continue;
            if (channel.turn1ch == turnChannel) {
                return channel;
            }
            if (channel.turn2ch != turnChannel) continue;
            return channel;
        }
        return null;
    }

    public RTPChannel findChannel(String ip, int port) {
        for (int a = 0; a < this.channels.size(); ++a) {
            RTPChannel channel = this.channels.get(a);
            if (!channel.active || !channel.stream.getIP().equals(ip) || channel.stream.port != -1 && channel.stream.port != port) continue;
            return channel;
        }
        return null;
    }

    public static void setPortRange(int min, int max) {
        rtpmin = min;
        rtpmax = max;
        nextlocalrtpport = min;
    }

    public void keepalive() {
        if (!this.active) {
            return;
        }
        now = System.currentTimeMillis();
        if (useTURN && now + 75000L > this.turnAllocExpires) {
            this.stun1.requestRefresh(600);
            this.stun2.requestRefresh(600);
        }
        for (int a = 0; a < this.channels.size(); ++a) {
            RTPChannel channel = this.channels.get(a);
            channel.keepalive(now);
        }
    }

    public void setRawMode(boolean state) {
        this.rawMode = state;
    }

    public boolean getRawMode() {
        return this.rawMode;
    }

    public static String getTurnIP() {
        return turnIP;
    }

    public static String genIceufrag() {
        StringBuilder sb = new StringBuilder();
        Random r = new Random();
        for (int a = 0; a < 16; ++a) {
            sb.append((char)(97 + r.nextInt(26)));
        }
        return sb.toString();
    }

    public static String genIcepwd() {
        StringBuilder sb = new StringBuilder();
        Random r = new Random();
        for (int a = 0; a < 16; ++a) {
            sb.append((char)(97 + r.nextInt(26)));
        }
        return sb.toString();
    }

    public void setInterface(RTPInterface iface) {
        this.iface = iface;
    }

    public String toString() {
        int remoteport = -1;
        RTPChannel channel = this.getDefaultChannel();
        if (channel != null) {
            remoteport = channel.getremoteport();
        }
        return "RTP:{localport=" + this.localrtpport + ",remoteport=" + remoteport + ",mode=" + this.rawMode + "}";
    }

    static {
        useTURN = false;
        debug = false;
        CODEC_UNKNOWN = new Codec("?", -1);
        CODEC_G711u = new Codec("PCMU", 0);
        CODEC_GSM = new Codec("GSM", 3);
        CODEC_G711a = new Codec("PCMA", 8);
        CODEC_G722 = new Codec("G722", 9);
        CODEC_G729a = new Codec("G729", 18);
        CODEC_JPEG = new Codec("JPEG", 26);
        CODEC_H263 = new Codec("H263", 34);
        CODEC_VP8 = new Codec("VP8", 96);
        CODEC_H264 = new Codec("H264", 97);
        CODEC_H263_1998 = new Codec("H263-1998", 98);
        CODEC_H263_2000 = new Codec("H263-2000", 99);
        CODEC_RFC2833 = new Codec("telephone-event", 100);
        try {
            Class.forName("org.bouncycastle.crypto.tls.TlsServer");
            hasBouncyCastle = true;
        }
        catch (Exception e) {
            JFLog.log("Warning:BouncyCastle not found, SRTP/DTLS not available");
        }
    }

    private class Worker
    extends Thread {
        private RTP rtp;
        private DatagramSocket sock;
        private boolean rtcp;

        public Worker(RTP rtp, DatagramSocket sock, boolean rtcp) {
            this.rtp = rtp;
            this.sock = sock;
            this.rtcp = rtcp;
        }

        @Override
        public void run() {
            byte[] data = new byte[this.rtp.mtu];
            while (this.rtp.active) {
                try {
                    RTPChannel channel;
                    DatagramPacket pack = new DatagramPacket(data, this.rtp.mtu);
                    this.sock.receive(pack);
                    int len = pack.getLength();
                    if (len < 12) continue;
                    String remoteip = pack.getAddress().getHostAddress();
                    int remoteport = pack.getPort();
                    if (this.rtcp) {
                        channel = this.rtp.findChannel(remoteip, remoteport - 1);
                        if (channel == null) {
                            JFLog.log(RTP.this.log, "RTP:No channel found:" + remoteip + ":" + remoteport);
                            continue;
                        }
                        channel.processRTCP(data, 0, len);
                        continue;
                    }
                    channel = this.rtp.findChannel(remoteip, remoteport);
                    if (channel == null) {
                        JFLog.log(RTP.this.log, "RTP:No channel found:" + remoteip + ":" + remoteport);
                        continue;
                    }
                    if (channel.stream.port == -1) {
                        channel.stream.port = remoteport;
                        JFLog.log(RTP.this.log, "RTP : NAT port = " + channel.stream.getPort());
                    }
                    channel.processRTP(data, 0, len);
                }
                catch (SocketException e) {
                    if (this.rtp.active) {
                        JFLog.log(RTP.this.log, (Throwable)e);
                    }
                    this.rtp.active = false;
                }
                catch (Exception e) {
                    JFLog.log(RTP.this.log, (Throwable)e);
                    this.rtp.active = false;
                }
            }
        }
    }
}

