/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.util.ArrayList;
import java.util.Arrays;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.voip.Codec;
import javaforce.voip.SIP;

public class SDP
implements Cloneable {
    public int log;
    public String ip;
    public String iceufrag;
    public String icepwd;
    public String fingerprint;
    public Stream[] streams = new Stream[0];
    public String owner;
    public String session;
    public long time_start;
    public long time_stop;
    public ArrayList<String> otherAttributes = new ArrayList();
    public ArrayList<String> otherParameters = new ArrayList();

    public void setLog(int id) {
        this.log = id;
    }

    public Stream addStream(Type type) {
        JFLog.log(this.log, "SDP.addStream:" + type);
        Stream stream = new Stream();
        stream.sdp = this;
        stream.type = type;
        this.streams = Arrays.copyOf(this.streams, this.streams.length + 1);
        this.streams[this.streams.length - 1] = stream;
        return stream;
    }

    public void delStream(Stream stream) {
        for (int a = 0; a < this.streams.length; ++a) {
            if (this.streams[a] != stream) continue;
            this.streams = JF.copyOfExcluding(this.streams, a);
            return;
        }
    }

    public void delAudio() {
        int a = 0;
        while (a < this.streams.length) {
            if (this.streams[a].type == Type.audio) {
                this.streams = JF.copyOfExcluding(this.streams, a);
                continue;
            }
            ++a;
        }
    }

    public void delVideo() {
        int a = 0;
        while (a < this.streams.length) {
            if (this.streams[a].type == Type.video) {
                this.streams = JF.copyOfExcluding(this.streams, a);
                continue;
            }
            ++a;
        }
    }

    public Stream getFirstAudioStream() {
        for (int a = 0; a < this.streams.length; ++a) {
            if (this.streams[a].type != Type.audio) continue;
            return this.streams[a];
        }
        return null;
    }

    public Stream getFirstVideoStream() {
        for (int a = 0; a < this.streams.length; ++a) {
            if (this.streams[a].type != Type.video) continue;
            return this.streams[a];
        }
        return null;
    }

    public boolean hasAudio() {
        return this.getFirstAudioStream() != null;
    }

    public boolean hasVideo() {
        return this.getFirstVideoStream() != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SDP:" + this.streams.length + "[");
        for (int a = 0; a < this.streams.length; ++a) {
            if (a > 0) {
                sb.append(",");
            }
            sb.append("Stream=" + this.streams[a].type + "," + this.streams[a].mode);
        }
        sb.append("]");
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public class Stream {
        public Type type;
        public Mode mode = Mode.sendrecv;
        public String ip;
        public Codec[] codecs = new Codec[0];
        public int port = -1;
        public String content;
        public SDP sdp;
        public Profile profile = Profile.AVP;
        public KeyExchange keyExchange = KeyExchange.NONE;
        public Key[] keys;

        public String getType() {
            switch (this.type) {
                case audio: {
                    return "audio";
                }
                case video: {
                    return "video";
                }
            }
            return "?";
        }

        public String getMode() {
            switch (this.mode) {
                case sendonly: {
                    return "sendonly";
                }
                case recvonly: {
                    return "recvonly";
                }
                case sendrecv: {
                    return "sendrecv";
                }
                case inactive: {
                    return "inactive";
                }
            }
            return "?";
        }

        public boolean hasCodec(Codec codec) {
            return SIP.hasCodec(this.codecs, codec);
        }

        public Codec addCodec(Codec codec) {
            this.codecs = SIP.addCodec(this.codecs, codec);
            return codec;
        }

        public void delCodec(Codec codec) {
            this.codecs = SIP.delCodec(this.codecs, codec);
        }

        public void setCodec(Codec codec) {
            this.codecs = new Codec[1];
            this.codecs[0] = codec;
        }

        public Codec getCodec(Codec codec) {
            return SIP.getCodec(this.codecs, codec);
        }

        public String getIP() {
            if (this.ip != null) {
                return this.ip;
            }
            return SDP.this.ip;
        }

        public void setIP(String ip) {
            this.ip = ip;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean canSend() {
            return this.mode == Mode.sendrecv || this.mode == Mode.sendonly;
        }

        public boolean canRecv() {
            return this.mode == Mode.sendrecv || this.mode == Mode.recvonly;
        }

        public boolean isSecure() {
            return this.profile == Profile.SAVP || this.profile == Profile.SAVPF;
        }

        public void addKey(String crypto, byte[] key, byte[] salt) {
            Key newkey = new Key();
            newkey.crypto = crypto;
            newkey.key = key;
            newkey.salt = salt;
            if (this.keys == null) {
                this.keys = new Key[0];
            }
            Key[] newKeys = new Key[this.keys.length + 1];
            newKeys[this.keys.length] = newkey;
            this.keys = newKeys;
        }

        public Key getKey(String crypto) {
            if (this.keys == null) {
                return null;
            }
            for (int a = 0; a < this.keys.length; ++a) {
                if (!this.keys[a].crypto.equals(crypto)) continue;
                return this.keys[a];
            }
            return null;
        }
    }

    public static enum Type {
        audio,
        video,
        other;

    }

    public static enum Mode {
        sendonly,
        recvonly,
        sendrecv,
        inactive;

    }

    public class Key {
        public String crypto;
        public byte[] key;
        public byte[] salt;
    }

    public static enum KeyExchange {
        NONE,
        SDP,
        DTLS;

    }

    public static enum Profile {
        AVP,
        SAVP,
        AVPF,
        SAVPF,
        UNKNOWN;

    }
}

