/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javaforce.JFLog;
import javaforce.ShellProcessListener;

public class ShellProcess {
    private Process p;
    private InputStream is;
    private InputStream es;
    private OutputStream os;
    private StringBuffer output;
    private boolean active;
    private ArrayList<Response> script = new ArrayList();
    private ArrayList<Variable> envAdd = new ArrayList();
    private ArrayList<Variable> envRemove = new ArrayList();
    private ShellProcessListener listener = null;
    private File path;
    private int errorLevel;
    private boolean keepOutput = true;
    public static boolean log = false;
    public static boolean logPrompt = false;
    public String command;

    public void addResponse(String prompt, String reply, boolean repeat) {
        Response res = new Response();
        res.prompt = prompt.trim();
        res.reply = reply;
        res.repeat = repeat;
        res.regex = false;
        res.term = false;
        this.script.add(res);
    }

    public void addTerminate(String prompt) {
        Response res = new Response();
        res.prompt = prompt.trim();
        res.reply = "";
        res.repeat = false;
        res.regex = false;
        res.term = true;
        this.script.add(res);
    }

    public void addRegexResponse(String prompt_regex, String reply, boolean repeat) {
        Response res = new Response();
        res.prompt = prompt_regex.trim();
        res.reply = reply;
        res.repeat = repeat;
        res.regex = true;
        res.term = false;
        this.script.add(res);
    }

    public void addRegexTerminate(String prompt_regex) {
        Response res = new Response();
        res.prompt = prompt_regex.trim();
        res.reply = "";
        res.repeat = false;
        res.regex = true;
        res.term = true;
        this.script.add(res);
    }

    public void addListener(ShellProcessListener listener) {
        this.listener = listener;
    }

    public ShellProcessListener getListener() {
        return this.listener;
    }

    public void addEnvironmentVariable(String name, String value) {
        this.envAdd.add(new Variable(name, value));
    }

    public void removeEnvironmentVariable(String name) {
        this.envRemove.add(new Variable(name, null));
    }

    public void setFolder(File path) {
        this.path = path;
    }

    public void keepOutput(boolean state) {
        this.keepOutput = state;
    }

    public String run(List<String> cmd, boolean redirStderr) {
        return this.run(cmd.toArray(new String[0]), redirStderr);
    }

    public String run(String[] cmd, boolean redirStderr) {
        Variable v;
        int a;
        if (cmd[0].equals("sudo")) {
            String[] newcmd = new String[cmd.length + 1];
            newcmd[0] = "sudo";
            newcmd[1] = "-A";
            System.arraycopy(cmd, 1, newcmd, 2, cmd.length - 1);
            cmd = newcmd;
        }
        ProcessBuilder pb = new ProcessBuilder(cmd);
        if (redirStderr) {
            pb.redirectErrorStream(true);
        }
        if (this.path != null) {
            pb.directory(this.path);
        }
        Map<String, String> env = pb.environment();
        if (cmd[0].equals("sudo")) {
            env.put("SUDO_ASKPASS", "/usr/bin/jfsudo-ask");
        }
        for (a = 0; a < this.envAdd.size(); ++a) {
            v = this.envAdd.get(a);
            env.put(v.name, v.value);
        }
        for (a = 0; a < this.envRemove.size(); ++a) {
            v = this.envRemove.get(a);
            env.remove(v.name);
        }
        this.command = "";
        for (a = 0; a < cmd.length; ++a) {
            this.command = this.command + cmd[a] + " ";
        }
        this.output = new StringBuffer();
        this.active = true;
        if (log) {
            Object msg = "Exec :";
            for (int a2 = 0; a2 < cmd.length; ++a2) {
                msg = (String)msg + " ";
                msg = (String)msg + cmd[a2];
            }
            JFLog.log((String)msg);
        }
        try {
            this.p = pb.start();
            this.is = this.p.getInputStream();
            this.os = this.p.getOutputStream();
            this.es = this.p.getErrorStream();
            Worker wi = new Worker(this.is, true);
            wi.start();
            Worker we = null;
            if (!redirStderr) {
                we = new Worker(this.es, false);
                we.start();
            }
            this.p.waitFor();
            this.active = false;
            wi.join();
            if (!redirStderr) {
                we.join();
            }
        }
        catch (Exception e) {
            JFLog.log(e);
            this.errorLevel = -1;
            return null;
        }
        if (log) {
            JFLog.log("Exec:Complete");
        }
        this.errorLevel = this.p.exitValue();
        return this.output.toString();
    }

    public void destroy() {
        if (this.p != null) {
            this.p.destroy();
        }
    }

    public void destroyForcibly() {
        if (this.p != null) {
            this.p.destroyForcibly();
        }
    }

    private void _destroy() {
        this.destroy();
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public boolean isAlive() {
        if (this.p == null) {
            return false;
        }
        return this.p.isAlive();
    }

    public Process getProcess() {
        return this.p;
    }

    private static class Response {
        public String prompt;
        public String reply;
        public boolean repeat;
        public boolean used;
        public boolean regex;
        public boolean term;

        private Response() {
        }
    }

    private static class Variable {
        public String name;
        public String value;

        public Variable(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    private class Worker
    extends Thread {
        private InputStream wis;
        private boolean processScript;

        public Worker(InputStream wis, boolean processScript) {
            this.processScript = processScript;
            this.wis = wis;
        }

        @Override
        public void run() {
            byte[] buf = new byte[1024];
            int pidx = 0;
            try {
                int read;
                block4: while ((ShellProcess.this.active || this.wis.available() > 0) && (read = this.wis.read(buf)) != -1) {
                    if (read == 0) continue;
                    String str = new String(buf, 0, read);
                    if (log) {
                        JFLog.log(str);
                    }
                    if (ShellProcess.this.listener != null) {
                        try {
                            ShellProcess.this.listener.shellProcessOutput(str);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!ShellProcess.this.keepOutput || !this.processScript) continue;
                    ShellProcess.this.output.append(str);
                    String prompt = ShellProcess.this.output.substring(pidx).trim();
                    if (prompt.length() == 0) continue;
                    int in = prompt.lastIndexOf("\n");
                    int ir = prompt.lastIndexOf("\r");
                    if (in != -1 && in > ir) {
                        prompt = prompt.substring(in + 1).trim();
                    }
                    if (ir != -1 && ir > in) {
                        prompt = prompt.substring(ir + 1).trim();
                    }
                    if (logPrompt) {
                        JFLog.log("prompt=" + prompt);
                    }
                    for (int a = 0; a < ShellProcess.this.script.size(); ++a) {
                        Response res = ShellProcess.this.script.get(a);
                        if (res.used) continue;
                        boolean matches = false;
                        matches = res.regex ? prompt.matches(res.prompt) : prompt.equals(res.prompt);
                        if (!matches) continue;
                        pidx = ShellProcess.this.output.length();
                        if (res.term) {
                            ShellProcess.this._destroy();
                            return;
                        }
                        if (log) {
                            JFLog.log(res.reply);
                        }
                        ShellProcess.this.os.write(res.reply.getBytes());
                        ShellProcess.this.os.flush();
                        if (res.repeat) continue block4;
                        res.used = true;
                        continue block4;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (log) {
                JFLog.log("ShellProcess:Worker thread exiting");
            }
        }
    }
}

