/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl;

import javaforce.gl.Vector3;

public class Plane3 {
    private Vector3 aux1 = new Vector3();
    private Vector3 aux2 = new Vector3();
    public Vector3 normal = new Vector3();
    public float d;

    public void set3Points(Vector3 v1, Vector3 v2, Vector3 v3) {
        this.aux1.sub(v1, v2);
        this.aux2.sub(v3, v2);
        this.normal.cross(this.aux2, this.aux1);
        this.normal.normalize();
        this.d = -this.normal.dot(v2);
    }

    public void setNormalAndPoint(Vector3 normal, Vector3 point) {
        this.normal.set(normal);
        this.normal.normalize();
        this.d = -this.normal.dot(point);
    }

    public void setCoefficients(float a, float b, float c, float d) {
        this.normal.set(a, b, c);
        float l = this.normal.length();
        this.normal.set(a / l, b / l, c / l);
        this.d = d / l;
    }

    public float distance(Vector3 p) {
        return this.d + this.normal.dot(p);
    }

    public void print() {
        System.out.println(String.format("GLPlane:%7.3f,%7.3f,%7.3f : %7.3f", Float.valueOf(this.normal.v[0]), Float.valueOf(this.normal.v[1]), Float.valueOf(this.normal.v[2]), Float.valueOf(this.d)));
    }
}

