/*
 * Decompiled with CFR 0.152.
 */
package javaforce.jbus;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.jbus.JBusClient;

public class JBusServer
extends Thread {
    public static int port;
    public static volatile boolean ready;
    private Vector<Client> clients = new Vector();
    private boolean active = true;
    private ServerSocket ss;
    private Object lock = new Object();
    private static JBusServer svr;

    public JBusServer() {
        port = 777;
    }

    public JBusServer(int port) {
        JBusServer.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.clients.size();
        }
    }

    @Override
    public void run() {
        JFLog.append(port, JF.getLogPath() + "/jfbusserver.log", false);
        JFLog.setRetention(port, 30);
        try {
            this.ss = new ServerSocket(port, 1024, InetAddress.getByName("127.0.0.1"));
            JFLog.log(port, "JBusServer starting on port " + port);
            ready = true;
            while (this.active) {
                try {
                    Socket s = this.ss.accept();
                    String ip = s.getInetAddress().toString().substring(1);
                    if (ip.equals("127.0.0.1") || ip.equals("0:0:0:0:0:0:0:1")) {
                        Client client = new Client(s);
                        client.start();
                        continue;
                    }
                    JFLog.log(port, "JBus : Unauthorized client:" + ip);
                }
                catch (Exception e1) {
                    JFLog.log(port, (Throwable)e1);
                }
            }
            this.ss.close();
        }
        catch (Exception e2) {
            JFLog.log(port, (Throwable)e2);
        }
    }

    public void close() {
        if (this.ss == null) {
            return;
        }
        this.active = false;
        try {
            this.ss.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ss = null;
    }

    public boolean ready() {
        return ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(String pack, String func, String args) {
        Object object = this.lock;
        synchronized (object) {
            for (int a = 0; a < this.clients.size(); ++a) {
                Client client = this.clients.get(a);
                if (client.pack == null || !client.pack.startsWith(pack)) continue;
                client.call(client.pack, func, args);
            }
        }
    }

    public static boolean present() {
        JBusClient client = new JBusClient(null, (Object)null);
        client.setDebug(true);
        client.start();
        boolean present = client.ready();
        if (present) {
            client.close();
        }
        return present;
    }

    public static void main(String[] args) {
        JBusServer.serviceStart(args);
    }

    public static void serviceStart(String[] args) {
        svr = new JBusServer();
        svr.start();
    }

    public static void serviceStop() {
        JFLog.log(port, "Stopping service");
        svr.close();
    }

    static {
        ready = false;
    }

    private class Client
    extends Thread {
        private String pack;
        private Socket s;
        private InputStream is;
        private OutputStream os;

        public Client(Socket s) {
            this.s = s;
            try {
                this.is = s.getInputStream();
                this.os = s.getOutputStream();
            }
            catch (Exception e) {
                JFLog.log(port, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String cmd;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
                while (this.s.isConnected() && (cmd = br.readLine()) != null) {
                    this.doCmd(cmd);
                }
            }
            catch (Exception e) {
                JFLog.log(port, (Throwable)e);
            }
            Object object = JBusServer.this.lock;
            synchronized (object) {
                JBusServer.this.clients.remove(this);
            }
            if (this.pack != null) {
                JFLog.log(port, "JBus : package unregistered:" + this.pack);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCmd(String cmd) throws Exception {
            boolean broadcast = false;
            if (((String)cmd).startsWith("cmd.")) {
                if (((String)cmd).startsWith("cmd.package=")) {
                    if (this.pack != null) {
                        return;
                    }
                    this.pack = ((String)cmd).substring(12);
                    JFLog.log(port, "JBus : package registered:" + this.pack);
                    Object object = JBusServer.this.lock;
                    synchronized (object) {
                        JBusServer.this.clients.add(this);
                    }
                    return;
                }
                if (((String)cmd).startsWith("cmd.broadcast=")) {
                    broadcast = true;
                    cmd = ((String)cmd).substring(14);
                } else {
                    JFLog.log(port, "JBus : unknown cmd:" + (String)cmd);
                    return;
                }
            }
            int b1 = ((String)cmd).indexOf(40);
            int b2 = ((String)cmd).length() - 1;
            String call_pack_func = ((String)cmd).substring(0, b1);
            int idx = call_pack_func.lastIndexOf(46);
            if (idx == -1) {
                return;
            }
            String call_pack = call_pack_func.substring(0, idx);
            String call_func = call_pack_func.substring(idx + 1);
            String call_args = ((String)cmd).substring(b1);
            cmd = (String)cmd + "\n";
            boolean sent = false;
            Object object = JBusServer.this.lock;
            synchronized (object) {
                for (int a = 0; a < JBusServer.this.clients.size(); ++a) {
                    Client client = JBusServer.this.clients.get(a);
                    if (client.pack.equals(call_pack)) {
                        client.os.write(((String)cmd).getBytes());
                        client.os.flush();
                        sent = true;
                        continue;
                    }
                    if (!broadcast || !client.pack.startsWith(call_pack)) continue;
                    String fullcmd = client.pack + "." + call_func + call_args + "\n";
                    client.os.write(fullcmd.getBytes());
                    client.os.flush();
                    sent = true;
                }
            }
            if (!sent) {
                JFLog.log(port, "JBus : call to unregistered package.func:" + call_pack + "." + call_func);
            }
        }

        public boolean call(String pack, String func, String args) {
            return this.call(pack + "." + func + "(" + args + ")\n");
        }

        public boolean call(String pfa) {
            try {
                this.os.write(pfa.getBytes());
                this.os.flush();
                return true;
            }
            catch (Exception e) {
                JFLog.log(port, (Throwable)e);
                return false;
            }
        }
    }
}

