/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import javaforce.Base64;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.LDAP;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;
import javaforce.net.EMail;
import javaforce.net.IP4;
import javaforce.net.IP4Port;
import javaforce.net.Subnet4;
import javaforce.service.SMTPEvents;

public class SMTP
extends Thread {
    public static final String busPack = "net.sf.jfsmtp";
    public static boolean debug = false;
    private static SMTP smtp;
    private static SMTPEvents events;
    private static volatile boolean active;
    private static ArrayList<ServerWorker> servers;
    private static ArrayList<ClientWorker> clients;
    private static String domain;
    private static String ldap_domain;
    private static String ldap_server;
    private static ArrayList<EMail> users;
    private static Object lock;
    private static IP4Port bind;
    private static ArrayList<Subnet4> subnet_src_list;
    private static ArrayList<Integer> ports;
    private static ArrayList<Integer> ssl_ports;
    private static boolean digest;
    private static final String defaultConfig = "[global]\nport=25\n#port=587\n#secure=465\n#bind=192.168.100.2\n#domain=example.com\n#ldap_domain=example.org\n#ldap_server=192.168.200.2\n#account=user:pass\n#digest=true\n#src.ipnet=192.168.2.0/255.255.255.0\n#src.ip=192.168.3.2\n";
    private static JBusServer busServer;
    private JBusClient busClient;
    private String config;

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfsmtp.cfg";
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfsmtp.log";
    }

    public static String getMailboxFolder(String user) {
        StringBuilder path = new StringBuilder();
        if (JF.isWindows()) {
            path.append(System.getenv("ProgramData").replaceAll("\\\\", "/"));
            path.append("/jfsmtp/mail");
        } else {
            path.append("/var/jfsmtp/mail");
        }
        if (user != null) {
            path.append("/");
            path.append(user);
        }
        String mail = path.toString();
        new File(mail).mkdirs();
        return mail;
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33009;
        }
        return 777;
    }

    public void setEvents(SMTPEvents events) {
        SMTP.events = events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSession(ClientWorker sess) {
        Object object = lock;
        synchronized (object) {
            clients.add(sess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeSession(ClientWorker sess) {
        Object object = lock;
        synchronized (object) {
            clients.remove(sess);
        }
    }

    private static String getKeyFile() {
        return JF.getConfigPath() + "/jfsmtp.key";
    }

    @Override
    public void run() {
        JFLog.append(JF.getLogPath() + "/jfsmtp.log", true);
        JFLog.setRetention(30);
        JFLog.log("jfSMTP starting...");
        try {
            ServerWorker worker;
            this.loadConfig();
            this.busClient = new JBusClient(busPack, new JBusMethods());
            this.busClient.setPort(SMTP.getBusPort());
            this.busClient.start();
            for (int p : ports) {
                worker = new ServerWorker(p, false);
                worker.start();
                servers.add(worker);
            }
            for (int p : ssl_ports) {
                worker = new ServerWorker(p, true);
                worker.start();
                servers.add(worker);
            }
            while (active) {
                JF.sleep(1000);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        active = false;
        Object object = lock;
        synchronized (object) {
            ClientWorker[] ca;
            ServerWorker[] sa;
            for (ServerWorker s : sa = servers.toArray(new ServerWorker[0])) {
                s.close();
            }
            servers.clear();
            for (ClientWorker s : ca = clients.toArray(new ClientWorker[0])) {
                s.close();
            }
            clients.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadConfig() {
        JFLog.log("loadConfig");
        users = new ArrayList();
        Section section = Section.None;
        bind.setIP("0.0.0.0");
        SMTP.bind.port = 25;
        subnet_src_list = new ArrayList();
        try {
            BufferedReader br = new BufferedReader(new FileReader(SMTP.getConfigFile()));
            StringBuilder cfg = new StringBuilder();
            while (true) {
                String ln;
                if ((ln = br.readLine()) == null) {
                    br.close();
                    this.config = cfg.toString();
                    return;
                }
                cfg.append(ln);
                cfg.append("\n");
                ln = ln.trim();
                int cmt = ln.indexOf(35);
                if (cmt != -1) {
                    ln = ln.substring(0, cmt).trim();
                }
                if (ln.length() == 0) continue;
                if (ln.equals("[global]")) {
                    section = Section.Global;
                    continue;
                }
                int idx = ln.indexOf("=");
                if (idx == -1) continue;
                String key = ln.substring(0, idx);
                String value = ln.substring(idx + 1);
                block2 : switch (section) {
                    case None: 
                    case Global: {
                        switch (key) {
                            case "port": {
                                ports.add(Integer.valueOf(ln.substring(5)));
                                break;
                            }
                            case "secure": {
                                ssl_ports.add(Integer.valueOf(ln.substring(7)));
                                break;
                            }
                            case "bind": {
                                if (bind.setIP(value)) break;
                                JFLog.log("SMTP:bind:Invalid IP:" + value);
                                break;
                            }
                            case "account": {
                                EMail user = new EMail();
                                int cln = value.indexOf(58);
                                if (cln == -1) {
                                    JFLog.log("Invalid user:" + value);
                                    break block2;
                                }
                                user.user = value.substring(0, cln);
                                user.pass = value.substring(cln + 1);
                                users.add(user);
                                break;
                            }
                            case "domain": {
                                domain = value;
                                break;
                            }
                            case "ldap_domain": {
                                ldap_domain = value;
                                break;
                            }
                            case "ldap_server": {
                                ldap_server = value;
                                break;
                            }
                            case "digest": {
                                digest = value.equals("true");
                                break;
                            }
                            case "debug": {
                                debug = value.equals("true");
                                break;
                            }
                            case "src.ipnet": {
                                Subnet4 subnet = new Subnet4();
                                idx = value.indexOf(47);
                                if (idx == -1) {
                                    JFLog.log("SMTP:Invalid IP Subnet:" + value);
                                    break;
                                }
                                String ip = value.substring(0, idx);
                                String mask = value.substring(idx + 1);
                                if (!subnet.setIP(ip)) {
                                    JFLog.log("SMTP:Invalid IP:" + ip);
                                    break;
                                }
                                if (!subnet.setMask(mask)) {
                                    JFLog.log("SMTP:Invalid netmask:" + mask);
                                    break;
                                }
                                JFLog.log("Source Allow IP Network=" + subnet.toString());
                                subnet_src_list.add(subnet);
                                break;
                            }
                            case "src.ip": {
                                Subnet4 subnet = new Subnet4();
                                if (!subnet.setIP(value)) {
                                    JFLog.log("SMTP:Invalid IP:" + value);
                                    break;
                                }
                                subnet.setMask("255.255.255.255");
                                JFLog.log("Source Allow IP Address=" + subnet.toString());
                                subnet_src_list.add(subnet);
                                break;
                            }
                        }
                        break;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            JFLog.log("config not found, creating defaults.");
            try {
                FileOutputStream fos = new FileOutputStream(SMTP.getConfigFile());
                fos.write(defaultConfig.getBytes());
                fos.close();
                this.config = defaultConfig;
                return;
            }
            catch (Exception e2) {
                JFLog.log(e2);
                return;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static boolean login(String user, String pass) {
        for (EMail acct : users) {
            if (!acct.user.equals(user)) continue;
            return acct.pass.equals(pass);
        }
        if (ldap_server != null && ldap_domain != null) {
            LDAP ldap = new LDAP();
            return ldap.login(ldap_server, ldap_domain, user, pass);
        }
        return false;
    }

    private static boolean ip_src_allowed(String ip4) {
        if (subnet_src_list.size() == 0) {
            return true;
        }
        IP4 target = new IP4();
        if (!target.setIP(ip4)) {
            return false;
        }
        for (Subnet4 net : subnet_src_list) {
            if (!net.matches(target)) continue;
            return true;
        }
        return false;
    }

    private static boolean userExists(EMail email) {
        for (EMail acct : users) {
            if (!acct.user.equals(email.user)) continue;
            return true;
        }
        return false;
    }

    public static void serviceStart(String[] args) {
        if (JF.isWindows()) {
            busServer = new JBusServer(SMTP.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
        smtp = new SMTP();
        smtp.start();
    }

    public static void serviceStop() {
        smtp.close();
    }

    public static void main(String[] args) {
        SMTP.serviceStart(args);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                SMTP.serviceStop();
            }
        });
    }

    static {
        servers = new ArrayList();
        clients = new ArrayList();
        lock = new Object();
        bind = new IP4Port();
        ports = new ArrayList();
        ssl_ports = new ArrayList();
        digest = false;
    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            JBusClient cfr_ignored_0 = SMTP.smtp.busClient;
            JBusClient cfr_ignored_1 = SMTP.smtp.busClient;
            SMTP.smtp.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(SMTP.smtp.config)));
        }

        public void setConfig(String cfg) {
            JFLog.log("setConfig");
            try {
                FileOutputStream fos = new FileOutputStream(SMTP.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            JFLog.log("restart");
            smtp.close();
            smtp = new SMTP();
            smtp.start();
        }

        public void genKeys(String pack) {
            if (KeyMgmt.keytool(new String[]{"-genkey", "-debug", "-alias", "jfsmtp", "-keypass", "password", "-storepass", "password", "-keystore", SMTP.getKeyFile(), "-validity", "3650", "-dname", "CN=jfsmtp.sourceforge.net, OU=user, O=server, C=CA", "-keyalg", "RSA", "-keysize", "2048"})) {
                JFLog.log("Generated Keys");
                JBusClient cfr_ignored_0 = SMTP.smtp.busClient;
                SMTP.smtp.busClient.call(pack, "getKeys", JBusClient.quote("OK"));
            } else {
                JBusClient cfr_ignored_1 = SMTP.smtp.busClient;
                SMTP.smtp.busClient.call(pack, "getKeys", JBusClient.quote("ERROR"));
            }
        }
    }

    public static class ServerWorker
    extends Thread {
        private ServerSocket ss;
        private int port;
        private boolean secure;

        public ServerWorker(int port, boolean secure) {
            this.port = port;
            this.secure = secure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object keys;
                if (this.secure) {
                    JFLog.log("CreateServerSocketSSL");
                    keys = new KeyMgmt();
                    if (new File(SMTP.getKeyFile()).exists()) {
                        FileInputStream fis = new FileInputStream(SMTP.getKeyFile());
                        ((KeyMgmt)keys).open(fis, "password".toCharArray());
                        fis.close();
                    } else {
                        JFLog.log("Warning:Server SSL Keys not generated!");
                    }
                    this.ss = JF.createServerSocketSSL((KeyMgmt)keys);
                } else {
                    this.ss = new ServerSocket();
                }
                keys = bind;
                synchronized (keys) {
                    SMTP.bind.port = this.port;
                    this.ss.bind(bind.toInetSocketAddress());
                }
                active = true;
                while (active) {
                    Socket s = this.ss.accept();
                    InetSocketAddress sa = (InetSocketAddress)s.getRemoteSocketAddress();
                    String src_ip = sa.getAddress().getHostAddress();
                    if (src_ip.equals("0:0:0:0:0:0:0:1")) {
                        src_ip = "127.0.0.1";
                    }
                    if (!SMTP.ip_src_allowed(src_ip)) {
                        JFLog.log("SMTP:Source IP blocked:" + src_ip);
                        s.close();
                        continue;
                    }
                    ClientWorker sess = new ClientWorker(s, this.secure);
                    SMTP.addSession(sess);
                    sess.start();
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void close() {
            try {
                this.ss.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ss = null;
        }
    }

    public static class ClientWorker
    extends Thread {
        private Socket c;
        private boolean secure;
        private InputStream cis = null;
        private OutputStream cos = null;
        private byte[] req = new byte[1500];
        private int reqSize = 0;
        private byte[] buffer = new byte[1500];
        private int bufferSize = 0;
        private EMail from;
        private ArrayList<EMail> to = new ArrayList();

        public ClientWorker(Socket s, boolean secure) {
            this.c = s;
            this.secure = secure;
        }

        public void close() {
            if (this.c != null) {
                try {
                    this.c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.c = null;
            }
        }

        public String readln() {
            if (this.bufferSize > 0) {
                System.arraycopy(this.buffer, 0, this.req, 0, this.bufferSize);
                this.reqSize = this.bufferSize;
                this.bufferSize = 0;
            } else {
                this.reqSize = 0;
            }
            try {
                while (this.c != null && this.c.isConnected()) {
                    int read;
                    if (this.reqSize >= 2) {
                        for (int idx = 2; idx <= this.reqSize; ++idx) {
                            if (this.req[idx - 2] != 13 || this.req[idx - 1] != 10) continue;
                            int left = this.reqSize - idx;
                            if (left > 0) {
                                System.arraycopy(this.req, idx, this.buffer, 0, left);
                                this.bufferSize = left;
                            }
                            return new String(this.req, 0, idx - 2).trim();
                        }
                    }
                    if (this.reqSize == this.req.length) {
                        if (this.req.length >= 12000) {
                            throw new Exception("data too large");
                        }
                        int newSize = this.req.length << 1;
                        byte[] new_req = new byte[newSize];
                        this.buffer = new byte[newSize];
                        System.arraycopy(this.req, 0, new_req, 0, this.req.length);
                        this.req = new_req;
                    }
                    if ((read = this.cis.read(this.req, this.reqSize, this.req.length - this.reqSize)) >= 0) {
                        this.reqSize += read;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            return null;
        }

        @Override
        public void run() {
            block4: {
                try {
                    String cmd;
                    JFLog.log("Session start");
                    this.cis = this.c.getInputStream();
                    this.cos = this.c.getOutputStream();
                    this.cos.write(("220 jfSMTP Server/" + JF.getVersion() + "\r\n").getBytes());
                    while (this.c != null && this.c.isConnected() && (cmd = this.readln()) != null) {
                        if (cmd.equalsIgnoreCase("QUIT")) {
                            this.cos.write("221 Goodbye\r\n".getBytes());
                            break;
                        }
                        this.doCommand(cmd);
                    }
                }
                catch (Exception e) {
                    if (e instanceof SocketException) break block4;
                    JFLog.log(e);
                }
            }
            this.close();
            SMTP.removeSession(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCommand(String cmd) throws Exception {
            if (debug) {
                JFLog.log("Request=" + cmd);
            }
            String[] p = cmd.split(" ", 2);
            block11 : switch (p[0].toUpperCase()) {
                case "HELO": 
                case "EHLO": {
                    this.cos.write(("250 jfSMTP Server/" + JF.getVersion() + "\r\n").getBytes());
                    break;
                }
                case "AUTH": {
                    String type = p[1];
                    switch (type.toUpperCase()) {
                        case "LOGIN": {
                            this.cos.write("334 Send username\r\n".getBytes());
                            String user_base64 = this.readln();
                            if (user_base64 == null) {
                                this.close();
                                return;
                            }
                            String user = new String(Base64.decode(user_base64.getBytes()));
                            this.cos.write("334 Send password\r\n".getBytes());
                            String pass_base64 = this.readln();
                            if (pass_base64 == null) {
                                this.close();
                                return;
                            }
                            String pass = new String(Base64.decode(pass_base64.getBytes()));
                            if (SMTP.login(user, pass)) {
                                this.cos.write("235 Login successful\r\n".getBytes());
                                break block11;
                            }
                            JF.sleep(1000);
                            this.cos.write("501 Login failed\r\n".getBytes());
                            this.close();
                            return;
                        }
                    }
                    this.cos.write("504 Unknown AUTH type\r\n".getBytes());
                    break;
                }
                case "STARTTLS": {
                    if (this.secure) {
                        this.cos.write("550 Already secure\r\n".getBytes());
                        break;
                    }
                    this.cos.write("220 Ok\r\n".getBytes());
                    this.c = JF.connectSSL(this.c);
                    this.cis = this.c.getInputStream();
                    this.cos = this.c.getOutputStream();
                    this.secure = true;
                    break;
                }
                case "DATA": {
                    String filename;
                    if (this.from == null) {
                        this.cos.write("550 No from address\r\n".getBytes());
                        break;
                    }
                    if (this.to.size() == 0) {
                        this.cos.write("550 No recipients\r\n".getBytes());
                        break;
                    }
                    this.cos.write("354 Send Data\r\n".getBytes());
                    Object object = lock;
                    synchronized (object) {
                        filename = Long.toString(System.currentTimeMillis());
                        JF.sleep(10);
                    }
                    String basefile = SMTP.getMailboxFolder(null) + "/" + filename;
                    String quefile = basefile + ".que";
                    String msgfile = basefile + ".msg";
                    FileOutputStream questream = new FileOutputStream(quefile);
                    while (this.c != null && this.c.isConnected()) {
                        String ln = this.readln();
                        if (ln == null) {
                            this.close();
                            return;
                        }
                        if (ln.equals(".")) break;
                        ((OutputStream)questream).write(ln.getBytes());
                        ((OutputStream)questream).write("\r\n".getBytes());
                    }
                    ((OutputStream)questream).close();
                    new File(quefile).renameTo(new File(msgfile));
                    if (!digest) {
                        StringBuilder to_list = new StringBuilder();
                        for (EMail acct : this.to) {
                            to_list.append("to:");
                            to_list.append(acct.user);
                            to_list.append("\r\n");
                        }
                        byte[] to_data = to_list.toString().getBytes();
                        for (EMail acct : this.to) {
                            String userbox = SMTP.getMailboxFolder(acct.user);
                            String userbasefile = userbox + "/" + filename;
                            String userquefile = userbasefile + ".que";
                            String usermsgfile = userbasefile + ".msg";
                            FileOutputStream fos = new FileOutputStream(userquefile);
                            fos.write(to_data);
                            fos.close();
                            new File(userquefile).renameTo(new File(usermsgfile));
                        }
                    }
                    if (events != null) {
                        events.message(smtp, msgfile);
                    }
                    this.cos.write("250 Ok\r\n".getBytes());
                    this.reset();
                    break;
                }
                case "MAIL": {
                    if (this.from != null) {
                        this.cos.write("550 Already have from email\r\n".getBytes());
                        break;
                    }
                    this.from = new EMail();
                    if (!this.from.set(cmd)) {
                        this.from = null;
                        this.cos.write("550 Invalid from address\r\n".getBytes());
                        break;
                    }
                    this.cos.write("250 Ok\r\n".getBytes());
                    break;
                }
                case "RCPT": {
                    EMail email = new EMail();
                    if (!email.set(cmd)) {
                        this.cos.write("550 Invalid to address\r\n".getBytes());
                        break;
                    }
                    if (!digest) {
                        if (domain != null && !email.domain.equals(domain)) {
                            this.cos.write("550 Server will not relay messages\r\n".getBytes());
                            break;
                        }
                        if (!SMTP.userExists(email)) {
                            this.cos.write("550 User not found\r\n".getBytes());
                            break;
                        }
                    }
                    this.to.add(email);
                    this.cos.write("250 Ok\r\n".getBytes());
                    break;
                }
                default: {
                    this.cos.write("500 Unknown command\r\n".getBytes());
                }
            }
        }

        private void reset() {
            this.from = null;
            this.to.clear();
        }
    }

    static enum Section {
        None,
        Global;

    }
}

