/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import javaforce.JF;
import javaforce.ParseArgs;

public class FileSplitter {
    final int BUFSIZ = 65536;

    public static void main(String[] args) {
        FileSplitter x = new FileSplitter();
        x.main2(args);
    }

    void usage() {
        System.out.println("File splitter utility");
        System.out.println("Usage : filesplitter filein fileout1 fileout2 [size]");
        System.out.println("  size = size of fileout1 (default = 1/2 of filein)");
        System.exit(0);
    }

    void error(String msg) {
        System.out.println("Error : " + msg);
        System.exit(1);
    }

    void main2(String[] args) {
        int os;
        int read;
        ParseArgs pa = new ParseArgs();
        pa.arg_decoderefs = false;
        pa.arg_parse(args);
        if (pa.arg_names.size() < 3) {
            this.usage();
        }
        String fni = pa.arg_names.get(0);
        String fno1 = pa.arg_names.get(1);
        String fno2 = pa.arg_names.get(2);
        int size = 0;
        if (pa.arg_names.size() == 4) {
            size = (int)JF.fromEng(pa.arg_names.get(3));
        }
        byte[] buf = new byte[65536];
        FileInputStream fi = JF.fileopen(fni);
        if (fi == null) {
            JF.msg("Unable to open : " + fni);
            return;
        }
        int ifs = JF.filelength(fi);
        if (size > ifs) {
            JF.msg("size > sizeof(filein)");
            return;
        }
        if (size == 0) {
            size = ifs / 2;
        }
        FileOutputStream fo1 = JF.filecreate(fno1);
        FileOutputStream fo2 = JF.filecreate(fno2);
        for (os = 0; os < size; os += read) {
            read = os + 65536 < size ? JF.read(fi, buf, 0, 65536) : JF.read(fi, buf, 0, size - os);
            if (JF.write(fo1, buf, 0, read)) continue;
            JF.msg("write failed on fileout1");
            return;
        }
        size = ifs - size;
        for (os = 0; os < size; os += read) {
            read = os + 65536 < size ? JF.read(fi, buf, 0, 65536) : JF.read(fi, buf, 0, size - os);
            if (JF.write(fo2, buf, 0, read)) continue;
            JF.msg("write failed on fileout2");
            return;
        }
        JF.msg("Ok!");
    }
}

